/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.agrona.LangUtil;
import org.agrona.generation.CharSequenceJavaFileObject;
import org.agrona.generation.ClassFileManager;

public final class CompilerUtil {
    private CompilerUtil() {
    }

    public static Class<?> compileInMemory(String className, Map<String, CharSequence> sources) throws ClassNotFoundException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (null == compiler) {
            throw new IllegalStateException("JDK required to run tests. JRE is not sufficient.");
        }
        ClassFileManager<StandardJavaFileManager> fileManager = new ClassFileManager<StandardJavaFileManager>(compiler.getStandardFileManager(null, null, null));
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, CompilerUtil.wrap(sources));
        return CompilerUtil.compileAndLoad(className, diagnostics, fileManager, task);
    }

    public static Class<?> compileAndLoad(String className, DiagnosticCollector<JavaFileObject> diagnostics, JavaFileManager fileManager, JavaCompiler.CompilationTask task) throws ClassNotFoundException {
        if (!CompilerUtil.compile(diagnostics, task)) {
            return null;
        }
        return fileManager.getClassLoader(StandardLocation.CLASS_OUTPUT).loadClass(className);
    }

    public static boolean compile(DiagnosticCollector<JavaFileObject> diagnostics, JavaCompiler.CompilationTask task) {
        Boolean succeeded = task.call();
        if (!succeeded.booleanValue()) {
            for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
                System.err.println(diagnostic.getCode());
                System.err.println((Object)diagnostic.getKind());
                JavaFileObject source = diagnostic.getSource();
                System.err.printf("Line = %d, Col = %d, File = %s", diagnostic.getLineNumber(), diagnostic.getColumnNumber(), source);
                System.err.println("Start: " + diagnostic.getStartPosition());
                System.err.println("End: " + diagnostic.getEndPosition());
                System.err.println("Pos: " + diagnostic.getPosition());
                try {
                    String content = source.getCharContent(true).toString();
                    int begin = content.lastIndexOf(10, (int)diagnostic.getStartPosition());
                    int end = content.indexOf(10, (int)diagnostic.getEndPosition());
                    System.err.println(diagnostic.getMessage(null));
                    System.err.println(content.substring(Math.max(0, begin), end));
                }
                catch (IOException ex) {
                    LangUtil.rethrowUnchecked(ex);
                }
            }
        }
        return succeeded;
    }

    private static Collection<CharSequenceJavaFileObject> wrap(Map<String, CharSequence> sources) {
        return sources.entrySet().stream().map(e -> new CharSequenceJavaFileObject((String)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.toList());
    }
}

