/*
 * Decompiled with CFR 0.152.
 */
package org.aicer.hibiscus.http.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.aicer.hibiscus.exception.HibiscusException;
import org.aicer.hibiscus.http.client.Response;
import org.aicer.hibiscus.http.workers.HttpWorkerAbstract;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    private static final Logger log = Logger.getLogger(HttpClient.class);
    public static final String HEAD = "HEAD";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String DEFAULT_HTTP_ENCODING = "UTF-8";
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    public static final int DEFAULT_PORT_HTTP = 80;
    public static final int DEFAULT_PORT_HTTPS = 443;
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PATH = "/";
    private String encoding = "UTF-8";
    private int port = 80;
    private String scheme = "http";
    private String host = "localhost";
    private String path = "/";
    private String fragment = null;
    private String requestMethod = "GET";
    private String requestBody = null;
    private String lastRequest = null;
    private Response lastResponse = null;
    private final List<String> validHttpRequestMethods = new ArrayList<String>();
    private final List<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
    private final List<BasicNameValuePair> queryParameters = new ArrayList<BasicNameValuePair>();
    private final List<BasicNameValuePair> requestHeaders = new ArrayList<BasicNameValuePair>();
    private String rawUrl;

    public HttpClient() {
        this.validHttpRequestMethods.add(HEAD);
        this.validHttpRequestMethods.add(GET);
        this.validHttpRequestMethods.add(POST);
        this.validHttpRequestMethods.add(PUT);
        this.validHttpRequestMethods.add(DELETE);
    }

    public final HttpClient reset() {
        this.scheme = SCHEME_HTTP;
        this.host = DEFAULT_HOST;
        this.port = 80;
        this.path = DEFAULT_PATH;
        this.fragment = null;
        this.requestMethod = GET;
        this.lastRequest = null;
        this.lastResponse = null;
        this.requestBody = null;
        this.encoding = DEFAULT_HTTP_ENCODING;
        this.resetNameValuePairs();
        this.resetQueryParameters();
        return this;
    }

    public HttpClient setURI(String uri) throws HibiscusException {
        try {
            this.setURI(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new HibiscusException(e);
        }
        return this;
    }

    public HttpClient setURI(URI uri) {
        URIBuilder builder = new URIBuilder(uri);
        this.scheme = builder.getScheme();
        this.host = builder.getHost();
        this.port = builder.getPort();
        this.path = builder.getPath();
        this.fragment = builder.getFragment();
        this.resetQueryParameters();
        for (NameValuePair nvp : builder.getQueryParams()) {
            this.queryParameters.add(new BasicNameValuePair(nvp.getName(), nvp.getValue()));
        }
        return this;
    }

    public final String getRequestBody() {
        if (this.nameValuePairs.size() > 0) {
            return this.getNameValuePairsAsString();
        }
        return this.requestBody;
    }

    public final HttpClient setRequestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public final HttpClient setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public final int getPort() {
        return this.port;
    }

    public final HttpClient setPort(int port) {
        this.port = port;
        return this;
    }

    public final String getScheme() {
        return this.scheme;
    }

    public final HttpClient setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public final String getHost() {
        return this.host;
    }

    public final HttpClient setHost(String host) {
        this.host = host;
        return this;
    }

    public final String getPath() {
        return this.path;
    }

    public final HttpClient setPath(String path) {
        this.path = path;
        return this;
    }

    public final String getFragment() {
        return this.fragment;
    }

    public final HttpClient setFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public final HttpClient resetRequestBody() {
        this.resetNameValuePairs();
        this.requestBody = null;
        return this;
    }

    public final HttpClient resetHeaders() {
        this.requestHeaders.clear();
        return this;
    }

    public final HttpClient resetQueryParameters() {
        this.queryParameters.clear();
        return this;
    }

    public final HttpClient resetNameValuePairs() {
        this.nameValuePairs.clear();
        return this;
    }

    public final HttpClient addNameValuePair(String param, String value) {
        this.nameValuePairs.add(new BasicNameValuePair(param, value));
        return this;
    }

    public final HttpClient addNameValuePair(String param, Integer value) {
        return this.addNameValuePair(param, value.toString());
    }

    public final HttpClient addNameValuePair(String param, Double value) {
        return this.addNameValuePair(param, value.toString());
    }

    public List<BasicNameValuePair> getNameValuePairs() {
        return this.nameValuePairs;
    }

    public HttpClient addQueryParameter(String param, String value) {
        this.queryParameters.add(new BasicNameValuePair(param, value));
        return this;
    }

    public List<BasicNameValuePair> getQueryParameters() {
        return this.queryParameters;
    }

    public HttpClient addHeader(String param, String value) {
        this.requestHeaders.add(new BasicNameValuePair(param, value));
        return this;
    }

    public List<BasicNameValuePair> getRequestHeaders() {
        return this.requestHeaders;
    }

    public HttpClient removeHeader(String headerName) {
        int numberOfHeaders = this.requestHeaders.size();
        for (int i = 0; i < numberOfHeaders; ++i) {
            BasicNameValuePair header = this.requestHeaders.get(i);
            if (!header.getName().equals(headerName)) continue;
            this.requestHeaders.remove(i);
        }
        return this;
    }

    private String getNameValuePairsAsString() {
        String query = "";
        if (this.nameValuePairs.size() == 0) {
            return query;
        }
        URIBuilder builder = new URIBuilder().setScheme(SCHEME_HTTP).setHost(DEFAULT_HOST).setPath(DEFAULT_PATH);
        for (BasicNameValuePair nvp : this.nameValuePairs) {
            builder.setParameter(nvp.getName(), nvp.getValue());
        }
        try {
            query = builder.build().getRawQuery();
        }
        catch (URISyntaxException e) {
            log.debug((Object)"Error while attempting to build NVP entity", (Throwable)e);
        }
        return query;
    }

    public HttpClient execute() throws HibiscusException {
        HttpWorkerAbstract httpWorker = HttpWorkerAbstract.getWorkerStrategy(this.requestMethod, this);
        httpWorker.execute();
        this.lastResponse = httpWorker.getResponse();
        this.lastResponse.setElapsedTime(httpWorker.getResponseTime());
        return this;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public HttpClient setRequestMethod(String rMethod) throws HibiscusException {
        if (null == rMethod || !this.validHttpRequestMethods.contains(rMethod)) {
            throw new HibiscusException(rMethod + " is not a valid HTTP Request Method");
        }
        this.requestMethod = rMethod;
        return this;
    }

    public String getLastRequest() {
        return this.lastRequest;
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public String getRawUrl() {
        return this.rawUrl;
    }

    public HttpClient setRawUrl(String rawUrl) {
        this.rawUrl = rawUrl;
        return this;
    }
}

