/*
 * Decompiled with CFR 0.152.
 */
package org.aicer.hibiscus.http.workers;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.aicer.hibiscus.exception.HibiscusException;
import org.aicer.hibiscus.http.client.HttpClient;
import org.aicer.hibiscus.http.workers.HttpWorkerAbstract;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;

abstract class HttpEntityEnclosingRequestWorker
extends HttpWorkerAbstract {
    public HttpEntityEnclosingRequestWorker(HttpClient client, HttpEntityEnclosingRequestBase httpRequest) {
        super(client, (HttpRequestBase)httpRequest);
    }

    public void prepare() throws HibiscusException {
        int contentLength;
        HttpEntityEnclosingRequestBase request = (HttpEntityEnclosingRequestBase)this.httpRequest;
        try {
            request.setURI(this.getURI());
            for (BasicNameValuePair header : this.httpClient.getRequestHeaders()) {
                request.addHeader(header.getName(), header.getValue());
            }
        }
        catch (URISyntaxException e1) {
            throw new HibiscusException(e1);
        }
        String requestBody = this.httpClient.getRequestBody();
        int n = contentLength = null != requestBody ? requestBody.length() : 0;
        if (contentLength > 0) {
            try {
                request.setEntity((HttpEntity)new StringEntity(requestBody, this.httpClient.getEncoding()));
            }
            catch (UnsupportedEncodingException e2) {
                throw new HibiscusException("The encoding " + this.httpClient.getEncoding() + " is not supported", e2);
            }
        }
    }
}

