/*
 * Decompiled with CFR 0.152.
 */
package org.aicer.hibiscus.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.aicer.hibiscus.exception.HibiscusException;

public abstract class StreamUtil {
    public static final String NEWLINE = "\n";

    public static final String inputStreamToString(InputStream stream) throws HibiscusException {
        DataInputStream in = new DataInputStream(stream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuilder builder = new StringBuilder();
        String strLine = null;
        if (null == stream) {
            return null;
        }
        try {
            while ((strLine = br.readLine()) != null) {
                builder.append(strLine);
            }
        }
        catch (IOException e) {
            throw new HibiscusException(e);
        }
        return builder.toString();
    }

    public static final String inputStreamToString(InputStream stream, boolean keepNewlines) throws HibiscusException {
        if (!keepNewlines) {
            return StreamUtil.inputStreamToString(stream);
        }
        DataInputStream in = new DataInputStream(stream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuilder builder = new StringBuilder();
        String strLine = null;
        if (null == stream) {
            return null;
        }
        try {
            while ((strLine = br.readLine()) != null) {
                builder.append(strLine + NEWLINE);
            }
        }
        catch (IOException e) {
            throw new HibiscusException(e);
        }
        return builder.toString();
    }
}

