/*
 * Decompiled with CFR 0.152.
 */
package org.aicer.hibiscus.http.workers;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.aicer.hibiscus.exception.HibiscusException;
import org.aicer.hibiscus.http.client.HttpClient;
import org.aicer.hibiscus.http.client.Response;
import org.aicer.hibiscus.http.workers.HttpWorkerDelete;
import org.aicer.hibiscus.http.workers.HttpWorkerGet;
import org.aicer.hibiscus.http.workers.HttpWorkerHead;
import org.aicer.hibiscus.http.workers.HttpWorkerPost;
import org.aicer.hibiscus.http.workers.HttpWorkerPut;
import org.aicer.hibiscus.util.HashGenerator;
import org.aicer.hibiscus.util.StreamUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.log4j.Logger;

public abstract class HttpWorkerAbstract {
    public static final String HEAD = "HEAD";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    private static Logger log = Logger.getLogger(HttpWorkerAbstract.class);
    protected final HttpRequestBase httpRequest;
    protected Response response;
    protected final HttpClient httpClient;
    private long responseTime = 0L;

    protected HttpWorkerAbstract(HttpClient client, HttpRequestBase httpRequest) {
        this.httpClient = client;
        this.httpRequest = httpRequest;
    }

    public Response getResponse() {
        return this.response;
    }

    protected URI getURI() throws URISyntaxException {
        return new URI(this.httpClient.getRawUrl());
    }

    public abstract void prepare() throws HibiscusException;

    public void execute() throws HibiscusException {
        this.prepare();
        this.httpRequest.addHeader("User-Agent", this.getClass().getName().toUpperCase());
        this.httpRequest.addHeader("X-Conversation-Id", HashGenerator.getMD5Hash(System.currentTimeMillis() + "." + new Thread().getId()));
        SchemeRegistry registry = SchemeRegistryFactory.createDefault();
        PoolingClientConnectionManager connManager = new PoolingClientConnectionManager(registry);
        DefaultHttpClient requestClient = new DefaultHttpClient((ClientConnectionManager)connManager);
        try {
            long startTime = System.currentTimeMillis();
            HttpResponse response = requestClient.execute((HttpUriRequest)this.httpRequest);
            long elapsedTime = System.currentTimeMillis() - startTime;
            HttpEntity responseEntity = response.getEntity();
            this.responseTime = elapsedTime;
            this.response = new Response();
            this.response.setStatusLine(response.getStatusLine().toString());
            this.response.setResponseHeaders(response.getAllHeaders());
            if (null != responseEntity) {
                this.response.setResponseBody(StreamUtil.inputStreamToString(responseEntity.getContent()));
            }
            if (log.isDebugEnabled()) {
                this.debugRequest(response);
            }
        }
        catch (IOException e) {
            throw new HibiscusException(e);
        }
    }

    private void debugRequest(HttpResponse resp) {
        log.debug((Object)this.httpRequest.getRequestLine().toString());
        for (Header requestHeader : this.httpRequest.getAllHeaders()) {
            log.debug((Object)requestHeader.toString());
        }
        if (this.httpRequest instanceof HttpEntityEnclosingRequestBase && null != this.httpClient.getRequestBody()) {
            log.debug((Object)this.httpClient.getRequestBody());
        }
        log.debug((Object)resp.getStatusLine().toString());
        for (Header responseHeader : resp.getAllHeaders()) {
            log.debug((Object)responseHeader.toString());
        }
        log.debug((Object)this.response.getResponseBody());
        log.debug((Object)"////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////");
    }

    public final String getRequestMethod() {
        return this.httpRequest.getMethod();
    }

    public static HttpWorkerAbstract getWorkerStrategy(String requestMethod, HttpClient client) {
        if (requestMethod.equals(HEAD)) {
            return new HttpWorkerHead(client);
        }
        if (requestMethod.equals(GET)) {
            return new HttpWorkerGet(client);
        }
        if (requestMethod.equals(POST)) {
            return new HttpWorkerPost(client);
        }
        if (requestMethod.equals(PUT)) {
            return new HttpWorkerPut(client);
        }
        if (requestMethod.equals(DELETE)) {
            return new HttpWorkerDelete(client);
        }
        return new HttpWorkerGet(client);
    }

    public long getResponseTime() {
        return this.responseTime;
    }
}

