/*
 * Decompiled with CFR 0.152.
 */
package org.aicer.hibiscus.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.aicer.hibiscus.exception.HibiscusException;

public abstract class HashGenerator {
    private static final int MESSAGE_DIGEST_UPDATE_OFFSET = 0;
    private static final int BYTE_LENGTH_SHA1 = 40;
    private static final int BYTE_LENGTH_MD5 = 32;
    private static final String ENCODING_CHARSET_NAME = "utf-8";
    private static final String MESSAGE_DIGEST_ALGORITHM_SHA1 = "SHA-1";
    private static final String MESSAGE_DIGEST_ALGORITHM_MD5 = "MD5";

    private static String convertToHex(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfByte = data[i] >>> 4 & 0xF;
            int twoHalves = 0;
            do {
                if (0 <= halfByte && halfByte <= 9) {
                    buffer.append((char)(48 + halfByte));
                } else {
                    buffer.append((char)(97 + (halfByte - 10)));
                }
                halfByte = data[i] & 0xF;
            } while (twoHalves++ < 1);
        }
        return buffer.toString();
    }

    public static String getSHA1Hash(String input) throws HibiscusException {
        String hashValue = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM_SHA1);
            byte[] sha1Hash = new byte[40];
            messageDigest.update(input.getBytes(ENCODING_CHARSET_NAME), 0, input.length());
            sha1Hash = messageDigest.digest();
            hashValue = HashGenerator.convertToHex(sha1Hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HibiscusException("Unsupported Message Digest Algorithm SHA-1", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new HibiscusException("Unsupported Encoding utf-8", e);
        }
        return hashValue;
    }

    public static String getMD5Hash(String input) throws HibiscusException {
        String hashValue = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM_MD5);
            byte[] md5Hash = new byte[32];
            messageDigest.update(input.getBytes(ENCODING_CHARSET_NAME), 0, input.length());
            md5Hash = messageDigest.digest();
            hashValue = HashGenerator.convertToHex(md5Hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HibiscusException("Unsupported Message Digest Algorithm MD5", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new HibiscusException("Unsupported Encoding utf-8", e);
        }
        return hashValue;
    }
}

