/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.ExpandNode;
import org.aika.corpus.Option;
import org.aika.network.neuron.Activation;

public class Document
implements Comparable<Document> {
    String id;
    List<Annotation> annotations = new ArrayList<Annotation>();
    Set<Annotation>[] annotationsPerChar;
    public NavigableMap<ActivationKey, Activation> inputActivations = new TreeMap<ActivationKey, Activation>();
    public int primOptionIdCounter = 0;
    public int optionIdCounter = 1;
    public Option top = new Option(this, true, -1, Integer.MAX_VALUE, -1, -1, Integer.MAX_VALUE);
    public Option bottom = new Option(this, false, -1, 0, -1, -1, 0);
    private String content;
    public ExpandNode selectedExpandNode = null;
    public Option selectedOption = null;

    public Document(String id) {
        this.id = id;
        this.top.negation = this.bottom;
        this.bottom.negation = this.top;
        Option.addLink(this.bottom, this.top);
    }

    public static Document createDocument(String id, String content) {
        Document doc = new Document(id);
        doc.setContent(content);
        doc.finalizeDocument();
        return doc;
    }

    public String getId() {
        return this.id;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public int length() {
        return this.content.length();
    }

    public void addAnnotation(int begin, int end, String label, int level) {
        this.annotations.add(new Annotation(begin, end, label, level));
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Set<Annotation> getAnnotations(int pos) {
        Set apc = this.annotationsPerChar[pos];
        if (apc == null) {
            apc = Collections.EMPTY_SET;
        }
        return apc;
    }

    public void addInputActivation(Activation act) {
        if (act.key.pos >= 0 && act.key.pos < this.length()) {
            this.inputActivations.put(new ActivationKey(act.key.pos, act.key.o, act.node.id), act);
        }
    }

    public void removeInputActivation(Activation act) {
        this.inputActivations.remove(new ActivationKey(act.key.pos, act.key.o, act.node.id));
    }

    public Collection<Activation> getInputActivations(int pos) {
        if (this.inputActivations.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return this.inputActivations.subMap(new ActivationKey(pos, Option.MIN, Integer.MIN_VALUE), new ActivationKey(pos, Option.MAX, Integer.MAX_VALUE)).values();
    }

    public String toString() {
        return this.id;
    }

    public String conflictsToString() {
        HashSet<Option> conflicts = new HashSet<Option>();
        this.top.collectConflicts(conflicts, Option.visitedCounter++);
        StringBuilder sb = new StringBuilder();
        sb.append("Conflicts:\n");
        for (Option n : conflicts) {
            if (n.primaryConflicts == null) continue;
            for (Option.Conflict c : n.primaryConflicts.values()) {
                sb.append(c.key.primary.toString());
                sb.append(" : ");
                sb.append(c.key.secondary.toString());
                sb.append("\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public String selectedOptionsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Selected Options:\n");
        sb.append(this.selectedOption.toString());
        sb.append("\n");
        return sb.toString();
    }

    public void finalizeDocument() {
        this.annotationsPerChar = new Set[this.length() + 1];
        for (Annotation a : this.getAnnotations()) {
            for (int i = a.begin; i < a.end; ++i) {
                Set<Annotation> annoPerChar = this.annotationsPerChar[i];
                if (annoPerChar == null) {
                    this.annotationsPerChar[i] = annoPerChar = new TreeSet<Annotation>();
                }
                annoPerChar.add(a);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        Document document = (Document)o;
        return this.id.equals(document.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(Document d) {
        return this.id.compareTo(d.id);
    }

    public static final class Annotation
    implements Comparable<Annotation> {
        public final int begin;
        public final int end;
        public final String label;
        public final int level;

        public Annotation(int begin, int end, String label, int level) {
            this.begin = begin;
            this.end = end;
            this.label = label;
            this.level = level;
        }

        public int length() {
            return this.end - this.begin;
        }

        public String toString() {
            return "<" + this.begin + "," + this.end + ":" + this.level + " - " + this.label + ">";
        }

        @Override
        public int compareTo(Annotation a) {
            int r = this.level - a.level;
            if (r != 0) {
                return r;
            }
            r = this.length() - a.length();
            if (r != 0) {
                return r;
            }
            return this.label.compareTo(a.label);
        }
    }

    public static final class ActivationKey
    implements Comparable<ActivationKey> {
        public final int pos;
        public final Option option;
        public final int neuronId;

        public ActivationKey(int pos, Option option, int neuronId) {
            this.pos = pos;
            this.option = option;
            this.neuronId = neuronId;
        }

        @Override
        public int compareTo(ActivationKey ak) {
            int r = Integer.compare(this.pos, ak.pos);
            if (r != 0) {
                return r;
            }
            r = this.option.compareTo(ak.option);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(this.neuronId, ak.neuronId);
            return r;
        }
    }
}

