/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.corpus.Option;

public class ExpandNode {
    ExpandNode excludedParent;
    ExpandNode selectedParent;
    ExpandNode parent;
    ExpandNode nonConflictingBranch;
    ExpandNode conflictingBranch;
    long visited;
    Option refinement;
    double upperBound;
    double accumulatedWeight;
    HashSet<Option> conflicts = new HashSet();
    long debugId = debugIdCounter++;
    static long debugIdCounter = 0L;

    public ExpandNode(ExpandNode parent, ExpandNode selectedParent, ExpandNode excludedParent) {
        this.parent = parent;
        this.selectedParent = selectedParent;
        this.excludedParent = excludedParent;
    }

    public static void computeSelectedOption(Document doc) {
        ExpandNode root = new ExpandNode(null, null, null);
        root.refinement = doc.bottom;
        root.accumulatedWeight = 0.0;
        root.nonConflictingBranch = new ExpandNode(root, root, null);
        root.nonConflictingBranch.search(doc, true);
        if (doc.selectedExpandNode == null) {
            return;
        }
        ArrayList<Option> results = new ArrayList<Option>();
        doc.selectedExpandNode.collectResults(results);
        doc.selectedOption = Option.add(doc, true, results.toArray(new Option[results.size()]));
    }

    private void collectResults(List<Option> results) {
        results.add(this.refinement);
        if (this.selectedParent != null) {
            this.selectedParent.collectResults(results);
        }
    }

    private void search(Document doc, boolean branch) {
        this.generateCandidate(doc, branch);
        if (this.refinement == null) {
            return;
        }
        this.nonConflictingBranch = new ExpandNode(this, this, this.excludedParent);
        this.nonConflictingBranch.search(doc, true);
        this.conflictingBranch = new ExpandNode(this, this.selectedParent, this);
        this.conflictingBranch.search(doc, false);
    }

    private void generateCandidate(Document doc, boolean branch) {
        long ubVisited;
        this.upperBound = 0.0;
        this.accumulatedWeight = 0.0;
        TreeSet<Option> queue = new TreeSet<Option>(Option.SMALLEST_FIRST_COMPARATOR);
        doc.bottom.containedInUpperBound = ubVisited = Option.visitedCounter++;
        queue.add(doc.bottom);
        while (!queue.isEmpty()) {
            Option n = queue.pollFirst();
            if (!n.containedInUpperBound(ubVisited) || this.coveredConflicting(n)) continue;
            n.containedInUpperBound = ubVisited;
            if (n.weight > 0.0) {
                long v;
                ++Option.visitedCounter;
                Double naw = this.markCovered(v, n);
                if (naw == null) {
                    this.parent.conflicts.add(n);
                    continue;
                }
                double aw = (this.selectedParent != null ? this.selectedParent.accumulatedWeight : 0.0) + naw;
                this.upperBound += n.weight;
                if (this.accumulatedWeight < aw && (branch || this.isConflicting(n)) && !this.isCovered(n.markedCovered)) {
                    this.accumulatedWeight = aw;
                    this.refinement = n;
                }
            }
            for (Option c : n.children) {
                if (c.inv) continue;
                queue.add(c);
            }
        }
        if (doc.selectedExpandNode != null && this.upperBound < doc.selectedExpandNode.accumulatedWeight) {
            this.refinement = null;
        }
        if (this.refinement == null) {
            return;
        }
        this.visited = Option.visitedCounter++;
        this.accumulatedWeight = (this.selectedParent != null ? this.selectedParent.accumulatedWeight : 0.0) + this.markCovered(this.visited, this.refinement);
        if (doc.selectedExpandNode == null || this.accumulatedWeight > doc.selectedExpandNode.accumulatedWeight) {
            doc.selectedExpandNode = this;
        }
    }

    public boolean coveredConflicting(Option n) {
        return this.excludedParent != null && (this.excludedParent.refinement == n || this.excludedParent.coveredConflicting(n));
    }

    private boolean isCovered(long g) {
        return this.selectedParent != null && (g == this.selectedParent.visited || this.selectedParent.isCovered(g));
    }

    private Double markCovered(long v, Option n) {
        Double r;
        if (n.visitedMarkCovered == v) {
            return 0.0;
        }
        n.visitedMarkCovered = v;
        if (this.isCovered(n.markedCovered)) {
            return 0.0;
        }
        n.markedCovered = v;
        if (n.isBottom()) {
            return n.weight;
        }
        double result = n.weight;
        for (Option p : n.parents) {
            r = this.markCovered(v, p);
            if (r == null) {
                return null;
            }
            result += r.doubleValue();
        }
        for (Option c : n.children) {
            if (c.inv || c.visitedMarkCovered == v || !this.containedInSelectedBranch(v, c)) continue;
            if (c.isConflict) {
                return null;
            }
            c.markedCovered = v;
            r = this.markCovered(v, c);
            if (r == null) {
                return null;
            }
            result += r.doubleValue();
        }
        return result;
    }

    public boolean containedInSelectedBranch(long v, Option n) {
        for (Option p : n.parents) {
            if (p.markedCovered == v || this.isCovered(p.markedCovered)) continue;
            return false;
        }
        return true;
    }

    private boolean isConflicting(Option n) {
        return this.parent != null && (this.parent.checkForConflict(n) || this == this.parent.conflictingBranch && this.parent.isConflicting(n));
    }

    public boolean checkForConflict(Option n) {
        return this.conflicts.contains(n) || this.selectedParent != null && this.selectedParent.checkForConflict(n);
    }
}

