/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.network.Iteration;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.lattice.LatticeQueue;
import org.aika.utils.SetUtils;
import org.aika.utils.Timer;

public class Option
implements Comparable<Option> {
    public static final Option MIN = new Option(null, false, 0, 0, 0, 0, 0);
    public static final Option MAX = new Option(null, true, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0, Integer.MAX_VALUE);
    public static final Comparator<Option> SIZE_COMPARATOR = new Comparator<Option>(){

        @Override
        public int compare(Option n1, Option n2) {
            int r = Integer.compare(n2.length, n1.length);
            if (r != 0) {
                return r;
            }
            return Integer.compare(n1.id, n2.id);
        }
    };
    public static final Comparator<Option> SMALLEST_FIRST_COMPARATOR = new Comparator<Option>(){

        @Override
        public int compare(Option n1, Option n2) {
            int r = Integer.compare(n1.length, n2.length);
            if (r != 0) {
                return r;
            }
            return Integer.compare(n1.id, n2.id);
        }
    };
    public final boolean inv;
    public final int primId;
    public final int id;
    public final int length;
    public final int minPos;
    public final int maxPos;
    public Option negation;
    private long visitedComputeRelations = -1L;
    private long visitedOptimize = -1L;
    private long visitedLinkRelations = -1L;
    private long visitedLinkPrimitive = -1L;
    private long visitedContains = -1L;
    private long visitedCollectIds = -1L;
    private long visitedCount = -1L;
    public long visitedAccumulatedWeight = -1L;
    private long visitedOptionWeight = -1L;
    private long visitedCollectConflicts = -1L;
    private long visitedCollectAllOptions = -1L;
    private long visitedExpandActivations = -1L;
    private long visitedRemoveActivations = -1L;
    public long visitedMarkCovered = -1L;
    public long markedCovered = -1L;
    public long containedInUpperBound = -1L;
    public static long visitedCounter = 0L;
    public final Document doc;
    public boolean isRemoved;
    public int removedId;
    public static int removedIdCounter = 1;
    public ArrayList<Option> parents = new ArrayList();
    public ArrayList<Option> children = new ArrayList();
    public Map<Option, Boolean> cache = new HashMap<Option, Boolean>();
    public boolean isConflict;
    public Map<Option, Conflict> primaryConflicts;
    public Map<Option, Conflict> secondaryConflicts;
    public Map<Conflict.Key, Conflict> conflicts;
    public SortedSet<Activation> activations;
    public double weight;
    public double accumulatedWeight;
    public int refCount = 0;

    public Option(Document doc, boolean inv, int primId, int id, int minPos, int maxPos, int length) {
        this.doc = doc;
        this.inv = inv;
        this.primId = primId;
        this.id = id;
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.length = length;
        this.parents = new ArrayList();
        this.children = new ArrayList();
    }

    public void countRef() {
        if (this.isBottom() || this.isTop()) {
            return;
        }
        ++this.refCount;
    }

    public void releaseRef() {
        if (this.isBottom() || this.isTop()) {
            return;
        }
        assert (this.refCount > 0);
        --this.refCount;
        if (this.refCount == 0) {
            this.remove();
        }
    }

    public static void addConflict(Iteration t, Option primary, Option secondary) {
        Conflict c;
        Conflict conflict = c = primary.primaryConflicts != null ? primary.primaryConflicts.get(secondary) : null;
        if (c == null) {
            c = new Conflict(new Conflict.Key(primary, secondary), Option.add(primary.doc, false, primary, secondary));
            primary.countRef();
            secondary.countRef();
            c.conflict.countRef();
            c.conflict.isConflict = true;
            if (primary.primaryConflicts == null) {
                primary.primaryConflicts = new HashMap<Option, Conflict>();
            }
            primary.primaryConflicts.put(secondary, c);
            if (secondary.secondaryConflicts == null) {
                secondary.secondaryConflicts = new HashMap<Option, Conflict>();
            }
            secondary.secondaryConflicts.put(primary, c);
            if (c.conflict.conflicts == null) {
                c.conflict.conflicts = new TreeMap<Conflict.Key, Conflict>();
            }
            c.conflict.conflicts.put(c.key, c);
            c.conflict.removeActivationsRecursiveStep(t, visitedCounter++);
        }
    }

    private static void removeConflictInternal(Iteration t, Conflict c) {
        LatticeQueue queue = new LatticeQueue();
        c.conflict.expandActivationsRecursiveStep(queue, c.conflict, visitedCounter++);
        c.key.primary.releaseRef();
        c.key.secondary.releaseRef();
        c.conflict.releaseRef();
        queue.processChanges(t, false);
    }

    public static void removeConflict(Iteration t, Option primary, Option secondary) {
        Conflict c = primary.primaryConflicts.get(secondary);
        if (c == null) {
            return;
        }
        primary.primaryConflicts.remove(secondary);
        secondary.secondaryConflicts.remove(primary);
        c.conflict.conflicts.remove(c.key);
        Option.removeConflictInternal(t, c);
    }

    public void removeAllConflicts(Iteration t) {
        if (this.primaryConflicts != null) {
            for (Conflict c : this.primaryConflicts.values()) {
                c.key.secondary.secondaryConflicts.remove(c.key.primary);
                c.conflict.conflicts.remove(c.key);
                Option.removeConflictInternal(t, c);
            }
        }
        this.primaryConflicts = null;
        if (this.secondaryConflicts != null) {
            for (Conflict c : this.secondaryConflicts.values()) {
                c.key.primary.primaryConflicts.remove(c.key.secondary);
                c.conflict.conflicts.remove(c.key);
                Option.removeConflictInternal(t, c);
            }
        }
        this.secondaryConflicts = null;
        if (this.conflicts != null) {
            for (Conflict c : this.conflicts.values()) {
                c.key.primary.primaryConflicts.remove(c.key.secondary);
                c.key.secondary.secondaryConflicts.remove(c.key.primary);
                Option.removeConflictInternal(t, c);
            }
        }
        this.conflicts = null;
    }

    private void expandActivationsRecursiveStep(LatticeQueue queue, Option conflict, long v) {
        if (v == this.visitedExpandActivations) {
            return;
        }
        this.visitedExpandActivations = v;
        for (Activation act : this.getActivations()) {
            queue.addModification(act, true, true, conflict);
        }
        for (Option p : this.parents) {
            p.expandActivationsRecursiveStep(queue, conflict, v);
        }
    }

    private void removeActivationsRecursiveStep(Iteration t, long v) {
        if (v == this.visitedRemoveActivations) {
            return;
        }
        this.visitedRemoveActivations = v;
        for (Activation act : new ArrayList<Activation>(this.getActivations())) {
            LatticeQueue queue = new LatticeQueue();
            act.node.removeActivationAndPropagate(t, queue, act.key);
            queue.processChanges(t, false);
        }
        if (this.children != null) {
            for (Option c : new ArrayList<Option>(this.children)) {
                if (c.isRemoved) continue;
                c.removeActivationsRecursiveStep(t, v);
            }
        }
    }

    public SortedSet<Activation> getActivations() {
        return this.activations != null ? this.activations : SetUtils.EMPTY_SET;
    }

    public static Option add(Document doc, boolean nonConflicting, Option ... input) {
        Option nn;
        Option n;
        Timer.start("add");
        if (input.length == 0) {
            return doc.bottom;
        }
        ArrayList<Option> in = new ArrayList<Option>();
        int minPos = Integer.MAX_VALUE;
        int maxPos = 0;
        for (int i = 0; i < input.length; ++i) {
            n = input[i];
            assert (doc == n.doc);
            assert (!n.inv);
            assert (!n.isRemoved);
            boolean f = true;
            for (int j = 0; j < input.length; ++j) {
                Option x = input[j];
                if (i == j || !x.contains(n) || x == n && i >= j) continue;
                f = false;
                break;
            }
            if (!f) continue;
            in.add(n);
            minPos = Math.min(minPos, n.minPos);
            maxPos = Math.max(maxPos, n.maxPos);
        }
        if (in.size() == 1) {
            Option n2 = (Option)in.get(0);
            if (nonConflicting && n2.isConflict) {
                return null;
            }
            n2.countRef();
            Timer.stop("add");
            return n2;
        }
        Timer.start("add computeRelations children");
        ArrayList<Option> children = new ArrayList<Option>();
        Option.computeRelations(children, false, in, in, visitedCounter++);
        Timer.stop("add computeRelations children");
        if (children.size() == 1) {
            n = children.get(0);
            if (!n.inv) {
                if (nonConflicting && n.isConflict) {
                    return null;
                }
                n.countRef();
                Timer.stop("add");
                return n;
            }
        } else if (children.size() == 0) {
            children.add(doc.top);
        }
        Timer.start("add computeRelations parents");
        ArrayList<Option> parents = new ArrayList<Option>();
        Option.computeRelations(parents, true, in, children, visitedCounter++);
        Timer.stop("add computeRelations parents");
        if (nonConflicting) {
            for (Option p : parents) {
                if (!p.isConflict) continue;
                return null;
            }
        }
        Option n3 = new Option(doc, false, -1, doc.optionIdCounter++, minPos, maxPos, Option.computeLength(parents));
        n3.negation = nn = new Option(doc, true, -1, doc.optionIdCounter++, n3.minPos, n3.maxPos, Integer.MAX_VALUE - n3.length);
        nn.negation = n3;
        n3.linkRelations(parents, children, visitedCounter++);
        n3.countRef();
        TreeSet<Integer> ids = new TreeSet<Integer>();
        n3.collectPrimitiveIds(ids, visitedCounter++);
        assert (n3.length == ids.size());
        Timer.stop("add");
        return n3;
    }

    public static int computeLength(List<Option> parents) {
        Timer.start("computeLength");
        ArrayList<Option> count = new ArrayList<Option>();
        Option.computeLengthRecursiveStep(count, new ArrayList<Option>(), parents);
        int l = 0;
        for (Option n : count) {
            l += n.length;
        }
        Timer.stop("computeLength");
        return l;
    }

    private static void computeLengthRecursiveStep(List<Option> count, List<Option> parentOverlapping, List<Option> parents) {
        Option[] sortedParents = new Option[parents.size()];
        parents.toArray(sortedParents);
        Arrays.sort(sortedParents, SIZE_COMPARATOR);
        ArrayList<Option> overlapping = new ArrayList<Option>(parentOverlapping);
        for (Option p : sortedParents) {
            if (p.containedIn(parentOverlapping)) continue;
            List<Option> no = p.filterOutside(overlapping);
            if (no.isEmpty()) {
                count.add(p);
            } else {
                Option.computeLengthRecursiveStep(count, no, p.parents);
            }
            overlapping.add(p);
        }
    }

    public List<Option> filterOutside(List<Option> options) {
        ArrayList<Option> results = new ArrayList<Option>();
        for (Option n : options) {
            if (this.negation.contains(n)) continue;
            results.add(n);
        }
        return results;
    }

    private void computePrimitiveRelations(List<Option> results, long v) {
        if (v == this.visitedLinkPrimitive) {
            return;
        }
        this.visitedLinkPrimitive = v;
        boolean f = false;
        for (Option p : this.parents) {
            if (!p.inv) continue;
            f = true;
            p.computePrimitiveRelations(results, v);
        }
        if (!f) {
            results.add(this);
        }
    }

    private static void computeRelations(List<Option> results, boolean dir, List<Option> input, List<Option> start, long v) {
        Option bestN = null;
        int bestLength = dir ? Integer.MAX_VALUE : 0;
        for (Option s : start) {
            if (dir != bestLength >= s.length) continue;
            bestN = s;
            bestLength = s.length;
        }
        super.computeRelationsRecursiveStep(results, dir, input, v);
    }

    private void computeRelationsRecursiveStep(List<Option> results, boolean dir, List<Option> input, long v) {
        if (v == this.visitedComputeRelations) {
            return;
        }
        this.visitedComputeRelations = v;
        for (Option r : dir ? this.parents : this.children) {
            if (!dir && r.containsAll(input) || dir && r.containedIn(input)) {
                r.optimize(results, dir, input, v);
                continue;
            }
            if ((dir || r.negation.containedIn(input)) && (!dir || r.outsideOfAll(input))) continue;
            r.computeRelationsRecursiveStep(results, dir, input, v);
        }
    }

    private void optimize(List<Option> results, boolean dir, List<Option> input, long v) {
        if (v == this.visitedOptimize) {
            return;
        }
        this.visitedOptimize = v;
        boolean f = false;
        for (Option r : dir ? this.children : this.parents) {
            if (v == r.visitedComputeRelations || (dir || !r.containsAll(input)) && (!dir || !r.containedIn(input))) continue;
            f = true;
            r.optimize(results, dir, input, v);
        }
        if (!f) {
            results.add(this);
        }
    }

    private void linkRelations(List<Option> pSet, List<Option> cSet, long v) {
        for (Option p : pSet) {
            Option.addLink(p, this);
        }
        for (Option c : cSet) {
            c.visitedLinkRelations = v;
            Option.addLink(this, c);
        }
        for (Option p : pSet) {
            ArrayList<Option> tmp = new ArrayList<Option>();
            for (Option c : p.children) {
                if (c.visitedLinkRelations != v) continue;
                tmp.add(c);
            }
            for (Option c : tmp) {
                Option.removeLink(p, c);
            }
        }
    }

    public boolean containedIn(Collection<Option> input) {
        if (this.inv) {
            return false;
        }
        if (this.containedInAny(input)) {
            return true;
        }
        if (this.outsideOfAll(input)) {
            return false;
        }
        for (Option p : this.parents) {
            if (p.containedIn(input)) continue;
            return false;
        }
        return true;
    }

    public static void addLink(Option a, Option b) {
        a.children.add(b);
        b.parents.add(a);
        if (a != b.negation) {
            b.negation.children.add(a.negation);
            a.negation.parents.add(b.negation);
        }
    }

    public static void removeLink(Option a, Option b) {
        a.children.remove(b);
        b.parents.remove(a);
        if (a != b.negation) {
            b.negation.children.remove(a.negation);
            a.negation.parents.remove(b.negation);
        }
    }

    public static Option addPrimitive(Document doc, int pos) {
        int primId = doc.primOptionIdCounter++;
        Option n = new Option(doc, false, primId, doc.optionIdCounter++, pos, pos, 1);
        Option nn = new Option(doc, true, primId, doc.optionIdCounter++, pos, pos, 0x7FFFFFFE);
        nn.negation = n;
        n.negation = nn;
        ArrayList<Option> children = new ArrayList<Option>();
        doc.top.computePrimitiveRelations(children, visitedCounter++);
        n.linkRelations(Arrays.asList(doc.bottom), children, visitedCounter++);
        n.countRef();
        return n;
    }

    private void remove() {
        assert (!this.inv);
        assert (!this.isRemoved);
        this.isRemoved = true;
        this.removedId = removedIdCounter++;
        for (Option p : this.parents) {
            p.children.remove(this);
            if (p == this.negation) continue;
            p.negation.parents.remove(this.negation);
        }
        for (Option c : this.children) {
            c.parents.remove(this);
            if (this == c.negation) continue;
            c.negation.children.remove(this.negation);
        }
        for (Option p : this.parents) {
            for (Option c : this.children) {
                if (c.isLinked(p, visitedCounter++)) continue;
                Option.addLink(p, c);
            }
        }
        this.parents = null;
        this.children = null;
        this.conflicts = null;
        this.negation.negation = null;
        this.negation = null;
    }

    public void count() {
        this.countRecursiveStep(this, visitedCounter++);
    }

    private void countRecursiveStep(Option so, long v) {
        if (v == this.visitedCount) {
            return;
        }
        this.visitedCount = v;
        for (Activation act : this.getActivations()) {
            act.node.countActivation(act.key, so);
        }
        for (Option p : this.parents) {
            p.countRecursiveStep(so, v);
        }
    }

    public void computeOptionWeights(long v) {
        if (v == this.visitedOptionWeight) {
            return;
        }
        this.visitedOptionWeight = v;
        this.weight = 0.0;
        for (Activation act : this.getActivations()) {
            if (act.node.neuron == null || !act.shadowedBy.isEmpty()) continue;
            this.weight += act.weight;
        }
        for (Option p : this.parents) {
            p.computeOptionWeights(v);
        }
    }

    public boolean isTop() {
        return this.length == Integer.MAX_VALUE;
    }

    public boolean isBottom() {
        return this.length == 0;
    }

    public boolean outsideOfAll(Collection<Option> input) {
        for (Option n : input) {
            if (n.negation.contains(this)) continue;
            return false;
        }
        return true;
    }

    public boolean containedInAny(Collection<Option> input) {
        for (Option n : input) {
            if (!n.contains(this)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(List<Option> input) {
        for (Option n : input) {
            if (this.contains(n)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Option n) {
        boolean r = this.contains(n, true, visitedCounter++);
        return r;
    }

    public boolean contains(boolean dir, Option n) {
        boolean r = !dir ? this.contains(n, true, visitedCounter++) : n.contains(this, true, visitedCounter++);
        return r;
    }

    private boolean contains(Option n, boolean start, long v) {
        assert (this.visitedContains <= v);
        assert (!this.isRemoved);
        assert (!n.isRemoved);
        if (!this.inv && n.inv) {
            return false;
        }
        if (this == n || this.isTop() || n.isBottom()) {
            return true;
        }
        this.visitedContains = v;
        if (this.length < n.length) {
            return false;
        }
        if (this.maxPos < n.minPos || n.maxPos < this.minPos) {
            return this.inv != n.inv;
        }
        Boolean cv = this.cache.get(n);
        if (cv != null) {
            return cv;
        }
        boolean result = false;
        for (Option p : this.parents) {
            if (p.visitedContains == v || !p.contains(n, false, v)) continue;
            result = true;
            break;
        }
        if (start) {
            this.cache.put(n, result);
        }
        return result;
    }

    private boolean isLinked(Option n, long v) {
        assert (this.visitedContains <= v);
        assert (!this.isRemoved);
        assert (!n.isRemoved);
        if (this == n) {
            return true;
        }
        this.visitedContains = v;
        if (this.length < n.length) {
            return false;
        }
        for (Option p : this.parents) {
            if (p.visitedContains == v || !p.isLinked(n, v)) continue;
            return true;
        }
        return false;
    }

    public void collectExpandNodeRefinements(Set<Option> results, long v) {
        if (this.visitedCollectAllOptions == v) {
            return;
        }
        this.visitedCollectAllOptions = v;
        if (this.isBottom()) {
            return;
        }
        if (!this.inv && !this.isConflict && this.weight > 0.0) {
            results.add(this);
        }
        for (Option p : this.parents) {
            p.collectExpandNodeRefinements(results, v);
        }
    }

    private void collectPrimitiveIds(Set<Integer> results, long v) {
        if (v == this.visitedCollectIds) {
            return;
        }
        this.visitedCollectIds = v;
        if (this.primId >= 0) {
            results.add(this.primId);
        } else {
            for (Option n : this.inv ? this.children : this.parents) {
                n.collectPrimitiveIds(results, v);
            }
        }
    }

    public boolean containedInUpperBound(long v) {
        for (Option p : this.parents) {
            if (p.containedInUpperBound == v) continue;
            return false;
        }
        return true;
    }

    public void verify() {
        if (this.primId != -1) {
            return;
        }
        HashSet<Integer> posIds = new HashSet<Integer>();
        HashSet<Integer> negIds = new HashSet<Integer>();
        this.collectPrimitiveIds(posIds, false, visitedCounter++);
        this.collectPrimitiveIds(negIds, true, visitedCounter++);
        HashSet<Integer> tmp = new HashSet<Integer>();
        for (Option n : this.doc.bottom.children) {
            if (n.primId < 0) continue;
            tmp.add(n.primId);
        }
        if (tmp.size() != posIds.size() + negIds.size()) {
            System.out.println();
            tmp.removeAll(posIds);
            tmp.removeAll(negIds);
            assert (false);
        }
    }

    private void collectPrimitiveIds(Set<Integer> results, boolean dir, long v) {
        if (v == this.visitedCollectIds) {
            return;
        }
        this.visitedCollectIds = v;
        if (this.primId >= 0) {
            results.add(this.primId);
        } else {
            for (Option n : dir ? this.children : this.parents) {
                n.collectPrimitiveIds(results, dir, v);
            }
        }
    }

    public void collectConflicts(Set<Option> conflicts, long v) {
        if (this.visitedCollectConflicts == v) {
            return;
        }
        this.visitedCollectConflicts = v;
        for (Option n : this.parents) {
            if (this.isConflict) {
                conflicts.add(n);
            }
            n.collectConflicts(conflicts, v);
        }
    }

    public static Option create(Document doc, Integer ... ids) {
        HashSet<Integer> tmp = new HashSet<Integer>(Arrays.asList(ids));
        ArrayList<Option> primOptions = new ArrayList<Option>();
        for (Option p : doc.bottom.children) {
            if (!tmp.contains(p.primId)) continue;
            primOptions.add(p);
        }
        return Option.add(doc, false, primOptions.toArray(new Option[primOptions.size()]));
    }

    public double computeAccumulatedWeight(long v) {
        if (v == this.visitedAccumulatedWeight) {
            return 0.0;
        }
        this.visitedAccumulatedWeight = v;
        double accWeight = this.weight;
        for (Option p : this.parents) {
            accWeight += p.computeAccumulatedWeight(v);
        }
        return accWeight;
    }

    public String toString() {
        TreeSet<Integer> ids = new TreeSet<Integer>();
        this.collectPrimitiveIds(ids, visitedCounter++);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (this.inv) {
            sb.append("!");
        }
        boolean first = true;
        for (Integer id : ids) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(id);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(Option n) {
        int r = Integer.compare(this.length, n.length);
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.id, n.id);
    }

    public static class Conflict {
        public Key key;
        public Option conflict;

        public Conflict(Key key, Option conflict) {
            this.key = key;
            this.conflict = conflict;
        }

        public static class Key
        implements Comparable<Key> {
            public Option primary;
            public Option secondary;

            public Key(Option primary, Option secondary) {
                assert (primary.length == 1);
                this.primary = primary;
                this.secondary = secondary;
            }

            @Override
            public int compareTo(Key ck) {
                int r = this.primary.compareTo(ck.primary);
                if (r != 0) {
                    return r;
                }
                return this.secondary.compareTo(ck.secondary);
            }
        }
    }
}

