/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network;

import java.util.ArrayList;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.corpus.ExpandNode;
import org.aika.corpus.Option;
import org.aika.network.Network;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.lattice.AndNode;
import org.aika.network.neuron.lattice.Node;

public class Iteration {
    public static final double WEIGHT_TOLERANCE = 0.01;
    public Document doc;
    public TreeSet<AndNode> weightChanged = new TreeSet();
    public TreeSet<Node> hasActivations = new TreeSet();
    public TreeSet<Node> addedNodes = new TreeSet();
    public static int numberOfPositionsDelta;

    public Iteration(Document doc) {
        this.doc = doc;
    }

    public void process() {
        double maxDelta;
        do {
            maxDelta = 0.0;
            for (Node n : this.hasActivations) {
                for (Activation act : n.getActivations()) {
                    maxDelta = Math.max(maxDelta, act.computeWeight());
                }
            }
        } while (maxDelta > 0.01);
        this.doc.top.computeOptionWeights(Option.visitedCounter++);
        ExpandNode.computeSelectedOption(this.doc);
    }

    public void train() {
        Network.numberOfPositions += numberOfPositionsDelta;
        numberOfPositionsDelta = 0;
        this.doc.selectedOption.count();
        for (Node node : this.hasActivations) {
            if (!node.frequencyHasChanged) continue;
            if (node instanceof AndNode && Network.trainingInterval.contains(node.frequency)) {
                this.weightChanged.add((AndNode)node);
            }
            if (node.neuron == null) continue;
            node.neuron.propagateInputFrequencyChange(this);
        }
        for (Node node : new ArrayList<Node>(this.hasActivations)) {
            if (node.frequencyHasChanged) {
                node.train(this);
            }
            node.frequencyHasChanged = false;
        }
        for (AndNode andNode : this.weightChanged) {
            andNode.computeWeight();
        }
    }

    public void clearActivations() {
        for (Node n : this.hasActivations) {
            n.clearActivations();
        }
    }

    public void changeNumberOfPositions(int delta) {
        if (Network.trainingInterval.contains(Network.numberOfPositions + (numberOfPositionsDelta += delta))) {
            for (Node n : Network.allNodes) {
                if (!(n instanceof AndNode)) continue;
                this.weightChanged.add((AndNode)n);
            }
        }
    }
}

