/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.network.Iteration;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.lattice.AndNode;
import org.aika.network.neuron.lattice.NegativeInputNode;
import org.aika.network.neuron.lattice.Node;
import org.aika.utils.SetUtils;
import org.aika.utils.StringUtils;

public class Network {
    public static Set<Integer> trainingInterval;
    public static Map<String, Neuron> labeledNeurons;
    public static List<NegativeInputNode> negationNodes;
    public static Set<Neuron> publishedNeurons;
    public static Set<Node> allNodes;
    public static int numberOfPositions;

    public static void run(TreeSet<Document> inputs) {
        int i;
        for (Document doc : inputs) {
            doc.finalizeDocument();
        }
        while (!inputs.isEmpty()) {
            int pos;
            Document doc = inputs.pollFirst();
            Iteration t = new Iteration(doc);
            t.changeNumberOfPositions(1);
            NegativeInputNode.addInitialActivations(t);
            System.out.println(doc.getId() + " - " + doc.getContent() + "\n");
            for (pos = 0; pos < doc.length() + 1; ++pos) {
                System.out.println("Pos: " + pos);
                for (Document.Annotation a : doc.getAnnotations(pos)) {
                    Neuron is = Neuron.createOrLookupInputSignal(a.label, false);
                    is.node.addActivationAndPropagate(t, null, new Activation.Key(pos, doc.bottom, 0), 0, null, SetUtils.EMPTY_SET);
                }
            }
            t.process();
            for (pos = 0; pos < doc.length() + 1; ++pos) {
                System.out.println("Pos: " + pos);
                System.out.println(Network.networkStateToString(doc, pos, true, true));
            }
            System.out.println();
            System.out.println(doc.conflictsToString());
            System.out.println();
            System.out.println(doc.selectedOptionsToString());
            for (pos = 0; pos < doc.length() + 1; ++pos) {
                System.out.println("Pos: " + pos);
                System.out.println(Network.networkStateToString(doc, pos, false, true));
            }
            t.train();
            t.clearActivations();
            System.out.println();
        }
        System.out.println();
        System.out.println("Network Weights:");
        System.out.println(Network.networkWeightsToString());
        System.out.println();
        System.out.println();
        System.out.println("Pattern Lattice:");
        System.out.println(Network.patternLatticeToString());
        System.out.println();
        System.out.println("Publication Candidates:");
        ArrayList<AndNode> results = new ArrayList<AndNode>();
        ArrayList<AndNode[]> resultsReducedSig = new ArrayList<AndNode[]>();
        for (Node node : allNodes) {
            if (!(node instanceof AndNode)) continue;
            AndNode an = (AndNode)node;
            if (an.weight > 0.99 && an.shadowedInput) {
                results.add(an);
            }
            if (!(an.weight > 0.99)) continue;
            for (AndNode cn : node.andChildren.values()) {
                if (!(an.weight > cn.weight)) continue;
                resultsReducedSig.add(new AndNode[]{an, cn});
            }
        }
        for (i = 0; i < results.size(); ++i) {
            AndNode andNode = (AndNode)results.get(i);
            System.out.println(i + " \"" + StringUtils.extractSyllable(andNode) + "\"  " + andNode.toString() + " ShouldBePublished:" + andNode.shouldBePublished);
        }
        System.out.println();
        for (i = 0; i < resultsReducedSig.size(); ++i) {
            AndNode[] andNodeArray = (AndNode[])resultsReducedSig.get(i);
            if (Network.countNumberOfChars(StringUtils.extractSyllable(andNodeArray[0])) < Network.countNumberOfChars(StringUtils.extractSyllable(andNodeArray[1]))) {
                System.out.println(i + " \"" + StringUtils.extractSyllable(andNodeArray[0]) + "\"  " + andNodeArray[0].toString() + "   " + " \"" + StringUtils.extractSyllable(andNodeArray[1]) + "\"  " + andNodeArray[1].toString());
            }
            if (i % 500 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    public static int countNumberOfChars(String s) {
        int c = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') continue;
            ++c;
        }
        return c;
    }

    public static boolean hasSignificantChildren(AndNode n) {
        for (AndNode cn : n.andChildren.values()) {
            if (cn.weight > 0.99) {
                return true;
            }
            if (!Network.hasSignificantChildren(cn)) continue;
            return true;
        }
        return false;
    }

    public static void reset() {
        labeledNeurons = new LinkedHashMap<String, Neuron>();
        negationNodes = new ArrayList<NegativeInputNode>();
        publishedNeurons = new HashSet<Neuron>();
    }

    public static void resetFrequency() {
        for (Node n : allNodes) {
            n.frequency = 0;
        }
    }

    public static String networkStateToString(Document doc, Integer pos, boolean allOrOnlySelectedOptions, boolean withWeights) {
        TreeSet<Activation> acts = new TreeSet<Activation>(new Comparator<Activation>(){

            @Override
            public int compare(Activation act1, Activation act2) {
                int r = Integer.compare(act1.key.fired, act2.key.fired);
                if (r != 0) {
                    return r;
                }
                r = Integer.compare(act1.node.id, act2.node.id);
                if (r != 0) {
                    return r;
                }
                r = act1.key.o.compareTo(act2.key.o);
                return r;
            }
        });
        for (Neuron n : publishedNeurons) {
            if (allOrOnlySelectedOptions) {
                acts.addAll(n.node.getActivations(pos));
                continue;
            }
            acts.addAll(n.node.getMatchingActivations(pos, doc.selectedOption, false, false));
        }
        StringBuilder sb = new StringBuilder();
        double weightSum = 0.0;
        for (Activation act : acts) {
            if (!act.shadowedBy.isEmpty()) continue;
            sb.append("  ");
            if (allOrOnlySelectedOptions) {
                sb.append(act.key.o.toString());
                sb.append(" - ");
            }
            sb.append(act.node.toString());
            sb.append(" - Fired:");
            sb.append(act.key.fired);
            sb.append(" - RC:");
            sb.append(act.recurrentCount);
            if (withWeights) {
                sb.append(" - W:");
                sb.append(act.weight);
            }
            weightSum += act.weight;
            sb.append("\n");
        }
        sb.append("\nWeightSum:" + weightSum + "\n");
        return sb.toString();
    }

    public static String networkWeightsToString() {
        StringBuilder sb = new StringBuilder();
        for (Neuron n : publishedNeurons) {
            if (n.node.frequency <= 0) continue;
            sb.append(n.toStringWithSynapses());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String patternLatticeToString() {
        StringBuilder sb = new StringBuilder();
        for (Node p : allNodes) {
            sb.append(p.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    static {
        labeledNeurons = new LinkedHashMap<String, Neuron>();
        negationNodes = new ArrayList<NegativeInputNode>();
        publishedNeurons = new TreeSet<Neuron>();
        allNodes = new TreeSet<Node>();
        trainingInterval = new HashSet<Integer>();
        for (int i = 0; i < 10000; ++i) {
            double x = i;
            double y = Math.pow(x, 1.3);
            trainingInterval.add((int)Math.floor(y));
            if (i >= 10) continue;
            trainingInterval.add(i);
        }
    }
}

