/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.aika.corpus.Document;
import org.aika.corpus.Option;
import org.aika.network.neuron.lattice.Node;

public class Activation
implements Comparable<Activation> {
    public static double MIN_WEIGHT = -100.0;
    public static double MAX_WEIGHT = 100.0;
    public static double WEIGHT_MIX = 0.7;
    public static double TOLERANCE = 0.01;
    public final Key key;
    public Node node;
    public boolean isRemoved;
    public int removedId;
    public static int removedIdCounter = 1;
    public double weight;
    public int recurrentCount;
    public Option exclusionOption;
    public Set<Activation> shadows = new TreeSet<Activation>();
    public Set<Activation> shadowedBy = new TreeSet<Activation>();
    public TreeSet<Activation> uses;
    public Set<Activation> usedBy;

    public Activation(Key key) {
        this.key = key;
    }

    public Activation(int pos, Option o, int fired) {
        this.key = new Key(pos, o, fired);
    }

    public Activation(int pos, Option o, int fired, int id) {
        this.key = new Key(pos, o, fired, id);
    }

    public void linkActivationsBackwards(TreeSet<Activation> inputActs) {
        for (Activation inputAct : inputActs) {
            if (inputAct == null) continue;
            if (inputAct.usedBy == null) {
                inputAct.usedBy = new HashSet<Activation>();
            }
            inputAct.usedBy.add(this);
        }
        if (this.uses == null) {
            this.uses = inputActs;
        } else {
            this.uses.addAll(inputActs);
        }
    }

    public void linkActivationsBackwards(Activation ... inputActs) {
        for (Activation inputAct : inputActs) {
            if (inputAct == null) continue;
            if (inputAct.usedBy == null) {
                inputAct.usedBy = new HashSet<Activation>();
            }
            inputAct.usedBy.add(this);
            if (this.uses == null) {
                this.uses = new TreeSet();
            }
            this.uses.add(inputAct);
        }
    }

    public void unlinkAllActivationsBackwards() {
        if (this.uses != null) {
            for (Activation usedAct : this.uses) {
                usedAct.usedBy.remove(this);
            }
            this.uses = null;
        }
    }

    public double computeWeight() {
        double maxWeight = 0.0;
        if (this.usedBy != null) {
            for (Activation act : this.usedBy) {
                if (!(maxWeight < act.weight)) continue;
                maxWeight = act.weight;
            }
        }
        double newWeight = maxWeight * WEIGHT_MIX + (1.0 - WEIGHT_MIX) * (this.node != null ? this.node.getWeight() : 0.0);
        double delta = newWeight - this.weight;
        this.weight = newWeight;
        return delta;
    }

    public void register() {
        if (this.key.o.activations == null) {
            this.key.o.activations = new TreeSet<Activation>();
        }
        this.key.o.activations.add(this);
    }

    public void unregister() {
        assert (!this.key.o.activations.isEmpty());
        this.key.o.activations.remove(this);
    }

    public String toString(Document doc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ACT ");
        sb.append(this.key.pos);
        sb.append(":");
        sb.append(doc.getContent().substring(Math.max(0, this.key.pos - 3), Math.min(doc.length(), this.key.pos + 3)));
        sb.append(":");
        sb.append(this.node);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(Activation act) {
        int r;
        if (this.node == null && act.node != null) {
            return -1;
        }
        if (this.node != null && act.node == null) {
            return 1;
        }
        if (this.node != null && act.node != null && (r = this.node.compareTo(act.node)) != 0) {
            return r;
        }
        return this.key.compareTo(act.key);
    }

    public static final class Key
    implements Comparable<Key> {
        public final int pos;
        public final Option o;
        public final int fired;
        public final int id;
        private int refCount = 0;

        public Key(int pos, Option o, int fired) {
            this(pos, o, fired, 0);
        }

        public Key(int pos, Option o, int fired, int id) {
            this.pos = pos;
            this.o = o;
            this.fired = fired;
            this.id = id;
            this.countRef();
            o.countRef();
        }

        public boolean shadows(Key k) {
            assert (this.pos == k.pos);
            return k.o.contains(this.o) && this.fired <= k.fired && (k.o.length != this.o.length || this.fired != k.fired || this.id <= k.id);
        }

        public void countRef() {
            ++this.refCount;
        }

        public void releaseRef() {
            assert (this.refCount > 0);
            --this.refCount;
            if (this.refCount == 0) {
                this.o.releaseRef();
            }
        }

        @Override
        public int compareTo(Key k) {
            int r = Integer.compare(this.pos, k.pos);
            if (r != 0) {
                return r;
            }
            r = this.o.compareTo(k.o);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(this.fired, k.fired);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.id, k.id);
        }

        public String toString() {
            return this.pos + " " + this.o + " " + this.fired + " " + this.id;
        }
    }
}

