/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.network.Iteration;
import org.aika.network.Network;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.lattice.AndNode;
import org.aika.network.neuron.lattice.InputNode;
import org.aika.network.neuron.lattice.NegativeInputNode;
import org.aika.network.neuron.lattice.Node;
import org.aika.network.neuron.lattice.PositiveInputNode;

public class Neuron
implements Comparable<Neuron> {
    public static final int MAX_RECURRENT_ACTIVATIONS = 10;
    public static int currentNeuronId = 0;
    public int id = currentNeuronId++;
    public String label;
    public double bias;
    public SortedMap<Neuron, Synapse> inputSynapses = new TreeMap<Neuron, Synapse>();
    public SortedMap<Neuron, Synapse> outputSynapses = new TreeMap<Neuron, Synapse>();
    public TreeMap<InputNode.Key, InputNode> outputNodes = new TreeMap();
    public Node node;
    public boolean isPredefined;
    public boolean isPublished;
    public boolean isBlocked;

    public Neuron() {
    }

    public Neuron(String label) {
        this.label = label;
    }

    public Neuron(String label, boolean isBlocked) {
        this.label = label;
        this.isBlocked = isBlocked;
    }

    public PositiveInputNode getPositiveOutputNode() {
        return (PositiveInputNode)this.outputNodes.get(new InputNode.Key(false, 0));
    }

    public NegativeInputNode getNegativeOutputNode() {
        return (NegativeInputNode)this.outputNodes.get(new InputNode.Key(true, 0));
    }

    public void publish() {
        Network.publishedNeurons.add(this);
        PositiveInputNode.add(this, false, 0, null);
    }

    public void unpublish() {
        Network.publishedNeurons.remove(this);
        while (!this.outputNodes.isEmpty()) {
            this.outputNodes.pollFirstEntry().getValue().remove();
        }
    }

    public void propagateAddedActivation(Iteration t, Activation act) {
        for (InputNode in : new ArrayList<InputNode>(this.outputNodes.values())) {
            in.addActivation(t, act);
        }
    }

    public void propagateRemovedActivation(Iteration t, Activation act) {
        for (InputNode in : new ArrayList<InputNode>(this.outputNodes.values())) {
            in.removeActivation(t, act.key);
        }
    }

    public void propagateInputFrequencyChange(Iteration t) {
        for (InputNode in : this.outputNodes.values()) {
            if (!Network.trainingInterval.contains(in.frequency)) continue;
            for (AndNode n : in.getAndChildPatterns(new HashSet<AndNode>())) {
                t.weightChanged.add(n);
            }
        }
    }

    public void remove() {
        this.unpublish();
        for (Synapse is : this.inputSynapses.values()) {
            is.input.outputSynapses.remove(is.output);
        }
        for (Synapse is : this.outputSynapses.values()) {
            is.output.inputSynapses.remove(is.input);
        }
    }

    public static Neuron createNeuron(Neuron n, double bias, Set<Synapse> inputs, boolean predefined) {
        n.isPredefined = predefined;
        for (Synapse s : inputs) {
            n.inputSynapses.put(s.input, s);
            s.output = n;
        }
        n.bias = bias;
        Node.addNeuron(n, inputs);
        n.publish();
        return n;
    }

    public static Neuron createOrLookupInputSignal(String label) {
        return Neuron.createOrLookupInputSignal(label, false);
    }

    public static Neuron createOrLookupInputSignal(String label, boolean isBlocked) {
        Neuron n = Network.labeledNeurons.get(label);
        if (n == null) {
            n = Neuron.createNeuron(new Neuron(label, isBlocked), -0.5, new TreeSet<Synapse>(), true);
            Network.labeledNeurons.put(label, n);
        }
        return n;
    }

    public static Neuron createAndNeuron(Neuron n, Set<Input> inputs) {
        TreeSet<Synapse> is = new TreeSet<Synapse>();
        double bias = 0.5;
        for (Input ni : inputs) {
            Synapse s = new Synapse(ni.inputNeuron, ni.ink.posDelta);
            s.w = ni.ink.isNeg ? -1.0f : 1.0f;
            bias -= 1.0;
            is.add(s);
        }
        return Neuron.createNeuron(n, bias, is, true);
    }

    public static Neuron createOrNeuron(Neuron n, Set<Input> inputs) {
        n.isPredefined = true;
        TreeSet<Synapse> is = new TreeSet<Synapse>();
        double bias = -0.5;
        for (Input ni : inputs) {
            Synapse s = new Synapse(ni.inputNeuron, ni.ink.posDelta);
            s.w = ni.ink.isNeg ? -1.0f : 1.0f;
            is.add(s);
        }
        Neuron.createNeuron(n, bias, is, true);
        return n;
    }

    public static Neuron createNegationNeuron(Neuron n, Neuron input, int posDelta) {
        n.isPredefined = true;
        Synapse s = new Synapse(input, posDelta);
        s.w = -1.0f;
        TreeSet<Synapse> inputs = new TreeSet<Synapse>();
        inputs.add(s);
        Neuron.createNeuron(n, 0.5, inputs, true);
        return n;
    }

    public static Neuron createRecurrentNeuron(Neuron n, Neuron input, Neuron deactivatingSignal, int dsPosDelta, Integer deactivationCount, boolean firstIncluded, boolean direction) {
        n.isPredefined = true;
        int posDelta = direction ? 1 : -1;
        TreeSet<Synapse> inputs = new TreeSet<Synapse>();
        Synapse is = new Synapse(input, firstIncluded ? 0 : posDelta);
        is.w = 1.0f;
        inputs.add(is);
        if (deactivationCount != null) {
            Synapse recs = new Synapse(n, posDelta, deactivationCount);
            recs.w = 1.0f;
            inputs.add(recs);
        }
        if (deactivatingSignal != null) {
            Synapse ds = new Synapse(deactivatingSignal, dsPosDelta);
            ds.w = -2.0f;
            inputs.add(ds);
        }
        Neuron.createNeuron(n, -2.5, inputs, true);
        return n;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("N(");
        sb.append(this.id);
        if (this.label != null) {
            sb.append(",");
            sb.append(this.label);
        }
        sb.append(")");
        return sb.toString();
    }

    public String toStringWithSynapses() {
        TreeSet<Synapse> is = new TreeSet<Synapse>(new Comparator<Synapse>(){

            @Override
            public int compare(Synapse s1, Synapse s2) {
                int r = Float.compare(s2.w, s1.w);
                if (r != 0) {
                    return r;
                }
                return Integer.compare(s1.input.id, s2.input.id);
            }
        });
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        sb.append("<");
        sb.append("B:");
        sb.append(this.bias);
        sb.append(", ");
        for (Synapse s : is) {
            sb.append(s.w);
            sb.append(":");
            sb.append(s.input.toString());
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(Neuron n) {
        if (this.id < n.id) {
            return -1;
        }
        if (this.id > n.id) {
            return 1;
        }
        return 0;
    }

    public static final class Input
    implements Comparable<Input> {
        public final InputNode.Key ink;
        public final Neuron inputNeuron;

        public Input(boolean isNeg, int posDelta, Neuron inputNeuron) {
            this.ink = new InputNode.Key(isNeg, posDelta);
            this.inputNeuron = inputNeuron;
        }

        public Input(InputNode.Key ink, Neuron inputNeuron) {
            this.ink = ink;
            this.inputNeuron = inputNeuron;
        }

        @Override
        public int compareTo(Input in) {
            int r = this.ink.compareTo(in.ink);
            if (r != 0) {
                return r;
            }
            return this.inputNeuron.compareTo(in.inputNeuron);
        }
    }
}

