/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.lattice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Option;
import org.aika.network.Iteration;
import org.aika.network.Network;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.lattice.InputNode;
import org.aika.network.neuron.lattice.LatticeQueue;
import org.aika.network.neuron.lattice.LogicNode;
import org.aika.network.neuron.lattice.Node;
import org.aika.network.neuron.lattice.OrNode;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

public class AndNode
extends LogicNode {
    public double weight = 0.0;
    public SortedMap<InputNode, Node> parents = new TreeMap<InputNode, Node>();
    public Neuron publishedPatternNeuron = null;
    public boolean isSignificant;
    public AndNode directSignificantAncestor = null;
    public SortedSet<AndNode> significantAncestors;
    public boolean shadowedInput = false;
    public boolean shouldBePublished = false;

    public AndNode(int level, SortedMap<InputNode, Node> parents) {
        super(level);
        this.parents = parents;
        for (Map.Entry<InputNode, Node> me : parents.entrySet()) {
            me.getValue().andChildren.put(me.getKey(), this);
            me.getValue().andChildrenWithinDocument.put(me.getKey(), this);
        }
    }

    public void addActivation(Iteration t, LatticeQueue queue, Activation.Key ak, int recurrentCount, TreeSet<Activation> inputActs) {
        this.addActivationAndPropagate(t, queue, ak, recurrentCount, null, inputActs);
    }

    protected void removeActivation(Iteration t, LatticeQueue queue, Activation.Key ak) {
        for (Activation act : this.getMatchingActivations(ak.pos, ak.o, true, true)) {
            this.removeActivationAndPropagate(t, queue, act.key);
        }
    }

    @Override
    public void setActivationsEmpty() {
        for (Map.Entry<InputNode, Node> me : this.parents.entrySet()) {
            me.getValue().andChildrenWithinDocument.remove(me.getKey());
        }
    }

    public void computeWeight() {
        if (Network.numberOfPositions == 0 || this.frequency < Node.minFrequency) {
            return;
        }
        double nullHyp = 1.0;
        for (InputNode ref : this.parents.keySet()) {
            Node in = ref.inputNeuron.node;
            double p = (double)in.frequency / (double)Network.numberOfPositions;
            if (p > 1.0) {
                p = 1.0;
            }
            nullHyp *= p;
        }
        BinomialDistribution binDist = new BinomialDistribution(null, Network.numberOfPositions, nullHyp);
        this.weight = binDist.cumulativeProbability(this.frequency - 1);
        this.n = Network.numberOfPositions;
        if (this.level == 2) {
            double minPRel = 1.0;
            for (Map.Entry<InputNode, Node> me : this.parents.entrySet()) {
                double p = 1.0 - (double)this.frequency / (double)me.getValue().frequency;
                if (!(minPRel > p)) continue;
                minPRel = p;
            }
            if (minPRel < 0.1) {
                this.shadowedInput = true;
            }
        }
        this.setSignificant(this.weight > 0.99);
    }

    public Map<Node, Double> computeMinPRel() {
        TreeMap<Node, Double> result = new TreeMap<Node, Double>();
        for (Map.Entry<InputNode, Node> me : this.parents.entrySet()) {
            double p = 1.0 - (double)this.frequency / (double)me.getValue().frequency;
            result.put(me.getValue(), p);
            p = 1.0 - (double)this.frequency / (double)me.getKey().inputNeuron.node.frequency;
            result.put(me.getKey(), p);
        }
        return result;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public void setSignificant(boolean sig) {
        if (this.isSignificant != sig) {
            this.isSignificant = sig;
            this.propagateSignificance();
        }
    }

    private void collectCoveredSignificantAncestors(Set<AndNode> results) {
        for (AndNode sa : this.significantAncestors) {
            results.add(sa);
            sa.collectCoveredSignificantAncestors(results);
        }
    }

    public void propagateSignificance() {
        if (this.isSignificant) {
            this.significantAncestors = new TreeSet<AndNode>();
            TreeSet<AndNode> coveredSignificantAncestors = new TreeSet<AndNode>();
            for (AndNode cp : this.andChildren.values()) {
                if (!cp.isSignificant || cp.directSignificantAncestor == null) continue;
                this.significantAncestors.add(cp.directSignificantAncestor);
                cp.directSignificantAncestor.collectCoveredSignificantAncestors(coveredSignificantAncestors);
            }
            this.significantAncestors.removeAll(coveredSignificantAncestors);
            if (this.significantAncestors.size() == 1) {
                if (this.directSignificantAncestor == this) {
                    this.shouldBePublished = false;
                }
                this.directSignificantAncestor = this.significantAncestors.first();
            } else {
                if (this.directSignificantAncestor != this) {
                    this.shouldBePublished = true;
                }
                this.directSignificantAncestor = this;
            }
        } else {
            if (this.directSignificantAncestor == this) {
                this.shouldBePublished = false;
            }
            this.directSignificantAncestor = null;
        }
        for (Node pn : this.parents.values()) {
            if (!(pn instanceof AndNode)) continue;
            AndNode apn = (AndNode)pn;
            if (!apn.isSignificant) continue;
            apn.propagateSignificance();
        }
    }

    public void publish() {
        if (!this.isPredefined && this.publishedPatternNeuron == null) {
            TreeSet<AndNode> significantLowerBound = new TreeSet<AndNode>();
            AndNode.collectSignificantLower(significantLowerBound, new TreeSet<AndNode>(), Collections.singleton(this));
            TreeSet<Node> nonSignificantUpperBound = AndNode.computeNonSignificantUpperBound(significantLowerBound);
            this.publishedPatternNeuron = this.computeNeuron(significantLowerBound, nonSignificantUpperBound);
        }
    }

    public void unpublish() {
        if (this.publishedPatternNeuron != null) {
            this.publishedPatternNeuron.unpublish();
        }
    }

    private Neuron computeNeuron(TreeSet<AndNode> significantLowerBound, TreeSet<Node> nonSignificantUpperBound) {
        double[] c;
        TreeMap<InputNode, Integer> indexes = new TreeMap<InputNode, Integer>();
        ArrayList<InputNode> revIndexes = new ArrayList<InputNode>();
        for (AndNode n : significantLowerBound) {
            for (InputNode in : n.parents.keySet()) {
                if (indexes.containsKey(in)) continue;
                indexes.put(in, indexes.size());
                revIndexes.add(in);
            }
        }
        double[] objF = new double[indexes.size() + 1];
        objF[0] = 1.0;
        LinearObjectiveFunction f = new LinearObjectiveFunction(objF, 0.0);
        LinearConstraint[] constraintArr = new LinearConstraint[significantLowerBound.size() + nonSignificantUpperBound.size()];
        int i = 0;
        for (AndNode andNode : significantLowerBound) {
            c = new double[indexes.size() + 1];
            c[0] = 1.0;
            for (InputNode in : andNode.parents.keySet()) {
                c[((Integer)indexes.get((Object)in)).intValue() + 1] = in.key.isNeg ? -1.0 : 1.0;
            }
            constraintArr[i] = new LinearConstraint(c, Relationship.GEQ, 0.5);
            ++i;
        }
        for (Node node : nonSignificantUpperBound) {
            c = new double[indexes.size() + 1];
            c[0] = 1.0;
            if (node instanceof InputNode) {
                c[((Integer)indexes.get((Object)node)).intValue() + 1] = ((InputNode)node).key.isNeg ? -1.0 : 1.0;
            } else if (node instanceof AndNode) {
                for (InputNode in : ((AndNode)node).parents.keySet()) {
                    c[((Integer)indexes.get((Object)in)).intValue() + 1] = in.key.isNeg ? -1.0 : 1.0;
                }
            }
            constraintArr[i] = new LinearConstraint(c, Relationship.LEQ, -0.5);
            ++i;
        }
        LinearConstraintSet constraints = new LinearConstraintSet(constraintArr);
        SimplexSolver simplexSolver = new SimplexSolver();
        PointValuePair solution = simplexSolver.optimize(new OptimizationData[]{f, constraints, GoalType.MAXIMIZE, new NonNegativeConstraint(false)});
        double bias = ((double[])solution.getKey())[0];
        TreeSet<Synapse> synapses = new TreeSet<Synapse>();
        for (int j = 1; j < ((double[])solution.getKey()).length; ++j) {
            InputNode in = (InputNode)revIndexes.get(j - 1);
            Synapse s = new Synapse(in.inputNeuron, in.key.posDelta);
            s.w = (float)((double[])solution.getKey())[j];
            synapses.add(s);
        }
        return Neuron.createNeuron(new Neuron(), bias, synapses, false);
    }

    public static void collectSignificantLower(Set<AndNode> significantLowerBound, Set<AndNode> coveredByCurrentLevel, Set<AndNode> currentLevelNodes) {
        TreeSet<AndNode> nextLevelNodes = new TreeSet<AndNode>();
        for (AndNode n : currentLevelNodes) {
            if (n.level <= 2) continue;
            for (Node pn : n.parents.values()) {
                nextLevelNodes.add((AndNode)pn);
            }
        }
        TreeSet<AndNode> coveredByNextLevel = new TreeSet<AndNode>();
        if (!nextLevelNodes.isEmpty()) {
            AndNode.collectSignificantLower(significantLowerBound, coveredByNextLevel, nextLevelNodes);
        }
        for (AndNode cn : coveredByNextLevel) {
            coveredByCurrentLevel.addAll(cn.andChildren.values());
        }
        for (AndNode n : currentLevelNodes) {
            if (!n.isSignificant || coveredByCurrentLevel.contains(n)) continue;
            significantLowerBound.add(n);
            coveredByCurrentLevel.add(n);
        }
    }

    private static TreeSet<Node> computeNonSignificantUpperBound(TreeSet<AndNode> significantLowerBound) {
        TreeSet<Node> nonSignificantUpperBound = new TreeSet<Node>();
        for (AndNode n : significantLowerBound) {
            nonSignificantUpperBound.addAll(n.parents.values());
        }
        return nonSignificantUpperBound;
    }

    public String significantAncestorsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SA:{");
        boolean first = true;
        if (this.significantAncestors != null) {
            for (AndNode sa : this.significantAncestors) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(sa.id);
                first = false;
            }
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void cleanup() {
        if (!this.isRemoved && !this.isFrequentOrPredefined()) {
            this.remove();
        }
    }

    @Override
    public void expandToNextLevel(Iteration t, LatticeQueue queue, Activation act, Option conflict, boolean train) {
        if (act.isRemoved) {
            return;
        }
        for (Map.Entry<InputNode, Node> mea : this.parents.entrySet()) {
            Node pn = mea.getValue();
            for (Map.Entry<InputNode, AndNode> meb : new TreeMap<InputNode, AndNode>((SortedMap<InputNode, AndNode>)pn.andChildrenWithinDocument).entrySet()) {
                AndNode.processCandidate(t, queue, this, meb.getValue(), meb.getKey(), act, conflict, train);
            }
        }
        OrNode.processCandidate(t, queue, this, act, conflict, train);
    }

    public static void processCandidate(Iteration t, LatticeQueue queue, Node firstNode, Node secondNode, InputNode refinement, Activation act, Option conflict, boolean train) {
        if (firstNode != secondNode) {
            if (train) {
                if (firstNode.isFrequentOrPredefined()) {
                    AndNode.createNextLevelPattern(t, queue, firstNode, refinement);
                }
            } else {
                AndNode.addActivationsToNextLevelPattern(t, queue, firstNode, secondNode, refinement, act, conflict);
            }
        }
    }

    public static void createNextLevelPattern(Iteration t, LatticeQueue queue, Node firstNode, InputNode refinement) {
        if (firstNode.andChildren.containsKey(refinement)) {
            return;
        }
        TreeSet<InputNode> inputs = new TreeSet<InputNode>();
        firstNode.collectNodeAndRefinements(inputs);
        inputs.add(refinement);
        for (InputNode in : inputs) {
            if (!in.isBlocked && in.inputNeuron != null && !in.inputNeuron.isBlocked) continue;
            return;
        }
        SortedMap<InputNode, Node> nlParents = AndNode.computeParents(inputs);
        if (nlParents != null) {
            AndNode.prepareNextLevelPattern(t, queue, firstNode.level + 1, nlParents);
        }
    }

    public static void addActivationsToNextLevelPattern(Iteration t, LatticeQueue queue, Node firstNode, Node secondNode, InputNode refinement, Activation act, Option conflict) {
        Activation.Key ak = act.key;
        AndNode nlp = firstNode.andChildren.get(refinement);
        if (nlp == null) {
            return;
        }
        boolean first = true;
        for (Activation secondAct : secondNode.getActivations(ak.pos)) {
            Option o = Option.add(t.doc, true, ak.o, secondAct.key.o);
            if (o == null || conflict != null && !o.contains(conflict)) continue;
            if (first) {
                for (Map.Entry<InputNode, Node> me : nlp.parents.entrySet()) {
                    me.getValue().andChildrenWithinDocument.put(me.getKey(), nlp);
                }
                first = false;
            }
            TreeSet<Activation> inputActs = new TreeSet<Activation>();
            if (act.uses != null) {
                inputActs.addAll(act.uses);
            }
            if (secondAct.uses != null) {
                inputActs.addAll(secondAct.uses);
            }
            nlp.addActivation(t, queue, new Activation.Key(ak.pos, o, Math.max(ak.fired, secondAct.key.fired)), Math.max(act.recurrentCount, secondAct.recurrentCount), inputActs);
        }
    }

    public static SortedMap<InputNode, Node> computeParents(Set<InputNode> inputs) {
        HashSet<Node> visited = new HashSet<Node>();
        TreeMap<InputNode, Node> parents = new TreeMap<InputNode, Node>();
        for (InputNode a : inputs) {
            TreeSet<InputNode> childInputs = new TreeSet<InputNode>(inputs);
            childInputs.remove(a);
            if (a.computeAndParents(childInputs, parents, visited)) continue;
            return null;
        }
        return parents;
    }

    private static void prepareNextLevelPattern(Iteration t, LatticeQueue queue, int level, SortedMap<InputNode, Node> parents) {
        assert (level == parents.size());
        for (InputNode ref : parents.keySet()) {
            if (ref.inputNeuron == null || !ref.inputNeuron.isBlocked) continue;
            return;
        }
        AndNode nlp = new AndNode(level, parents);
        nlp.computePatternActivations(t, queue, parents.values());
        t.addedNodes.add(nlp);
    }

    @Override
    protected void collectNodeAndRefinements(Set<InputNode> inputs) {
        inputs.addAll(this.parents.keySet());
    }

    @Override
    public double computeSynapseWeightSum(Neuron n) {
        double sum = n.bias;
        for (InputNode ref : this.parents.keySet()) {
            Synapse s = (Synapse)n.inputSynapses.get(ref.inputNeuron);
            sum += (double)Math.abs(s.w);
        }
        return sum;
    }

    private void computePatternActivations(Iteration t, LatticeQueue queue, Collection<Node> parentNodes) {
        Iterator<Node> it = parentNodes.iterator();
        Node firstParentNode = it.next();
        Node secondParentNode = it.next();
        ArrayList<Activation> tmpActs = new ArrayList<Activation>();
        Activation lastAct = null;
        for (Activation firstAct : firstParentNode.activations.values()) {
            if (lastAct != null && lastAct.key.pos != firstAct.key.pos) {
                this.computePatternActivationsIntern(t, queue, lastAct.key.pos, tmpActs, secondParentNode.getActivations(lastAct.key.pos));
                tmpActs.clear();
            }
            tmpActs.add(firstAct);
            lastAct = firstAct;
        }
        if (lastAct != null) {
            this.computePatternActivationsIntern(t, queue, lastAct.key.pos, tmpActs, secondParentNode.getActivations(lastAct.key.pos));
        }
    }

    private void computePatternActivationsIntern(Iteration t, LatticeQueue queue, int pos, Iterable<Activation> firstOGActivations, Iterable<Activation> secondOGActivations) {
        for (Activation firstAct : firstOGActivations) {
            for (Activation secondAct : secondOGActivations) {
                Option o = Option.add(t.doc, true, firstAct.key.o, secondAct.key.o);
                if (o == null) continue;
                TreeSet<Activation> inputActs = new TreeSet<Activation>();
                if (firstAct.uses != null) {
                    inputActs.addAll(firstAct.uses);
                }
                if (secondAct.uses != null) {
                    inputActs.addAll(secondAct.uses);
                }
                this.addActivation(t, queue, new Activation.Key(pos, o, Math.max(firstAct.key.fired, secondAct.key.fired)), Math.max(firstAct.recurrentCount, secondAct.recurrentCount), inputActs);
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (Map.Entry<InputNode, Node> me : this.parents.entrySet()) {
            me.getValue().andChildren.remove(me.getKey());
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AND[");
        boolean first = true;
        for (InputNode ref : this.parents.keySet()) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(ref.logicToString());
        }
        sb.append("]");
        return sb.toString();
    }
}

