/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.lattice;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.aika.corpus.Option;
import org.aika.network.Iteration;
import org.aika.network.Network;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.lattice.AndNode;
import org.aika.network.neuron.lattice.LatticeQueue;
import org.aika.network.neuron.lattice.NegativeInputNode;
import org.aika.network.neuron.lattice.Node;
import org.aika.network.neuron.lattice.OrNode;
import org.aika.network.neuron.lattice.PositiveInputNode;

public abstract class InputNode
extends Node {
    public Neuron inputNeuron;
    public Key key;
    public Integer deactivationCount;

    public abstract Activation addActivation(Iteration var1, Activation var2);

    public abstract void removeActivation(Iteration var1, Activation.Key var2);

    public InputNode(Key key) {
        super(1);
        this.key = key;
    }

    public static InputNode add(Neuron input, boolean isNeg, int posDelta, Integer deactivationCount) {
        InputNode in;
        Key key = new Key(isNeg, posDelta);
        InputNode inputNode = in = input != null ? input.outputNodes.get(key) : null;
        if (in != null) {
            return in;
        }
        if (!isNeg) {
            in = new PositiveInputNode(key);
        } else {
            NegativeInputNode negIn = new NegativeInputNode(key);
            Network.negationNodes.add(negIn);
            in = negIn;
        }
        in.deactivationCount = deactivationCount;
        if (input != null) {
            in.inputNeuron = input;
            input.outputNodes.put(key, in);
        }
        return in;
    }

    @Override
    public void remove() {
        this.inputNeuron.outputNodes.remove(this.key);
        super.remove();
    }

    @Override
    public void setActivationsEmpty() {
    }

    @Override
    protected void collectNodeAndRefinements(Set<InputNode> inputs) {
        inputs.add(this);
    }

    @Override
    public void expandToNextLevel(Iteration t, LatticeQueue queue, Activation act, Option conflict, boolean train) {
        Activation.Key ak = act.key;
        if (act.isRemoved) {
            return;
        }
        for (InputNode secondNode : this.getNodesFromActivations(t.doc.getInputActivations(ak.pos))) {
            AndNode.processCandidate(t, queue, this, secondNode, secondNode, act, conflict, train);
        }
        OrNode.processCandidate(t, queue, this, act, conflict, train);
    }

    private Set<InputNode> getNodesFromActivations(Collection<Activation> acts) {
        TreeSet<InputNode> results = new TreeSet<InputNode>();
        for (Activation act : acts) {
            results.add((InputNode)act.node);
        }
        return results;
    }

    @Override
    public double computeSynapseWeightSum(Neuron n) {
        return n.bias + (double)Math.abs(((Synapse)n.inputSynapses.get((Object)this.inputNeuron)).w);
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        if (this instanceof PositiveInputNode) {
            sb.append("P");
        } else {
            sb.append("N");
        }
        sb.append(this.key.posDelta);
        sb.append("[");
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.id);
            if (this.inputNeuron.label != null) {
                sb.append(",");
                sb.append(this.inputNeuron.label);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static final class Key
    implements Comparable<Key> {
        public final boolean isNeg;
        public final int posDelta;

        public Key(boolean isNeg, int posDelta) {
            this.isNeg = isNeg;
            this.posDelta = posDelta;
        }

        @Override
        public int compareTo(Key k) {
            int r = Integer.compare(this.posDelta, k.posDelta);
            if (r != 0) {
                return r;
            }
            if (this.isNeg == k.isNeg) {
                return 0;
            }
            if (!this.isNeg && k.isNeg) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return " isNeg:" + this.isNeg + " posDelta:" + this.posDelta;
        }
    }
}

