/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.lattice;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.aika.corpus.Option;
import org.aika.network.Iteration;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.lattice.Node;

public final class LatticeQueue {
    public final TreeMap<Activation, Change> queue = new TreeMap(new Comparator<Activation>(){

        @Override
        public int compare(Activation act1, Activation act2) {
            Node n1 = act1.node;
            Node n2 = act2.node;
            int r = Integer.compare(n1.level, n2.level);
            if (r != 0) {
                return r;
            }
            r = n1.compareTo(n2);
            if (r != 0) {
                return r;
            }
            return act1.key.compareTo(act2.key);
        }
    });

    public void addModification(Activation act, boolean addRemove, boolean mode, Option conflict) {
        assert (!(act == null || addRemove && act.isRemoved));
        act.key.countRef();
        this.queue.put(act, new Change(addRemove, mode, conflict));
    }

    public void processChanges(Iteration t, boolean train) {
        while (!this.queue.isEmpty()) {
            Map.Entry<Activation, Change> me = this.queue.pollFirstEntry();
            Activation act = me.getKey();
            Change m = me.getValue();
            Node n = act.node;
            if (m.addRemove) {
                n.expandToNextLevel(t, this, act, m.conflict, train);
            } else if (m.mode) {
                n.removeFromNextLevel(t, this, act.key);
            }
            act.key.releaseRef();
        }
    }

    private static final class Change {
        final boolean addRemove;
        final boolean mode;
        final Option conflict;

        public Change(boolean addRemove, boolean mode, Option conflict) {
            this.addRemove = addRemove;
            this.mode = mode;
            this.conflict = conflict;
        }
    }
}

