/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.lattice;

import org.aika.corpus.Option;
import org.aika.network.Iteration;
import org.aika.network.Network;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.lattice.InputNode;
import org.aika.network.neuron.lattice.LatticeQueue;
import org.aika.utils.SetUtils;

public class NegativeInputNode
extends InputNode {
    public NegativeInputNode(InputNode.Key key) {
        super(key);
    }

    @Override
    public Activation addActivation(Iteration t, Activation inputAct) {
        Activation act = this.getActivation(inputAct.key.pos - this.key.posDelta);
        assert (act != null);
        assert (act.key.o.length == 1);
        if (act.key.o.contains(inputAct.key.o)) {
            LatticeQueue queue = new LatticeQueue();
            this.removeActivationAndPropagate(t, queue, act.key);
            queue.processChanges(t, false);
            return null;
        }
        Option.addConflict(t, act.exclusionOption, inputAct.key.o);
        return act;
    }

    @Override
    public void removeActivation(Iteration t, Activation.Key inputAk) {
        int pos = inputAk.pos - this.key.posDelta;
        Activation act = this.getActivation(pos);
        if (act == null) {
            Option o = Option.addPrimitive(t.doc, pos);
            LatticeQueue queue = new LatticeQueue();
            this.addActivationAndPropagate(t, queue, new Activation.Key(inputAk.pos, o, 0), 0, o, SetUtils.EMPTY_SET);
            queue.processChanges(t, false);
        } else {
            assert (act.key.o.length == 1);
            Option.removeConflict(t, act.exclusionOption, inputAk.o);
        }
    }

    @Override
    public double getWeight() {
        return 1.0;
    }

    @Override
    public void cleanup() {
    }

    public static void addInitialActivations(Iteration t) {
        for (int pos = 0; pos < t.doc.length() + 1; ++pos) {
            for (NegativeInputNode nn : Network.negationNodes) {
                LatticeQueue queue = new LatticeQueue();
                Option o = Option.addPrimitive(t.doc, pos);
                nn.addActivationAndPropagate(t, queue, new Activation.Key(pos, o, 0), 0, o, SetUtils.EMPTY_SET);
                queue.processChanges(t, false);
            }
        }
    }
}

