/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.lattice;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.corpus.Option;
import org.aika.network.Iteration;
import org.aika.network.Network;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.Synapse;
import org.aika.network.neuron.lattice.AndNode;
import org.aika.network.neuron.lattice.InputNode;
import org.aika.network.neuron.lattice.LatticeQueue;
import org.aika.network.neuron.lattice.OrNode;

public abstract class Node
implements Comparable<Node> {
    public static int minFrequency = 5;
    public int level;
    public static int currentNodeId = 0;
    public int id = currentNodeId++;
    public boolean countingMode;
    public boolean isPredefined;
    public boolean isBlocked;
    public boolean isRemoved;
    public int isRemovedId;
    public static int isRemovedIdCounter = 0;
    public int frequency;
    public boolean frequencyHasChanged = true;
    public int n;
    public NavigableMap<Activation.Key, Activation> activations = new TreeMap<Activation.Key, Activation>();
    public Neuron neuron = null;
    public TreeMap<InputNode, AndNode> andChildrenWithinDocument = new TreeMap();
    public TreeMap<InputNode, AndNode> andChildren = new TreeMap();
    public TreeSet<OrNode> orChildren = new TreeSet();

    public abstract double getWeight();

    public abstract void cleanup();

    public abstract void setActivationsEmpty();

    public abstract void expandToNextLevel(Iteration var1, LatticeQueue var2, Activation var3, Option var4, boolean var5);

    protected abstract void collectNodeAndRefinements(Set<InputNode> var1);

    public abstract double computeSynapseWeightSum(Neuron var1);

    public abstract String logicToString();

    public Node(int level) {
        this.level = level;
        Network.allNodes.add(this);
    }

    public void train(Iteration t) {
        if (this.isFrequentOrPredefined(this.frequency)) {
            LatticeQueue queue = new LatticeQueue();
            for (Activation act : this.activations.values()) {
                queue.addModification(act, true, false, null);
            }
            queue.processChanges(t, true);
        }
    }

    public Activation addActivationAndPropagate(Iteration t, LatticeQueue queue, Activation.Key ak, int recurrentCount, Option exclusionOption, TreeSet<Activation> inputActs) {
        Activation oldAct = this.getActivation(ak.pos, ak.o, ak.fired);
        if (oldAct != null) {
            return oldAct;
        }
        Activation act = this.addActivationInternal(t, ak);
        act.recurrentCount = recurrentCount;
        act.exclusionOption = exclusionOption;
        act.linkActivationsBackwards(inputActs);
        assert (act.uses == null || act.uses.size() < 2 || !(this instanceof InputNode));
        if (act.shadowedBy.isEmpty()) {
            this.propagateAddedActivation(t, queue, act);
        }
        for (Activation shadAct : act.shadows) {
            this.propagateRemovedActivation(t, queue, shadAct);
        }
        return act;
    }

    public void propagateAddedActivation(Iteration t, LatticeQueue queue, Activation act) {
        if (this.neuron != null) {
            this.neuron.propagateAddedActivation(t, act);
        }
        if (queue != null) {
            queue.addModification(act, true, true, null);
        }
    }

    public Activation addActivationInternal(Iteration t, Activation.Key ak) {
        assert (ak.pos <= t.doc.length());
        Activation act = new Activation(ak);
        act.node = this;
        for (Activation oa : this.getActivations(ak.pos)) {
            if (oa.key.shadows(ak)) {
                act.shadowedBy.add(oa);
                oa.shadows.add(act);
            }
            if (!ak.shadows(oa.key)) continue;
            act.shadows.add(oa);
            oa.shadowedBy.add(act);
        }
        if (this.activations.isEmpty()) {
            t.hasActivations.add(this);
        }
        this.activations.put(act.key, act);
        if (this instanceof InputNode) {
            t.doc.addInputActivation(act);
        }
        act.register();
        return act;
    }

    public void removeActivationAndPropagate(Iteration t, LatticeQueue queue, Activation.Key ak) {
        Activation act = this.removeActivationInternal(t, ak);
        if (act == null) {
            return;
        }
        for (Activation shadAct : act.shadowedBy) {
            shadAct.shadows.remove(act);
        }
        for (Activation shadAct : act.shadows) {
            shadAct.shadowedBy.remove(act);
        }
        if (act.shadowedBy.isEmpty()) {
            this.propagateRemovedActivation(t, queue, act);
        }
        for (Activation shadAct : act.shadows) {
            this.propagateAddedActivation(t, queue, shadAct);
        }
        if (act.exclusionOption != null) {
            act.exclusionOption.removeAllConflicts(t);
        }
        act.key.releaseRef();
    }

    public void propagateRemovedActivation(Iteration t, LatticeQueue queue, Activation act) {
        if (this.neuron != null) {
            this.neuron.propagateRemovedActivation(t, act);
        }
        if (queue != null) {
            queue.addModification(act, false, true, null);
        }
    }

    public Activation removeActivationInternal(Iteration t, Activation.Key ak) {
        Activation act = (Activation)this.activations.remove(ak);
        if (act == null) {
            return null;
        }
        if (this.activations.isEmpty()) {
            t.hasActivations.remove(this);
            this.setActivationsEmpty();
        }
        act.unlinkAllActivationsBackwards();
        if (this instanceof InputNode) {
            t.doc.removeInputActivation(act);
        }
        act.unregister();
        act.removedId = Activation.removedIdCounter++;
        act.isRemoved = true;
        return act;
    }

    public void countActivation(Activation.Key ak, Option so) {
        int delta = 1;
        if (!this.countingMode && !this.getMatchingActivations(ak.pos - 1, so, false, false).isEmpty()) {
            --delta;
        }
        this.frequency += delta;
        this.frequencyHasChanged = true;
    }

    public Collection<Activation> getActivations(Integer pos) {
        if (this.activations.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return this.activations.subMap(new Activation.Key(pos, Option.MIN, Integer.MIN_VALUE, Integer.MIN_VALUE), true, new Activation.Key(pos, Option.MAX, Integer.MAX_VALUE, Integer.MAX_VALUE), false).values();
    }

    public Activation getActivation(Integer pos, Option o) {
        if (this.activations.size() == 0) {
            return null;
        }
        Iterator<Activation> iterator = this.activations.subMap(new Activation.Key(pos, o, Integer.MIN_VALUE, Integer.MIN_VALUE), new Activation.Key(pos, o, Integer.MAX_VALUE, Integer.MAX_VALUE)).values().iterator();
        if (iterator.hasNext()) {
            Activation act = iterator.next();
            return act;
        }
        return null;
    }

    public Activation getActivation(Integer pos, Option o, int fired) {
        if (this.activations.size() == 0) {
            return null;
        }
        Iterator<Activation> iterator = this.activations.subMap(new Activation.Key(pos, o, fired, Integer.MIN_VALUE), new Activation.Key(pos, o, fired, Integer.MAX_VALUE)).values().iterator();
        if (iterator.hasNext()) {
            Activation act = iterator.next();
            return act;
        }
        return null;
    }

    public Activation getActivation(Integer pos) {
        if (this.activations.size() == 0) {
            return null;
        }
        SortedMap<Activation.Key, Activation> acts = this.activations.subMap(new Activation.Key(pos, Option.MIN, Integer.MIN_VALUE, Integer.MIN_VALUE), new Activation.Key(pos, Option.MAX, Integer.MAX_VALUE, Integer.MAX_VALUE));
        assert (acts.size() <= 1);
        Iterator<Activation> iterator = acts.values().iterator();
        if (iterator.hasNext()) {
            Activation act = iterator.next();
            return act;
        }
        return null;
    }

    public Activation getActivation(Activation.Key ak) {
        return (Activation)this.activations.get(ak);
    }

    public Iterable<Activation> getActivations() {
        return this.activations.values();
    }

    public Set<Activation> getMatchingActivations(Integer pos, Option o, boolean direction, boolean includeShadowed) {
        if (this.activations.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<Activation> results = new HashSet<Activation>();
        for (Activation act : this.getActivations(pos)) {
            if ((!direction || !act.key.o.contains(o)) && (direction || !o.contains(act.key.o)) || !includeShadowed && !act.shadowedBy.isEmpty()) continue;
            results.add(act);
        }
        return results;
    }

    public void clearActivations() {
        for (Activation act : this.activations.values()) {
            act.unlinkAllActivationsBackwards();
        }
        this.activations.clear();
        this.setActivationsEmpty();
    }

    public boolean isFrequentOrPredefined(int freq) {
        if (this.isPredefined) {
            return true;
        }
        return freq >= minFrequency;
    }

    public boolean isFrequentOrPredefined() {
        if (this.isPredefined) {
            return true;
        }
        return this.frequency >= minFrequency;
    }

    public Set<AndNode> getAndChildPatterns(Set<AndNode> results) {
        for (AndNode cp : this.andChildren.values()) {
            results.add(cp);
            cp.getAndChildPatterns(results);
        }
        return results;
    }

    public boolean computeAndParents(SortedSet<InputNode> inputs, Map<InputNode, Node> parents, Set<Node> visited) {
        if (visited.contains(this)) {
            return true;
        }
        visited.add(this);
        if (inputs.size() == 1) {
            parents.put(inputs.first(), this);
            return true;
        }
        for (InputNode a : inputs) {
            TreeSet<InputNode> childInputs = new TreeSet<InputNode>(inputs);
            childInputs.remove(a);
            Node cp = this.andChildren.get(a);
            if (cp == null) {
                return false;
            }
            if (!cp.isFrequentOrPredefined()) {
                return false;
            }
            if (cp.computeAndParents(childInputs, parents, visited)) continue;
            return false;
        }
        return true;
    }

    public static void addNeuron(Neuron n, Set<Synapse> inputs) {
        TreeSet<Node> outputs = new TreeSet<Node>();
        if (inputs.isEmpty()) {
            InputNode node = InputNode.add(null, false, 0, null);
            node.isPredefined = true;
            outputs.add(node);
        } else {
            Map<AndNode, Set<Synapse>> nextLevel;
            Map<InputNode, Set<Synapse>> firstLevel = Node.computePredefinedInputNodes(n, outputs, inputs);
            Map<AndNode, Set<Synapse>> map = nextLevel = !firstLevel.isEmpty() ? Node.computePredefinedSecondLevelAndNodes(n, outputs, firstLevel) : null;
            while (nextLevel != null && !nextLevel.isEmpty()) {
                nextLevel = Node.computePredefinedAndNodes(n, outputs, nextLevel);
            }
        }
        assert (!outputs.isEmpty());
        Node outputNode = null;
        if (outputs.size() == 1) {
            outputNode = (Node)outputs.first();
        } else if (outputs.size() > 1) {
            OrNode orNode = new OrNode(-1);
            for (Node on : outputs) {
                orNode.addInput(on);
            }
            outputNode = orNode;
        }
        assert (outputNode != null);
        assert (n.node == null);
        n.node = outputNode;
        assert (outputNode.neuron == null);
        outputNode.neuron = n;
        outputNode.isPredefined = true;
    }

    public static Map<InputNode, Set<Synapse>> computePredefinedInputNodes(Neuron n, Set<Node> outputs, Set<Synapse> inputs) {
        TreeMap<InputNode, Set<Synapse>> results = new TreeMap<InputNode, Set<Synapse>>();
        for (Synapse s : inputs) {
            InputNode in = InputNode.add(s.input, s.w <= 0.0f, s.posDelta, s.deactivationCount);
            in.isPredefined = true;
            if (s.posDelta != 0) {
                in.isBlocked = true;
            }
            Node.prepareResultsForPredefinedNodes(results, outputs, in, n, s, inputs);
        }
        return results;
    }

    public static Map<AndNode, Set<Synapse>> computePredefinedSecondLevelAndNodes(Neuron n, Set<Node> outputs, Map<InputNode, Set<Synapse>> previousLevel) {
        TreeMap<AndNode, Set<Synapse>> results = new TreeMap<AndNode, Set<Synapse>>();
        for (Map.Entry<InputNode, Set<Synapse>> me : previousLevel.entrySet()) {
            InputNode pa = me.getKey();
            for (Synapse s : me.getValue()) {
                InputNode pb = s.getRefinement();
                if (!(pb.computeSynapseWeightSum(n) <= 0.0)) continue;
                AndNode sln = (AndNode)pa.andChildren.get(pb);
                if (sln == null) {
                    TreeMap<InputNode, Node> parents = new TreeMap<InputNode, Node>();
                    parents.put(pb, pa);
                    parents.put(pa, pb);
                    sln = new AndNode(2, parents);
                }
                Node.prepareResultsForPredefinedNodes(results, outputs, sln, n, s, me.getValue());
            }
        }
        return results;
    }

    public static Map<AndNode, Set<Synapse>> computePredefinedAndNodes(Neuron n, Set<Node> outputs, Map<AndNode, Set<Synapse>> previousLevel) {
        TreeMap<AndNode, Set<Synapse>> results = new TreeMap<AndNode, Set<Synapse>>();
        for (Map.Entry<AndNode, Set<Synapse>> me : previousLevel.entrySet()) {
            AndNode pa = me.getKey();
            for (Map.Entry<InputNode, Node> mea : pa.parents.entrySet()) {
                for (Synapse s : me.getValue()) {
                    InputNode ref = s.getRefinement();
                    AndNode pb = mea.getValue().andChildren.get(ref);
                    if (pb == null || !(pb.computeSynapseWeightSum(n) <= 0.0)) continue;
                    AndNode nln = (AndNode)pa.andChildren.get(ref);
                    if (nln == null) {
                        TreeSet<InputNode> inputs = new TreeSet<InputNode>();
                        pa.collectNodeAndRefinements(inputs);
                        inputs.add(ref);
                        nln = new AndNode(pa.level + 1, AndNode.computeParents(inputs));
                    }
                    Node.prepareResultsForPredefinedNodes(results, outputs, nln, n, s, me.getValue());
                }
            }
        }
        return results;
    }

    private static <N extends Node> void prepareResultsForPredefinedNodes(Map<N, Set<Synapse>> results, Set<Node> outputs, N in, Neuron n, Synapse s, Set<Synapse> inputs) {
        in.isPredefined = true;
        if (in.computeSynapseWeightSum(n) > 0.0) {
            outputs.add(in);
        } else {
            TreeSet<Synapse> remainingSynapses = new TreeSet<Synapse>(inputs);
            remainingSynapses.remove(s);
            results.put(in, remainingSynapses);
        }
    }

    public void removeFromNextLevel(Iteration t, LatticeQueue queue, Activation.Key ak) {
        for (AndNode andNode : this.andChildren.values()) {
            andNode.removeActivation(t, queue, ak);
        }
        for (OrNode orNode : this.orChildren) {
            orNode.removeActivation(t, queue, new Activation.Key(ak.pos, ak.o, ak.fired, this.id));
        }
    }

    public void remove() {
        assert (!this.isRemoved);
        if (this.neuron != null) {
            this.neuron.remove();
        }
        while (!this.andChildren.isEmpty()) {
            this.andChildren.pollFirstEntry().getValue().remove();
        }
        while (!this.orChildren.isEmpty()) {
            this.orChildren.pollFirst().remove();
        }
        Network.allNodes.remove(this);
        this.clearActivations();
        this.isRemoved = true;
        this.isRemovedId = isRemovedIdCounter++;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toSimpleString());
        sb.append(" - ");
        sb.append(this.logicToString());
        return sb.toString();
    }

    public String toSimpleString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id);
        if (this.neuron != null && this.neuron.label != null) {
            sb.append(" ");
            sb.append(this.neuron.label);
        }
        sb.append(" (Freq:");
        sb.append(this.frequency);
        sb.append(", W:");
        sb.append(this.getWeight());
        sb.append(", N:");
        sb.append(this.n);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(Node n) {
        if (this.id < n.id) {
            return -1;
        }
        if (this.id > n.id) {
            return 1;
        }
        return 0;
    }
}

