/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.lattice;

import java.util.Set;
import java.util.TreeSet;
import org.aika.corpus.Option;
import org.aika.network.Iteration;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.Neuron;
import org.aika.network.neuron.lattice.InputNode;
import org.aika.network.neuron.lattice.LatticeQueue;
import org.aika.network.neuron.lattice.LogicNode;
import org.aika.network.neuron.lattice.Node;

public class OrNode
extends LogicNode {
    public Set<Node> parents = new TreeSet<Node>();

    public OrNode(int level) {
        super(level);
    }

    public void addActivation(Iteration t, LatticeQueue queue, Activation.Key ak, Activation inputAct) {
        this.addActivationAndPropagate(t, queue, ak, inputAct.recurrentCount, null, inputAct.uses);
    }

    protected void removeActivation(Iteration t, LatticeQueue queue, Activation.Key ak) {
        this.removeActivationAndPropagate(t, queue, ak);
    }

    @Override
    public double computeSynapseWeightSum(Neuron n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void setActivationsEmpty() {
    }

    @Override
    public void expandToNextLevel(Iteration t, LatticeQueue queue, Activation act, Option conflict, boolean train) {
        OrNode.processCandidate(t, queue, this, act, conflict, train);
    }

    public static void processCandidate(Iteration t, LatticeQueue queue, Node parentNode, Activation act, Option conflict, boolean train) {
        Activation.Key ak = act.key;
        for (OrNode n : parentNode.orChildren) {
            n.addActivation(t, queue, new Activation.Key(ak.pos, ak.o, ak.fired, parentNode.id), act);
        }
    }

    @Override
    protected void collectNodeAndRefinements(Set<InputNode> inputs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getWeight() {
        return 1.0;
    }

    public void addInput(Node inputNode) {
        inputNode.orChildren.add(this);
        this.parents.add(inputNode);
    }

    @Override
    public void remove() {
        super.remove();
        for (Node n : this.parents) {
            n.orChildren.remove(this);
        }
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR[");
        boolean first = true;
        for (Node n : this.parents) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(n.logicToString());
        }
        sb.append("]");
        return sb.toString();
    }
}

