/*
 * Decompiled with CFR 0.152.
 */
package org.aika.network.neuron.lattice;

import java.util.TreeSet;
import org.aika.network.Iteration;
import org.aika.network.neuron.Activation;
import org.aika.network.neuron.lattice.InputNode;
import org.aika.network.neuron.lattice.LatticeQueue;

public class PositiveInputNode
extends InputNode {
    public PositiveInputNode(InputNode.Key key) {
        super(key);
    }

    private Activation.Key computeActivationKey(Activation.Key inputAk) {
        return new Activation.Key(inputAk.pos - this.key.posDelta, inputAk.o, this.key.posDelta == 0 ? inputAk.fired + 1 : 0);
    }

    @Override
    public Activation addActivation(Iteration t, Activation inputAct) {
        if (this.deactivationCount != null && this.deactivationCount <= inputAct.recurrentCount + 1) {
            return null;
        }
        Activation.Key ak = this.computeActivationKey(inputAct.key);
        if (ak.pos < 0 || ak.pos >= t.doc.length()) {
            return null;
        }
        TreeSet<Activation> inputActs = new TreeSet<Activation>();
        inputActs.add(inputAct);
        LatticeQueue queue = new LatticeQueue();
        Activation act = this.addActivationAndPropagate(t, queue, ak, this.deactivationCount != null && this.key.posDelta != 0 ? inputAct.recurrentCount + 1 : 0, null, inputActs);
        queue.processChanges(t, false);
        return act;
    }

    @Override
    public void removeActivation(Iteration t, Activation.Key inputAk) {
        Activation.Key ak = this.computeActivationKey(inputAk);
        if (ak.pos < 0 || ak.pos >= t.doc.length()) {
            return;
        }
        LatticeQueue queue = new LatticeQueue();
        this.removeActivationAndPropagate(t, queue, ak);
        queue.processChanges(t, false);
    }

    @Override
    public double getWeight() {
        return 1.0;
    }

    @Override
    public void cleanup() {
    }
}

