/*
 * Decompiled with CFR 0.152.
 */
package org.aika.predefinedrules;

import java.util.HashMap;
import java.util.Map;
import org.aika.network.neuron.Neuron;
import org.aika.utils.SetUtils;

public class PredefinedRules {
    public Map<Character, Neuron[]> lpWordCharN = new HashMap<Character, Neuron[]>();
    public Neuron earlySE = new Neuron("earlySE");
    public Neuron lateSE = new Neuron("lateSE", true);
    public final int NUMBER_OF_CPS = 4;

    public void addRules() {
        Neuron spaceN = Neuron.createOrLookupInputSignal("SPACE", true);
        Neuron SB = Neuron.createOrNeuron(new Neuron("SB"), SetUtils.asSortedSet(new Neuron.Input(false, -1, this.lateSE), new Neuron.Input(false, -1, spaceN)));
        Neuron WS = Neuron.createRecurrentNeuron(new Neuron("WS"), this.lateSE, SB, 0, 10, true, true);
        Neuron.createNegationNeuron(this.earlySE, WS, 1);
        String chars = "abcdefghijklmnopqrstuvwxyz\u00e4\u00f6\u00fc\u00df";
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            Neuron ciLetterN = Neuron.createOrLookupInputSignal("CI_LETTER." + c, true);
            Neuron[] lpwcN = new Neuron[4];
            this.lpWordCharN.put(Character.valueOf(c), lpwcN);
            lpwcN[0] = ciLetterN;
            for (int j = 1; j < lpwcN.length; ++j) {
                lpwcN[j] = Neuron.createAndNeuron(new Neuron("lp-" + c + "-" + j), SetUtils.asSortedSet(new Neuron.Input(false, -1, lpwcN[j - 1]), new Neuron.Input(true, -1, this.lateSE)));
            }
        }
    }
}

