/*
 * Decompiled with CFR 0.152.
 */
package org.aika.preprocessing;

import org.aika.corpus.Document;

public class PrepareSimpleCharacterProperties {
    public static void run(Document doc) {
        String txt = doc.getContent();
        boolean inAnfuehrungzeichen = false;
        for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (!(inAnfuehrungzeichen || c != '\"' && c != '\u00bb')) {
                inAnfuehrungzeichen = true;
            }
            if (inAnfuehrungzeichen) {
                doc.addAnnotation(i, i + 1, "AFZ", 0);
            }
            if (c != ' ') {
                doc.addAnnotation(i, i + 1, "CHAR." + c, 0);
            }
            if (Character.isLetter(c)) {
                doc.addAnnotation(i, i + 1, "CI_LETTER." + Character.toLowerCase(c), 0);
                doc.addAnnotation(i, i + 1, "IS_CHAR", 0);
            }
            if (Character.isDigit(c)) {
                doc.addAnnotation(i, i + 1, "DIGIT." + c, 0);
            }
            if (",.-&;:!?\"\u00bb\u00ab".indexOf(c) != -1) {
                doc.addAnnotation(i, i + 1, "PUNCT-" + c, 0);
            }
            if (c == ' ') {
                doc.addAnnotation(i, i + 1, "SPACE", 0);
            }
            if (!inAnfuehrungzeichen || c != '\"' && c != '\u00ab') continue;
            inAnfuehrungzeichen = false;
        }
    }
}

