/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.aika.Model;
import org.aika.Neuron;
import org.aika.Utils;
import org.aika.lattice.AndNode;
import org.aika.lattice.InputNode;
import org.aika.lattice.Node;
import org.aika.lattice.OrNode;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;

public class Converter {
    public static int MAX_AND_NODE_SIZE = 4;
    public static Comparator<Synapse> SYNAPSE_COMP = new Comparator<Synapse>(){

        @Override
        public int compare(Synapse s1, Synapse s2) {
            int r = Double.compare(s2.w, s1.w);
            if (r != 0) {
                return r;
            }
            return Synapse.INPUT_SYNAPSE_COMP.compare(s1, s2);
        }
    };
    private Model m;
    private int threadId;
    private INeuron neuron;
    private OrNode outputNode;
    private Collection<Synapse> modifiedSynapses;

    public static boolean convert(Model m, int threadId, INeuron neuron, Collection<Synapse> modifiedSynapses) {
        return new Converter(m, threadId, neuron, modifiedSynapses).convert();
    }

    private Converter(Model m, int threadId, INeuron neuron, Collection<Synapse> modifiedSynapses) {
        this.m = m;
        this.neuron = neuron;
        this.threadId = threadId;
        this.modifiedSynapses = modifiedSynapses;
    }

    private boolean convert() {
        this.outputNode = this.neuron.node.get();
        this.initInputNodesAndComputeWeightSums();
        double remainingSum = 0.0;
        double numAboveThreshold = 0.0;
        TreeSet<Synapse> tmp = new TreeSet<Synapse>(SYNAPSE_COMP);
        for (Synapse s : this.neuron.inputSynapses.values()) {
            if (s.isNegative() || s.key.isRecurrent) continue;
            if ((double)s.w + this.neuron.bias > 0.0) {
                if (numAboveThreshold > 0.0 && this.neuron.inputSynapses.size() != this.modifiedSynapses.size()) break;
                numAboveThreshold += 1.0;
            }
            remainingSum += (double)s.w;
            tmp.add(s);
        }
        Integer offset = null;
        Node requiredNode = null;
        boolean noFurtherRefinement = false;
        TreeSet<Synapse> reqSyns = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_COMP);
        double sum = 0.0;
        if (numAboveThreshold == 0.0 || this.neuron.inputSynapses.size() == this.modifiedSynapses.size()) {
            int i = 0;
            for (Synapse s : tmp) {
                boolean maxAndNodesReached;
                boolean isOptionalInput = sum + remainingSum - (double)s.w - this.neuron.negRecSum - this.neuron.negDirSum + this.neuron.posRecSum + this.neuron.bias > 0.0;
                boolean bl = maxAndNodesReached = i >= MAX_AND_NODE_SIZE;
                if (isOptionalInput || maxAndNodesReached) break;
                remainingSum -= (double)s.w;
                reqSyns.add(s);
                requiredNode = this.getNextLevelNode(offset, requiredNode, s);
                offset = Utils.nullSafeMin(s.key.relativeRid, offset);
                ++i;
                boolean sumOfSynapseWeightsAboveThreshold = (sum += (double)s.w) - this.neuron.negRecSum - this.neuron.negDirSum + this.neuron.posRecSum + this.neuron.bias > 0.0;
                if (!sumOfSynapseWeightsAboveThreshold) continue;
                noFurtherRefinement = true;
                break;
            }
            this.outputNode.removeParents(this.threadId, false);
            if (requiredNode != this.outputNode.requiredNode) {
                this.outputNode.requiredNode = requiredNode;
            }
            if (noFurtherRefinement || i == MAX_AND_NODE_SIZE) {
                this.outputNode.addInput(offset, this.threadId, requiredNode, false);
            } else {
                for (Synapse s : tmp) {
                    boolean belowThreshold;
                    boolean bl = belowThreshold = sum + (double)s.w + remainingSum - this.neuron.negRecSum - this.neuron.negDirSum + this.neuron.posRecSum + this.neuron.bias <= 0.0;
                    if (!belowThreshold) {
                        if (reqSyns.contains(s)) continue;
                        Node nln = this.getNextLevelNode(offset, requiredNode, s);
                        Integer nOffset = Utils.nullSafeMin(s.key.relativeRid, offset);
                        this.outputNode.addInput(nOffset, this.threadId, nln, false);
                        remainingSum -= (double)s.w;
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (Synapse s : this.modifiedSynapses) {
                Node nln = s.inputNode.get();
                offset = s.key.relativeRid;
                this.outputNode.addInput(offset, this.threadId, nln, false);
            }
        }
        return true;
    }

    private void initInputNodesAndComputeWeightSums() {
        double negDirSumDelta = 0.0;
        double negRecSumDelta = 0.0;
        double posRecSumDelta = 0.0;
        double maxRecurrentSumDelta = 0.0;
        for (Synapse s : this.modifiedSynapses) {
            INeuron in = (INeuron)s.input.get();
            in.lock.acquireWriteLock();
            if (s.inputNode == null) {
                InputNode iNode = InputNode.add(this.m, s.key.createInputNodeKey(), (INeuron)s.input.get());
                iNode.provider.setModified();
                iNode.setSynapse(s);
                s.inputNode = iNode.provider;
            }
            if (s.key.isRecurrent) {
                maxRecurrentSumDelta += (double)(Math.abs(s.nw) - Math.abs(s.w));
                ((Neuron)this.neuron.provider).setModified();
            }
            if (s.isNegative()) {
                if (!s.key.isRecurrent) {
                    negDirSumDelta -= (double)s.w;
                } else {
                    negRecSumDelta -= (double)s.w;
                }
            } else if (s.key.isRecurrent) {
                posRecSumDelta -= (double)s.w;
            }
            if ((double)s.nw <= 0.0) {
                if (!s.key.isRecurrent) {
                    negDirSumDelta += (double)s.nw;
                } else {
                    negRecSumDelta += (double)s.nw;
                }
            } else if (s.key.isRecurrent) {
                posRecSumDelta += (double)s.nw;
            }
            s.w = s.nw;
            in.lock.releaseWriteLock();
        }
        this.neuron.maxRecurrentSum += maxRecurrentSumDelta;
        this.neuron.negDirSum += negDirSumDelta;
        this.neuron.negRecSum += negRecSumDelta;
        this.neuron.posRecSum += posRecSumDelta;
    }

    private Node getNextLevelNode(Integer offset, Node requiredNode, Synapse s) {
        Node nln = requiredNode == null ? (Node)s.inputNode.get() : AndNode.createNextLevelNode(this.m, this.threadId, requiredNode, new AndNode.Refinement(s.key.relativeRid, offset, s.inputNode), null);
        return nln;
    }
}

