/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.aika.AbstractNode;
import org.aika.Model;

public class Provider<T extends AbstractNode>
implements Comparable<Provider<?>> {
    public Model m;
    public Integer id;
    private volatile T n;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Provider(Model m, int id) {
        this.m = m;
        this.id = id;
        WeakHashMap<Integer, WeakReference<Provider<? extends AbstractNode>>> weakHashMap = m.providers;
        synchronized (weakHashMap) {
            m.providers.put(this.id, new WeakReference<Provider>(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Provider(Model m, T n) {
        this.m = m;
        this.n = n;
        this.id = m.suspensionHook != null ? m.suspensionHook.getNewId() : m.currentId.addAndGet(1);
        WeakHashMap<Integer, WeakReference<Provider<? extends AbstractNode>>> weakHashMap = m.providers;
        synchronized (weakHashMap) {
            m.providers.put(this.id, new WeakReference<Provider>(this));
            if (n != null) {
                m.register(this);
            }
        }
    }

    public void setModified() {
        ((AbstractNode)this.n).modified = true;
    }

    public boolean isSuspended() {
        return this.n == null;
    }

    public T getIfNotSuspended() {
        return this.n;
    }

    public synchronized T get() {
        if (this.n == null) {
            this.reactivate();
        }
        return this.n;
    }

    public synchronized void suspend() {
        if (this.n == null) {
            return;
        }
        assert (this.m.suspensionHook != null);
        ((AbstractNode)this.n).suspend();
        this.m.unregister(this);
        if (((AbstractNode)this.n).modified) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipos = new GZIPOutputStream(baos);
                 DataOutputStream dos = new DataOutputStream(gzipos);){
                this.n.write(dos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.m.suspensionHook.store(this.id, baos.toByteArray());
        }
        this.n = null;
    }

    public void discard() {
        this.n = null;
    }

    private void reactivate() {
        assert (this.m.suspensionHook != null);
        byte[] data = this.m.suspensionHook.retrieve(this.id);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try (GZIPInputStream gzipis = new GZIPInputStream(bais);
             DataInputStream dis = new DataInputStream(gzipis);){
            this.n = AbstractNode.read(dis, this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ((AbstractNode)this.n).reactivate();
        this.m.register(this);
    }

    public boolean equals(Object o) {
        return this.id == ((Provider)o).id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "p(" + this.id + ":" + (this.n != null ? this.n.toString() : "SUSPENDED") + ")";
    }

    @Override
    public int compareTo(Provider<?> n) {
        if (this.id < n.id) {
            return -1;
        }
        if (this.id > n.id) {
            return 1;
        }
        return 0;
    }
}

