/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.Utils;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.lattice.NodeActivation;
import org.aika.neuron.Activation;

public class InterprNode
implements Comparable<InterprNode> {
    public static final InterprNode MIN = new InterprNode(null, -1, 0, 0);
    public static final InterprNode MAX = new InterprNode(null, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final int primId;
    public int minPrim = -1;
    public int maxPrim = -1;
    public final int id;
    public int length;
    public Map<NodeActivation, InterprNode> orInterprNodes;
    public Set<InterprNode> refByOrInterprNode;
    public InterprNode largestCommonSubset;
    public Set<InterprNode> linkedByLCS;
    private long visitedLinkRelations;
    private long visitedContains;
    private long visitedCollect;
    private long visitedExpandActivations;
    private long visitedIsConflicting;
    private long visitedStoreFinalWeight;
    private long visitedComputeLargestCommonSubset;
    private long visitedComputeLength;
    private long visitedComputeParents;
    private long visitedNumberInnerInputs;
    private long visitedComputeChildren = -1L;
    long visitedCollectAllConflicting;
    long visitedExpandRefinementRecursiveStep;
    long markedExpandRefinement;
    long visitedCheckExcluded;
    public long markedConflict;
    public long markedSelected;
    public long markedExcluded;
    public boolean markedExcludedRefinement;
    private int numberInnerInputs = 0;
    private int largestCommonSubsetCount = 0;
    private int numberOfInputsComputeChildren = 0;
    public final Document doc;
    public Activation act;
    private static InterprNode[] EMPTY_INTR_RELS = new InterprNode[0];
    public InterprNode[] parents = EMPTY_INTR_RELS;
    public InterprNode[] children = EMPTY_INTR_RELS;
    public int isConflict = -1;
    public Conflicts conflicts = new Conflicts();
    public NavigableMap<NodeActivation.Key, NodeActivation> activations;
    public NavigableSet<Activation> neuronActivations;
    private static Comparator<InterprNode> LENGTH_COMP = new Comparator<InterprNode>(){

        @Override
        public int compare(InterprNode n1, InterprNode n2) {
            return Integer.compare(n2.length, n1.length);
        }
    };

    public InterprNode(Document doc, int primId, int id, int length) {
        this(doc, primId, id);
        this.length = length;
    }

    public InterprNode(Document doc, int primId, int id) {
        this.doc = doc;
        this.primId = primId;
        this.id = id;
    }

    private void computeLargestCommonSubsetIncremental(InterprNode no) {
        if (this.orInterprNodes.size() == 0) {
            this.setLCS(no);
            return;
        }
        long vMin = this.doc.visitedCounter++;
        ArrayList<InterprNode> results = new ArrayList<InterprNode>();
        if (this.largestCommonSubset != null) {
            this.largestCommonSubset.computeLargestCommonSubsetRecursiveStep(results, this.doc.visitedCounter++, vMin, 2, 0);
        }
        no.computeLargestCommonSubsetRecursiveStep(results, this.doc.visitedCounter++, vMin, 2, 0);
        this.setLCS(InterprNode.add(this.doc, true, results));
    }

    private void setLCS(InterprNode lcs) {
        if (this.largestCommonSubset != null) {
            this.largestCommonSubset.linkedByLCS.remove(this);
        }
        this.largestCommonSubset = lcs;
        if (this.largestCommonSubset != null) {
            if (this.largestCommonSubset.linkedByLCS == null) {
                this.largestCommonSubset.linkedByLCS = new TreeSet<InterprNode>();
            }
            this.largestCommonSubset.linkedByLCS.add(this);
        }
    }

    private void computeLargestCommonSubsetRecursiveStep(List<InterprNode> results, long v, long vMin, int s, int depth) {
        if (this.visitedComputeLargestCommonSubset == v) {
            return;
        }
        if (this.visitedComputeLargestCommonSubset <= vMin) {
            this.largestCommonSubsetCount = 0;
        }
        this.visitedComputeLargestCommonSubset = v;
        ++this.largestCommonSubsetCount;
        if (depth > 10) {
            return;
        }
        if (this.largestCommonSubsetCount == s) {
            results.add(this);
            return;
        }
        for (InterprNode pn : this.parents) {
            pn.computeLargestCommonSubsetRecursiveStep(results, v, vMin, s, depth + 1);
        }
        if (this.largestCommonSubset != null) {
            this.largestCommonSubset.computeLargestCommonSubsetRecursiveStep(results, v, vMin, s, depth + 1);
        }
    }

    public void addOrOption(NodeActivation inputAct, InterprNode n) {
        if (this.orInterprNodes == null) {
            this.orInterprNodes = new TreeMap<NodeActivation, InterprNode>();
        }
        this.computeLargestCommonSubsetIncremental(n);
        this.orInterprNodes.put(inputAct, n);
        if (n.refByOrInterprNode == null) {
            n.refByOrInterprNode = new TreeSet<InterprNode>();
        }
        n.refByOrInterprNode.add(this);
    }

    public Collection<NodeActivation> getActivations() {
        return this.activations != null ? this.activations.values() : Collections.emptySet();
    }

    public Collection<Activation> getNeuronActivations() {
        return this.neuronActivations != null ? this.neuronActivations : Collections.emptySet();
    }

    public static InterprNode add(Document doc, boolean nonConflicting, InterprNode ... input) {
        ArrayList<InterprNode> in = new ArrayList<InterprNode>();
        for (InterprNode n : input) {
            if (n == null || n.isBottom()) continue;
            in.add(n);
        }
        return InterprNode.add(doc, nonConflicting, in);
    }

    public static InterprNode add(Document doc, boolean nonConflicting, List<InterprNode> inputs) {
        if (inputs.size() == 0) {
            return doc.bottom;
        }
        Iterator<InterprNode> it = inputs.iterator();
        while (it.hasNext()) {
            if (!it.next().isBottom()) continue;
            it.remove();
        }
        if (inputs.size() == 1 || inputs.size() == 2 && inputs.get(0) == inputs.get(1)) {
            InterprNode n = inputs.get(0);
            if (nonConflicting && n.isConflicting(doc.visitedCounter++)) {
                return null;
            }
            return n;
        }
        ArrayList<InterprNode> parents = new ArrayList<InterprNode>();
        ArrayList<InterprNode> children = new ArrayList<InterprNode>();
        InterprNode.computeRelations(doc, parents, children, inputs);
        if (parents.size() == 1) {
            InterprNode n = parents.get(0);
            if (nonConflicting && n.isConflicting(doc.visitedCounter++)) {
                return null;
            }
            return n;
        }
        if (nonConflicting) {
            for (InterprNode p : parents) {
                if (!p.isConflicting(doc.visitedCounter++)) continue;
                return null;
            }
        }
        InterprNode n = new InterprNode(doc, -1, doc.interpretationIdCounter++);
        super.linkRelations(parents, children, doc.visitedCounter++);
        n.length = super.computeLength(doc.visitedCounter++);
        n.minPrim = Integer.MAX_VALUE;
        n.maxPrim = Integer.MIN_VALUE;
        for (InterprNode in : inputs) {
            n.minPrim = Math.min(n.minPrim, in.minPrim);
            n.maxPrim = Math.max(n.maxPrim, in.maxPrim);
        }
        return n;
    }

    private static void computeRelations(Document doc, List<InterprNode> parentsResults, List<InterprNode> childrenResults, List<InterprNode> inputs) {
        if (inputs.isEmpty()) {
            return;
        }
        long v = doc.visitedCounter++;
        boolean i = false;
        int s = inputs.size();
        Collections.sort(inputs, LENGTH_COMP);
        if (s == 2 && inputs.get((int)1).primId >= 0 && inputs.get((int)1).children.length == 0) {
            parentsResults.addAll(inputs);
            return;
        }
        for (int pass = 0; pass <= 1; ++pass) {
            for (InterprNode n : inputs) {
                n.computeParents(parentsResults, v, pass);
            }
            ++doc.visitedCounter;
        }
        if (parentsResults.size() == 1) {
            return;
        }
        assert (parentsResults.size() != 0);
        for (InterprNode n : inputs) {
            n.computeChildren(childrenResults, doc.visitedCounter++, v, inputs.size(), 0);
        }
        inputs.get(0).computeChildren(childrenResults, doc.visitedCounter++, v, inputs.size(), 1);
    }

    private void computeParents(List<InterprNode> parentResults, long v, int pass) {
        if (this.visitedComputeParents == v || this.length == 0) {
            return;
        }
        this.visitedComputeParents = v;
        for (InterprNode pn : this.parents) {
            pn.computeParents(parentResults, v, pass);
        }
        boolean flag = true;
        for (InterprNode cn : this.children) {
            if (pass == 0) {
                if (cn.visitedNumberInnerInputs != v) {
                    cn.numberInnerInputs = 0;
                    cn.visitedNumberInnerInputs = v;
                }
                ++cn.numberInnerInputs;
            }
            if (cn.numberInnerInputs != cn.parents.length) continue;
            cn.computeParents(parentResults, v, pass);
            flag = false;
        }
        if (flag && pass == 1) {
            parentResults.add(this);
        }
    }

    private void computeChildren(List<InterprNode> childrenResults, long v, long nv, int s, int pass) {
        if (this.visitedComputeChildren == v) {
            return;
        }
        if (pass == 0) {
            if (this.visitedComputeChildren <= nv) {
                this.numberOfInputsComputeChildren = 0;
            }
            ++this.numberOfInputsComputeChildren;
        }
        this.visitedComputeChildren = v;
        if (pass == 1 && this.numberOfInputsComputeChildren == s) {
            boolean covered = false;
            for (InterprNode pn : this.parents) {
                if (pn.numberOfInputsComputeChildren != s) continue;
                covered = true;
                break;
            }
            if (!covered) {
                childrenResults.add(this);
            }
        } else {
            for (InterprNode cn : this.children) {
                cn.computeChildren(childrenResults, v, nv, s, pass);
            }
        }
    }

    private int computeLength(long v) {
        if (this.visitedComputeLength == v) {
            return 0;
        }
        this.visitedComputeLength = v;
        if (this.primId >= 0) {
            return 1;
        }
        int result = 0;
        for (InterprNode p : this.parents) {
            result += p.computeLength(v);
        }
        return result;
    }

    private void linkRelations(List<InterprNode> pSet, List<InterprNode> cSet, long v) {
        for (InterprNode p : pSet) {
            InterprNode.addLink(p, this);
        }
        for (InterprNode c : cSet) {
            c.visitedLinkRelations = v;
            InterprNode.addLink(this, c);
        }
        for (InterprNode p : pSet) {
            ArrayList<InterprNode> tmp = new ArrayList<InterprNode>();
            for (InterprNode c : p.children) {
                if (c.visitedLinkRelations != v) continue;
                tmp.add(c);
            }
            for (InterprNode c : tmp) {
                InterprNode.removeLink(p, c);
            }
        }
    }

    private static void addLink(InterprNode a, InterprNode b) {
        a.children = Utils.addToArray(a.children, b);
        b.parents = Utils.addToArray(b.parents, a);
    }

    private static void removeLink(InterprNode a, InterprNode b) {
        a.children = Utils.removeToArray(a.children, b);
        b.parents = Utils.removeToArray(b.parents, a);
    }

    public static InterprNode addPrimitive(Document doc) {
        assert (doc != null);
        InterprNode n = new InterprNode(doc, doc.bottom.children.length, doc.interpretationIdCounter++, 1);
        n.minPrim = n.primId;
        n.maxPrim = n.primId;
        InterprNode.addLink(doc.bottom, n);
        return n;
    }

    public boolean isBottom() {
        return this.length == 0;
    }

    public boolean contains(boolean dir, InterprNode n, boolean followLCS) {
        boolean r = !dir ? this.contains(n, followLCS) : n.contains(this, followLCS);
        return r;
    }

    public boolean contains(InterprNode n, boolean followLCS) {
        return this.contains(n, followLCS, this.doc.visitedCounter++);
    }

    private boolean contains(InterprNode n, boolean followLCS, long v) {
        this.visitedContains = v;
        if (this == n || n.isBottom()) {
            return true;
        }
        if (!followLCS && this.length <= n.length) {
            return false;
        }
        for (InterprNode p : this.parents) {
            if (n.maxPrim < p.minPrim || n.minPrim > p.maxPrim || p.visitedContains == v || !p.contains(n, followLCS, v)) continue;
            return true;
        }
        return followLCS && this.largestCommonSubset != null && this.largestCommonSubset.contains(n, followLCS, v);
    }

    void collectPrimitiveNodes(Set<InterprNode> results, long v) {
        if (v == this.visitedCollect) {
            return;
        }
        this.visitedCollect = v;
        if (this.primId >= 0) {
            results.add(this);
        } else {
            for (InterprNode n : this.parents) {
                n.collectPrimitiveNodes(results, v);
            }
        }
    }

    public boolean isConflicting(long v) {
        if (this.isConflict >= 0) {
            return true;
        }
        if (this.conflictsAllowed()) {
            if (this.visitedIsConflicting == v) {
                return false;
            }
            this.visitedIsConflicting = v;
            for (InterprNode p : this.parents) {
                if (!p.isConflicting(v)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean conflictsAllowed() {
        return this.activations == null || this.activations.isEmpty();
    }

    void storeFinalWeight(long v) {
        if (this.visitedStoreFinalWeight == v) {
            return;
        }
        this.visitedStoreFinalWeight = v;
        for (Activation act : this.getNeuronActivations()) {
            act.finalState = act.rounds.getLast();
        }
        for (InterprNode cn : this.children) {
            cn.storeFinalWeight(v);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean level) {
        TreeSet<InterprNode> ids = new TreeSet<InterprNode>();
        this.collectPrimitiveNodes(ids, this.doc.visitedCounter++);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean f1 = true;
        for (InterprNode n : ids) {
            if (!f1) {
                sb.append(",");
            }
            f1 = false;
            sb.append(n.primId);
            if (level || n.orInterprNodes == null) continue;
            sb.append("[");
            boolean f2 = true;
            for (InterprNode on : n.orInterprNodes.values()) {
                if (!f2) {
                    sb.append(",");
                }
                f2 = false;
                sb.append(on.toString(true));
            }
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(InterprNode n) {
        int r = Integer.compare(this.length, n.length);
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.id, n.id);
    }

    public static int compare(InterprNode oa, InterprNode ob) {
        if (oa == ob) {
            return 0;
        }
        if (oa == null && ob != null) {
            return -1;
        }
        if (oa != null && ob == null) {
            return 1;
        }
        return oa.compareTo(ob);
    }

    public static enum Relation {
        EQUALS,
        CONTAINS,
        CONTAINED_IN;


        public boolean compare(InterprNode a, InterprNode b) {
            switch (this) {
                case EQUALS: {
                    return a == b;
                }
                case CONTAINS: {
                    return a.contains(b, false);
                }
                case CONTAINED_IN: {
                    return b.contains(a, false);
                }
            }
            return false;
        }
    }
}

