/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import org.aika.Utils;

public class Range {
    public static final Range MIN = new Range(Integer.MIN_VALUE, Integer.MIN_VALUE);
    public static final Range MAX = new Range(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final int begin;
    public final int end;

    public Range(Integer begin, Integer end) {
        this.begin = begin != null ? begin : Integer.MIN_VALUE;
        this.end = end != null ? end : Integer.MAX_VALUE;
    }

    public static Range mergeRange(Range ra, Range rb) {
        return new Range(ra.begin != Integer.MIN_VALUE ? ra.begin : rb.begin, ra.end != Integer.MAX_VALUE ? ra.end : rb.end);
    }

    public static Range getOutputRange(Range r, boolean[] ro) {
        return new Range(ro[0] ? Integer.valueOf(r.begin) : null, ro[1] ? Integer.valueOf(r.end) : null);
    }

    @Deprecated
    public static boolean overlaps(Range ra, Range rb) {
        return Utils.compareInteger(ra.end, rb.begin) > 0 && Utils.compareInteger(rb.end, ra.begin) > 0;
    }

    public int getBegin(boolean invert) {
        return invert ? this.end : this.begin;
    }

    public int getEnd(boolean invert) {
        return invert ? this.begin : this.end;
    }

    public Range invert(boolean inv) {
        return inv ? new Range(this.end, this.begin) : this;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public int length() {
        if (this.begin == Integer.MIN_VALUE || this.end == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.end - this.begin;
    }

    public boolean contains(Range r) {
        return this.begin <= r.begin && r.end <= this.end;
    }

    public boolean equals(Range r) {
        return this.begin == r.begin && this.end == r.end;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.begin != Integer.MIN_VALUE ? Integer.valueOf(this.begin) : "MIN");
        sb.append(",");
        sb.append(this.end != Integer.MAX_VALUE ? Integer.valueOf(this.end) : "MAX");
        sb.append(")");
        return sb.toString();
    }

    public static int compare(Range ra, Range rb, boolean inv) {
        int a = Integer.compare(ra.getBegin(inv), rb.getBegin(inv));
        if (a != 0) {
            return a;
        }
        int b = Integer.compare(ra.getEnd(inv), rb.getEnd(inv));
        return b;
    }

    public static int compare(Range ra, Range rb) {
        int a = Integer.compare(ra.begin, rb.begin);
        if (a != 0) {
            return a;
        }
        int b = Integer.compare(ra.end, rb.end);
        return b;
    }

    public static enum Mapping {
        START(0),
        END(1),
        NONE(2);

        int id;

        private Mapping(int id) {
            this.id = id;
        }

        public static Mapping getById(int id) {
            for (Mapping m : Mapping.values()) {
                if (m.id != id) continue;
                return m;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public Integer getSignalPos(Range r) {
            switch (this) {
                case START: {
                    return r.begin;
                }
                case END: {
                    return r.end;
                }
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case START: {
                    return "S";
                }
                case END: {
                    return "E";
                }
                case NONE: {
                    return "N";
                }
            }
            return "";
        }
    }

    public static enum Operator {
        EQUALS(0),
        LESS_THAN_EQUAL(1),
        GREATER_THAN_EQUAL(2),
        LESS_THAN(3),
        GREATER_THAN(4),
        NONE(5);

        int id;

        private Operator(int id) {
            this.id = (short)id;
        }

        public static Operator getById(int id) {
            for (Operator o : Operator.values()) {
                if (o.id != id) continue;
                return o;
            }
            return null;
        }

        public int getId() {
            return this.id;
        }

        public boolean compare(int a, int b) {
            switch (this) {
                case EQUALS: {
                    return a == b;
                }
                case LESS_THAN_EQUAL: {
                    return a <= b;
                }
                case GREATER_THAN_EQUAL: {
                    return a >= b;
                }
                case LESS_THAN: {
                    return a < b;
                }
                case GREATER_THAN: {
                    return a > b;
                }
            }
            return true;
        }

        public static Operator invert(Operator rm) {
            switch (rm) {
                case EQUALS: {
                    return EQUALS;
                }
                case LESS_THAN_EQUAL: {
                    return GREATER_THAN_EQUAL;
                }
                case GREATER_THAN_EQUAL: {
                    return LESS_THAN_EQUAL;
                }
                case LESS_THAN: {
                    return GREATER_THAN;
                }
                case GREATER_THAN: {
                    return LESS_THAN;
                }
            }
            return NONE;
        }
    }
}

