/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.aika.Model;
import org.aika.Neuron;
import org.aika.Provider;
import org.aika.ReadWriteLock;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;

public class InputNode
extends Node<InputNode, NodeActivation<InputNode>> {
    public Synapse.Key key;
    public Neuron inputNeuron;
    Map<SynapseKey, Synapse> synapses;
    public ReadWriteLock synapseLock = new ReadWriteLock();
    private long visitedDiscover;

    public InputNode() {
    }

    public InputNode(Model m, Synapse.Key key) {
        super(m, 1);
        this.key = Synapse.lookupKey(key);
        this.endRequired = false;
        this.ridRequired = false;
        if (key != null) {
            this.endRequired = key.startRangeMapping == Range.Mapping.NONE;
            this.ridRequired = key.relativeRid != null || key.absoluteRid != null;
        }
    }

    public static InputNode add(Model m, Synapse.Key key, INeuron input) {
        Provider<InputNode> pin;
        Provider<InputNode> provider = pin = input != null ? input.outputNodes.get(key) : null;
        if (pin != null) {
            return pin.get();
        }
        InputNode in = new InputNode(m, key);
        if (input != null && in.inputNeuron == null) {
            in.inputNeuron = (Neuron)input.provider;
            input.outputNodes.put(key, in.provider);
            ((Neuron)input.provider).setModified();
        }
        return in;
    }

    @Override
    protected NodeActivation<InputNode> createActivation(Document doc, NodeActivation.Key ak) {
        return new NodeActivation<InputNode>(doc.activationIdCounter++, doc, ak);
    }

    private NodeActivation.Key computeActivationKey(NodeActivation iAct) {
        NodeActivation.Key ak = iAct.key;
        if (this.key.absoluteRid != null && this.key.absoluteRid != ak.rid || ak.o.isConflicting(ak.o.doc.visitedCounter++)) {
            return null;
        }
        return new NodeActivation.Key<InputNode>(this, new Range(this.key.startRangeMapping.getSignalPos(ak.r), this.key.endRangeMapping.getSignalPos(ak.r)), this.key.relativeRid != null ? ak.rid : null, ak.o);
    }

    public void addActivation(Document doc, NodeActivation inputAct) {
        NodeActivation.Key ak = this.computeActivationKey(inputAct);
        if (ak != null) {
            InputNode.addActivationAndPropagate(doc, ak, Collections.singleton(inputAct));
        }
    }

    @Override
    public void propagateAddedActivation(Document doc, NodeActivation act, InterprNode removedConflict) {
        if (!this.key.isRecurrent) {
            this.apply(doc, act, removedConflict);
        }
    }

    @Override
    public boolean isAllowedOption(int threadId, InterprNode n, NodeActivation act, long v) {
        return false;
    }

    @Override
    Collection<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
        ArrayList<AndNode.Refinement> result = new ArrayList<AndNode.Refinement>(2);
        result.add(new AndNode.Refinement(this.key.relativeRid, newRef.rid, this.provider));
        result.add(newRef);
        return result;
    }

    @Override
    void apply(Document doc, NodeActivation act, InterprNode removedConflict) {
        this.lock.acquireReadLock();
        if (this.andChildren != null) {
            for (Map.Entry me : this.andChildren.entrySet()) {
                Provider<InputNode> refInput = ((AndNode.Refinement)me.getKey()).input;
                InputNode in = refInput.getIfNotSuspended();
                if (in == null) continue;
                InputNode.addNextLevelActivations(doc, in, (AndNode.Refinement)me.getKey(), (Provider)me.getValue(), act, removedConflict);
            }
        }
        this.lock.releaseReadLock();
        if (removedConflict == null) {
            OrNode.processCandidate(doc, this, act, false);
        }
    }

    private static void addNextLevelActivations(Document doc, InputNode secondNode, AndNode.Refinement ref, Provider<AndNode> pnlp, NodeActivation act, InterprNode removedConflict) {
        Node.ThreadState th = secondNode.getThreadState(doc.threadId, false);
        if (th == null || th.activations.isEmpty()) {
            return;
        }
        NodeActivation.Key ak = act.key;
        InputNode firstNode = (InputNode)ak.n;
        Integer secondRid = Utils.nullSafeAdd(ak.rid, false, ref.rid, false);
        Stream s = NodeActivation.select(th, secondNode, secondRid, ak.r, InputNode.computeStartRangeMatch(firstNode.key, secondNode.key), InputNode.computeEndRangeMatch(firstNode.key, secondNode.key), null, null);
        s.forEach(secondAct -> {
            InterprNode o = InterprNode.add(doc, true, key.o, secondAct.key.o);
            if (o != null && (removedConflict == null || o.contains(removedConflict, false))) {
                AndNode nlp = (AndNode)pnlp.get();
                nlp.addActivation(doc, new NodeActivation.Key<AndNode>(nlp, Range.mergeRange(Range.getOutputRange(key.r, new boolean[]{inputNode.key.startRangeOutput, inputNode.key.endRangeOutput}), Range.getOutputRange(secondAct.key.r, new boolean[]{inputNode2.key.startRangeOutput, inputNode2.key.endRangeOutput})), Utils.nullSafeMin(key.rid, secondAct.key.rid), o), AndNode.prepareInputActs(act, secondAct));
            }
        });
    }

    private static Range.Operator computeStartRangeMatch(Synapse.Key k1, Synapse.Key k2) {
        if (k2.startRangeOutput) {
            return k1.startRangeMatch;
        }
        if (k1.startRangeOutput) {
            return Range.Operator.invert(k2.startRangeMatch);
        }
        return Range.Operator.NONE;
    }

    private static Range.Operator computeEndRangeMatch(Synapse.Key k1, Synapse.Key k2) {
        if (k2.endRangeOutput) {
            return k1.endRangeMatch;
        }
        if (k1.endRangeOutput) {
            return Range.Operator.invert(k2.endRangeMatch);
        }
        return Range.Operator.NONE;
    }

    @Override
    public void discover(Document doc, NodeActivation<InputNode> act, Document.DiscoveryConfig discoveryConfig) {
        Model cfr_ignored_0 = this.provider.m;
        long v = Model.visitedCounter.addAndGet(1L);
        for (INeuron n : doc.finallyActivatedNeurons) {
            for (Activation secondNAct : n.getFinalActivations(doc)) {
                for (NodeActivation secondAct : secondNAct.outputs.values()) {
                    AndNode.Refinement ref = new AndNode.Refinement(secondAct.key.rid, act.key.rid, ((Node)secondAct.key.n).provider);
                    InputNode in = ref.input.get();
                    Range.Operator srm = InputNode.computeStartRangeMatch(this.key, in.key);
                    Range.Operator erm = InputNode.computeEndRangeMatch(this.key, in.key);
                    if (act == secondAct || this == in || in.visitedDiscover == v || in.key.isRecurrent || this.key.startRangeOutput && in.key.startRangeOutput || this.key.endRangeOutput && in.key.endRangeOutput || !srm.compare(act.key.r.begin, secondAct.key.r.begin) || !erm.compare(act.key.r.end, secondAct.key.r.end)) continue;
                    in.visitedDiscover = v;
                    AndNode nln = AndNode.createNextLevelNode(doc.m, doc.threadId, this, ref, discoveryConfig);
                    if (nln == null) continue;
                    nln.isDiscovered = true;
                    doc.addedNodes.add(nln);
                }
            }
        }
    }

    @Override
    boolean contains(AndNode.Refinement ref) {
        return this == ref.input.get() && Utils.compareInteger(this.key.relativeRid, ref.rid) == 0;
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, INeuron n) {
        return n.bias + (double)Math.abs(this.getSynapse((Integer)(this.key.relativeRid == null ? null : offset), (Neuron)((Neuron)n.provider)).w);
    }

    public Synapse getSynapse(Integer rid, Neuron outputNeuron) {
        this.synapseLock.acquireReadLock();
        Synapse s = this.synapses != null ? this.synapses.get(new SynapseKey(rid, outputNeuron)) : null;
        this.synapseLock.releaseReadLock();
        return s;
    }

    public void setSynapse(Synapse s) {
        this.synapseLock.acquireWriteLock();
        if (this.synapses == null) {
            this.synapses = new TreeMap<SynapseKey, Synapse>();
        }
        this.synapses.put(new SynapseKey(s.key.relativeRid, s.output), s);
        this.synapseLock.releaseWriteLock();
    }

    public void removeSynapse(Synapse s) {
        this.synapseLock.acquireWriteLock();
        this.synapses.remove(new SynapseKey(s.key.relativeRid, s.output));
        this.synapseLock.releaseWriteLock();
    }

    @Override
    public void reactivate() {
        this.inputNeuron.lock.acquireReadLock();
        this.inputNeuron.inMemoryOutputSynapses.values().forEach(s -> {
            if (this.key.compareTo(s.key.createInputNodeKey()) == 0) {
                this.setSynapse((Synapse)s);
            }
        });
        this.inputNeuron.lock.releaseReadLock();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void remove() {
        ((INeuron)this.inputNeuron.get()).outputNodes.remove(this.key);
        super.remove();
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("I");
        sb.append(this.key.isRecurrent ? "R" : "");
        sb.append(this.getRangeBrackets(this.key.startRangeOutput, this.key.startRangeMapping));
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.id);
            if (((INeuron)this.inputNeuron.get()).label != null) {
                sb.append(",");
                sb.append(((INeuron)this.inputNeuron.get()).label);
            }
        }
        sb.append(this.getRangeBrackets(this.key.endRangeOutput, this.key.endRangeMapping));
        return sb.toString();
    }

    private String getRangeBrackets(boolean ro, Range.Mapping rs) {
        if (rs == Range.Mapping.NONE) {
            return "|";
        }
        if (ro) {
            return rs == Range.Mapping.START ? "[" : "]";
        }
        if (!ro) {
            return rs == Range.Mapping.START ? "<" : ">";
        }
        return "|";
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(73);
        super.write(out);
        this.key.write(out);
        out.writeBoolean(this.inputNeuron != null);
        if (this.inputNeuron != null) {
            out.writeInt(this.inputNeuron.id);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        this.key = Synapse.lookupKey(Synapse.Key.read(in, m));
        if (in.readBoolean()) {
            this.inputNeuron = m.lookupNeuron(in.readInt());
        }
    }

    private static class SynapseKey
    implements Writable,
    Comparable<SynapseKey> {
        Integer rid;
        Neuron n;

        private SynapseKey() {
        }

        public SynapseKey(Integer rid, Neuron n) {
            this.rid = rid;
            this.n = n;
        }

        @Override
        public int compareTo(SynapseKey sk) {
            int r = Utils.compareInteger(this.rid, sk.rid);
            if (r != 0) {
                return r;
            }
            return this.n.compareTo(sk.n);
        }

        public static SynapseKey read(DataInput in, Model m) throws IOException {
            SynapseKey sk = new SynapseKey();
            sk.readFields(in, m);
            return sk;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.rid != null);
            if (this.rid != null) {
                out.writeInt(this.rid);
            }
            out.writeInt(this.n.id);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            if (in.readBoolean()) {
                this.rid = in.readInt();
            }
            this.n = m.lookupNeuron(in.readInt());
        }
    }
}

