/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aika.AbstractNode;
import org.aika.Model;
import org.aika.Provider;
import org.aika.Utils;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.corpus.SearchNode;
import org.aika.lattice.InputNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Document
implements Comparable<Document> {
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    public static boolean APPLY_DEBUG_OUTPUT = false;
    public static boolean OPTIMIZE_DEBUG_OUTPUT = false;
    public static int CLEANUP_INTERVAL = 500;
    public static int MAX_ROUND = 20;
    public final int id;
    private final String content;
    public long visitedCounter = 1L;
    public int interpretationIdCounter = 1;
    public int activationIdCounter = 0;
    public int searchNodeIdCounter = 0;
    public InterprNode bottom = new InterprNode(this, -1, 0, 0);
    public SearchNode selectedSearchNode = null;
    public List<InterprNode> bestInterpretation = null;
    public Model m;
    public int threadId;
    public boolean interrupted;
    public Queue queue = new Queue();
    public ValueQueue vQueue = new ValueQueue();
    public UpperBoundQueue ubQueue = new UpperBoundQueue();
    public BackPropagationQueue bQueue = new BackPropagationQueue();
    public TreeSet<Node> activatedNodes = new TreeSet();
    public TreeSet<INeuron> activatedNeurons = new TreeSet();
    public TreeSet<INeuron> finallyActivatedNeurons = new TreeSet();
    public TreeSet<Activation> inputNeuronActivations = new TreeSet();
    public TreeSet<Activation> targetActivations = new TreeSet();
    public TreeSet<Activation> errorSignalActivations = new TreeSet();
    public TreeMap<NodeActivation.Key, NodeActivation> activationsByRid = new TreeMap(new Comparator<NodeActivation.Key>(){

        @Override
        public int compare(NodeActivation.Key act1, NodeActivation.Key act2) {
            int r = Integer.compare(act1.rid, act2.rid);
            if (r != 0) {
                return r;
            }
            return act1.compareTo(act2);
        }
    });
    public TreeSet<Node> addedNodes = new TreeSet();
    public static Comparator<NodeActivation> ACTIVATIONS_OUTPUT_COMPARATOR = new Comparator<NodeActivation>(){

        @Override
        public int compare(NodeActivation act1, NodeActivation act2) {
            int r = Range.compare(act1.key.r, act2.key.r, false);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(act1.key.rid, act2.key.rid);
            if (r != 0) {
                return r;
            }
            r = act1.key.o.compareTo(act2.key.o);
            if (r != 0) {
                return r;
            }
            return ((Node)act1.key.n).compareTo((Node)act2.key.n);
        }
    };

    public Document(int id, String content, Model m, int threadId) {
        this.id = id;
        this.content = content;
        this.m = m;
        this.threadId = threadId;
    }

    public String getContent() {
        return this.content;
    }

    public int length() {
        return this.content.length();
    }

    public String toString() {
        return this.content;
    }

    public String getText(Range r) {
        return this.content.substring(Math.max(0, Math.min(r.begin, this.length())), Math.max(0, Math.min(r.end, this.length())));
    }

    public String bestInterpretationToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Best Interpretation:\n");
        sb.append(this.bestInterpretation.toString());
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public int compareTo(Document doc) {
        return Integer.compare(this.id, doc.id);
    }

    public void propagate() {
        boolean flag = true;
        while (flag) {
            this.queue.processChanges();
            flag = this.ubQueue.process();
        }
    }

    public void process() {
        for (Activation act : this.inputNeuronActivations) {
            this.vQueue.propagateWeight(0, act);
        }
        this.interrupted = false;
        SearchNode root = new SearchNode(this, null, null, null, -1, Collections.emptyList());
        root.computeBestInterpretation(this);
    }

    public void discoverPatterns(DiscoveryConfig discoveryConfig) {
        for (Node n : this.activatedNodes) {
            Node.ThreadState th;
            discoveryConfig.counter.count(this, n);
            if (!discoveryConfig.checkExpandable.evaluate(n) || (th = n.getThreadState(this.threadId, false)) == null) continue;
            for (NodeActivation act : th.activations.values()) {
                n.discover(this, act, discoveryConfig);
            }
        }
    }

    public void train(TrainConfig trainConfig) {
        for (Activation tAct : this.targetActivations) {
            ((INeuron)((OrNode)tAct.key.n).neuron.get()).computeOutputErrorSignal(this, tAct);
        }
        if (trainConfig.performBackpropagation) {
            this.bQueue.backpropagtion();
        }
        for (Activation act : this.errorSignalActivations) {
            ((INeuron)((OrNode)act.key.n).neuron.get()).train(this, act, trainConfig.learnRate, trainConfig.synapseEvaluation);
        }
        this.errorSignalActivations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActivations() {
        for (Node n : this.activatedNodes) {
            n.clearActivations(this);
        }
        this.activatedNodes.clear();
        this.addedNodes.clear();
        if (this.m.lastCleanup[this.threadId] + CLEANUP_INTERVAL < this.id) {
            ArrayList<Provider<? extends AbstractNode>> tmp;
            this.m.lastCleanup[this.threadId] = this.id;
            Map<Integer, Provider<? extends AbstractNode>> map = this.m.activeProviders;
            synchronized (map) {
                tmp = new ArrayList<Provider<? extends AbstractNode>>(this.m.activeProviders.values());
            }
            for (Provider provider : tmp) {
                Object an;
                if (provider == null || (an = provider.getIfNotSuspended()) == null || !(an instanceof Node)) continue;
                Node n = (Node)an;
                Node.ThreadState th = n.threads[this.threadId];
                if (th == null || th.lastUsed + (long)CLEANUP_INTERVAL >= (long)this.id) continue;
                n.threads[this.threadId] = null;
            }
        }
        this.m.docs[this.threadId] = null;
    }

    public String generateOutputText() {
        StringBuilder sb = new StringBuilder();
        for (INeuron n : this.finallyActivatedNeurons) {
            if (n.outputText == null) continue;
            for (Activation act : n.getFinalActivations(this)) {
                sb.replace(act.key.r.begin, act.key.r.end, n.outputText);
            }
        }
        return sb.toString();
    }

    public String neuronActivationsToString(boolean withWeights) {
        return this.neuronActivationsToString(withWeights, false, false);
    }

    public String neuronActivationsToString(boolean withWeights, boolean withTextSnipped, boolean withLogic) {
        TreeSet<NodeActivation> acts = new TreeSet<NodeActivation>(ACTIVATIONS_OUTPUT_COMPARATOR);
        for (INeuron n : this.activatedNeurons) {
            Stream<?> stream = NodeActivation.select(this, (Node)n.node.get(), null, null, null, null, null, InterprNode.Relation.CONTAINED_IN);
            acts.addAll(stream.collect(Collectors.toList()));
        }
        StringBuilder sb = new StringBuilder();
        for (Activation activation : acts) {
            if (activation.upperBound <= 0.0) continue;
            sb.append(activation.id + " ");
            sb.append(activation.key.r);
            if (withTextSnipped) {
                sb.append(" ");
                if (((INeuron)((OrNode)activation.key.n).neuron.get()).outputText != null) {
                    sb.append(this.collapseText(((INeuron)((OrNode)activation.key.n).neuron.get()).outputText));
                } else {
                    sb.append(this.collapseText(this.getText(activation.key.r)));
                }
            }
            sb.append(" - ");
            sb.append(activation.key.o);
            sb.append(" - ");
            sb.append(withLogic ? ((OrNode)activation.key.n).toString() : ((OrNode)activation.key.n).getNeuronLabel());
            sb.append(" - Rid:");
            sb.append(activation.key.rid);
            sb.append(" - UB:");
            sb.append(Utils.round(activation.upperBound));
            if (withWeights) {
                sb.append(" - ");
                for (Map.Entry<Integer, Activation.State> me : activation.rounds.rounds.entrySet()) {
                    Activation.State s = me.getValue();
                    sb.append("[R:" + me.getKey());
                    sb.append(" VALUE:" + Utils.round(s.value));
                    sb.append(" W:" + Utils.round(s.weight.w));
                    sb.append(" N:" + Utils.round(s.weight.n));
                    sb.append("]");
                }
                if (activation.finalState != null && activation.finalState.weight != null) {
                    sb.append(" - FV:" + Utils.round(activation.finalState.value));
                    sb.append(" FW:" + Utils.round(activation.finalState.weight.w));
                    sb.append(" FN:" + Utils.round(activation.finalState.weight.n));
                }
            }
            sb.append("\n");
        }
        if (this.selectedSearchNode != null) {
            sb.append("\n Final SearchNode:" + this.selectedSearchNode.id + "  WeightSum:" + this.selectedSearchNode.accumulatedWeight.toString() + "\n");
        }
        return sb.toString();
    }

    public String nodeActivationsToString(boolean withTextSnipped, boolean withLogic) {
        TreeSet<NodeActivation> acts = new TreeSet<NodeActivation>(ACTIVATIONS_OUTPUT_COMPARATOR);
        for (Node n : this.activatedNodes) {
            acts.addAll(NodeActivation.select(this, n, null, null, null, null, null, InterprNode.Relation.CONTAINED_IN).collect(Collectors.toList()));
        }
        StringBuilder sb = new StringBuilder();
        for (NodeActivation act : acts) {
            sb.append(act.id + " ");
            sb.append(act.key.r);
            if (withTextSnipped) {
                sb.append(" ");
                sb.append(this.collapseText(this.getText(act.key.r)));
            }
            sb.append(" - ");
            sb.append(act.key.o);
            sb.append(" - ");
            sb.append(withLogic ? ((Node)act.key.n).toString() : ((Node)act.key.n).getNeuronLabel());
            sb.append(" - Rid:");
            sb.append(act.key.rid);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String collapseText(String txt) {
        if (txt.length() <= 10) {
            return txt;
        }
        return txt.substring(0, 5) + "..." + txt.substring(txt.length() - 5);
    }

    public static interface Counter {
        public void count(Document var1, Node var2);
    }

    public static interface SynapseEvaluation {
        public Synapse.Key evaluate(Activation var1, Activation var2);
    }

    public static interface PatternEvaluation {
        public boolean evaluate(Node var1);
    }

    public class BackPropagationQueue {
        public final TreeSet<Activation> queue = new TreeSet<Activation>(new Comparator<Activation>(){

            @Override
            public int compare(Activation act1, Activation act2) {
                Activation.State fs1 = act1.finalState;
                Activation.State fs2 = act2.finalState;
                int r = 0;
                if (fs2 == null && fs1 != null) {
                    return -1;
                }
                if (fs2 != null && fs1 == null) {
                    return 1;
                }
                if (fs2 != null && fs1 != null) {
                    r = Integer.compare(fs2.fired, fs1.fired);
                }
                if (r != 0) {
                    return r;
                }
                return act1.key.compareTo(act2.key);
            }
        });
        private long queueIdCounter = 0L;

        public void add(Activation act) {
            if (!act.isQueued) {
                act.isQueued = true;
                act.queueId = this.queueIdCounter++;
                this.queue.add(act);
            }
        }

        public void backpropagtion() {
            while (!this.queue.isEmpty()) {
                Activation act = this.queue.pollFirst();
                act.isQueued = false;
                ((INeuron)((OrNode)act.key.n).neuron.get()).computeBackpropagationErrorSignal(Document.this, act);
            }
        }
    }

    public class ValueQueue {
        public final ArrayList<ArrayDeque<Activation>> queue = new ArrayList();

        public void propagateWeight(int round, Activation act) {
            for (Activation.SynapseActivation sa : act.neuronOutputs) {
                int r = sa.s.key.isRecurrent ? round + 1 : round;
                this.add(r, sa.output);
            }
        }

        public INeuron.NormWeight adjustWeight(SearchNode cand, List<InterprNode> changed) {
            long v = Document.this.visitedCounter++;
            for (InterprNode n : changed) {
                this.addAllActs(n.getNeuronActivations());
                if (n.refByOrInterprNode == null) continue;
                for (InterprNode on : n.refByOrInterprNode) {
                    this.addAllActs(on.getNeuronActivations());
                }
            }
            return this.processChanges(cand, v);
        }

        private void addAllActs(Collection<Activation> acts) {
            for (Activation act : acts) {
                this.add(0, act);
                for (Activation.SynapseActivation sa : act.neuronOutputs) {
                    if (!sa.s.key.isRecurrent) continue;
                    this.add(0, sa.output);
                }
            }
        }

        public void add(int round, Activation act) {
            ArrayDeque<Activation> q;
            if (act.rounds.isQueued(round)) {
                return;
            }
            if (round < this.queue.size()) {
                q = this.queue.get(round);
            } else {
                assert (round == this.queue.size());
                q = new ArrayDeque();
                this.queue.add(q);
            }
            act.rounds.setQueued(round, true);
            q.addLast(act);
        }

        public INeuron.NormWeight processChanges(SearchNode sn, long v) {
            INeuron.NormWeight delta = INeuron.NormWeight.ZERO_WEIGHT;
            for (int round = 0; round < this.queue.size(); ++round) {
                ArrayDeque<Activation> q = this.queue.get(round);
                while (!q.isEmpty()) {
                    Activation.State s;
                    Activation act = q.pollLast();
                    act.rounds.setQueued(round, false);
                    Activation.State state = s = act.isInput ? act.finalState : ((INeuron)((OrNode)act.key.n).neuron.get()).computeWeight(round, act, sn, Document.this);
                    if (OPTIMIZE_DEBUG_OUTPUT) {
                        log.info(act.key + " Round:" + round);
                        log.info("Value:" + s.value + "  Weight:" + s.weight.w + "  Norm:" + s.weight.n + "\n");
                    }
                    if (round != 0 && act.rounds.get(round).equalsWithWeights(s)) continue;
                    SearchNode.StateChange.saveOldState(sn.modifiedActs, act, v);
                    Activation.State oldState = act.rounds.get(round);
                    boolean propagate = act.rounds.set(round, s);
                    SearchNode.StateChange.saveNewState(act);
                    if (propagate) {
                        if (round > MAX_ROUND) {
                            log.error("Maximum number of rounds reached.");
                            sn.dumpDebugState();
                        } else {
                            this.propagateWeight(round, act);
                        }
                    }
                    if (round == 0) {
                        this.add(1, act);
                    }
                    if (act.rounds.getLastRound() == null || round < act.rounds.getLastRound()) continue;
                    delta = delta.add(s.weight.sub(oldState.weight));
                }
            }
            return delta;
        }
    }

    public class UpperBoundQueue {
        public final ArrayDeque<Activation> queue = new ArrayDeque();

        public void add(Activation act) {
            if (!act.ubQueued) {
                act.ubQueued = true;
                this.queue.addLast(act);
            }
        }

        public boolean process() {
            boolean flag = false;
            while (!this.queue.isEmpty()) {
                flag = true;
                Activation act = this.queue.pollFirst();
                act.ubQueued = false;
                double oldUpperBound = act.isInput ? 0.0 : act.upperBound;
                INeuron n = (INeuron)((OrNode)act.key.n).neuron.get();
                if (!act.isInput) {
                    n.computeBounds(act);
                }
                if (Math.abs(act.upperBound - oldUpperBound) > 0.01) {
                    for (Activation.SynapseActivation synapseActivation : act.neuronOutputs) {
                        this.add(synapseActivation.output);
                    }
                }
                if (!(oldUpperBound <= 0.0) || !(act.upperBound > 0.0)) continue;
                for (Provider provider : n.outputNodes.values()) {
                    ((InputNode)provider.get()).addActivation(Document.this, act);
                }
            }
            return flag;
        }
    }

    public class Queue {
        public final TreeSet<Node> queue = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                int r = Integer.compare(n1.level, n2.level);
                if (r != 0) {
                    return r;
                }
                Node.ThreadState th1 = n1.getThreadState(Document.this.threadId, true);
                Node.ThreadState th2 = n2.getThreadState(Document.this.threadId, true);
                return Long.compare(th1.queueId, th2.queueId);
            }
        });
        private long queueIdCounter = 0L;

        public void add(Node n) {
            Node.ThreadState th = n.getThreadState(Document.this.threadId, true);
            if (!th.isQueued) {
                th.isQueued = true;
                th.queueId = this.queueIdCounter++;
                this.queue.add(n);
            }
        }

        public void processChanges() {
            while (!this.queue.isEmpty()) {
                Node n = this.queue.pollFirst();
                Node.ThreadState th = n.getThreadState(Document.this.threadId, true);
                th.isQueued = false;
                n.processChanges(Document.this);
                if (!APPLY_DEBUG_OUTPUT) continue;
                log.info("QueueId:" + th.queueId);
                log.info(n.toString() + "\n");
                log.info("\n" + Document.this.nodeActivationsToString(true, false));
            }
        }
    }

    public static class TrainConfig {
        public SynapseEvaluation synapseEvaluation;
        public double learnRate;
        public boolean performBackpropagation;

        public TrainConfig setSynapseEvaluation(SynapseEvaluation synapseEvaluation) {
            this.synapseEvaluation = synapseEvaluation;
            return this;
        }

        public TrainConfig setLearnRate(double learnRate) {
            this.learnRate = learnRate;
            return this;
        }

        public TrainConfig setPerformBackpropagation(boolean performBackpropagation) {
            this.performBackpropagation = performBackpropagation;
            return this;
        }
    }

    public static class DiscoveryConfig {
        public PatternEvaluation checkValidPattern;
        public PatternEvaluation checkExpandable;
        public Counter counter;

        public DiscoveryConfig setCheckValidPattern(PatternEvaluation checkValidPattern) {
            this.checkValidPattern = checkValidPattern;
            return this;
        }

        public DiscoveryConfig setCheckExpandable(PatternEvaluation checkExpandable) {
            this.checkExpandable = checkExpandable;
            return this;
        }

        public DiscoveryConfig setCounter(Counter counter) {
            this.counter = counter;
            return this;
        }
    }
}

