/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.Utils;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNode
implements Comparable<SearchNode> {
    private static final Logger log = LoggerFactory.getLogger(SearchNode.class);
    public static int MAX_SEARCH_STEPS = 100000;
    public int id;
    public SearchNode excludedParent;
    public SearchNode selectedParent;
    public long visited;
    List<InterprNode> refinement;
    Candidate candidate;
    int level;
    DebugState debugState;
    INeuron.NormWeight weightDelta = INeuron.NormWeight.ZERO_WEIGHT;
    INeuron.NormWeight accumulatedWeight;
    public List<StateChange> modifiedActs = new ArrayList<StateChange>();

    public SearchNode(Document doc, SearchNode selParent, SearchNode exclParent, Candidate c, int level, List<InterprNode> changed) {
        this.id = doc.searchNodeIdCounter++;
        this.level = level;
        this.visited = doc.visitedCounter++;
        this.selectedParent = selParent;
        this.excludedParent = exclParent;
        if (c != null) {
            this.refinement = this.expandRefinement(Collections.singletonList(c.refinement), doc.visitedCounter++);
            this.candidate = c;
        }
        this.weightDelta = doc.vQueue.adjustWeight(this, changed);
        if (this.getParent() != null) {
            this.accumulatedWeight = this.weightDelta.add(this.getParent().accumulatedWeight);
        }
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Search Step: " + this.id + "  Candidate Weight Delta: " + this.weightDelta);
            log.info(doc.neuronActivationsToString(true, true, false) + "\n");
        }
    }

    private void collectResults(Collection<InterprNode> results) {
        if (this.refinement != null) {
            results.addAll(this.refinement);
        }
        if (this.selectedParent != null) {
            this.selectedParent.collectResults(results);
        }
    }

    public void computeBestInterpretation(Document doc) {
        Candidate[] candidates;
        ArrayList<InterprNode> results = new ArrayList<InterprNode>();
        results.add(doc.bottom);
        int[] searchSteps = new int[1];
        List<InterprNode> rootRefs = SearchNode.expandRootRefinement(doc);
        this.refinement = this.expandRefinement(rootRefs, doc.visitedCounter++);
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Root SearchNode:" + this.toString());
        }
        Candidate c = (candidates = this.generateCandidates(doc)).length > this.level + 1 ? candidates[this.level + 1] : null;
        ArrayList<InterprNode> changed = new ArrayList<InterprNode>();
        changed.addAll(this.refinement);
        this.markSelected(changed, this.refinement);
        this.markExcluded(changed, this.refinement);
        SearchNode child = new SearchNode(doc, this, null, c, this.level + 1, changed);
        child.search(doc, searchSteps, candidates);
        this.markUnselected(this.refinement);
        if (doc.selectedSearchNode != null) {
            doc.selectedSearchNode.reconstructSelectedResult(doc);
            doc.selectedSearchNode.collectResults(results);
        }
        doc.bestInterpretation = results;
        if (doc.interrupted) {
            log.warn("The search for the best interpretation has been interrupted. Too many search steps!");
        }
    }

    private void reconstructSelectedResult(Document doc) {
        if (this.selectedParent != null) {
            this.selectedParent.reconstructSelectedResult(doc);
        }
        this.changeState(StateChange.Mode.NEW);
        for (StateChange sc : this.modifiedActs) {
            Activation act = sc.act;
            if (act.finalState == null || !(act.finalState.value > 0.0)) continue;
            doc.finallyActivatedNeurons.add((INeuron)((OrNode)act.key.n).neuron.get());
        }
    }

    public void dumpDebugState() {
        for (SearchNode n = this; n != null && n.level >= 0; n = n.getParent()) {
            System.out.println(n.level + " " + (Object)((Object)n.debugState) + " CS:" + n.candidate.cache.size() + " LIMITED:" + n.candidate.debugCounts[DebugState.LIMITED.ordinal()] + " CACHED:" + n.candidate.debugCounts[DebugState.CACHED.ordinal()] + " EXPLORE:" + n.candidate.debugCounts[DebugState.EXPLORE.ordinal()] + " " + n.candidate.refinement.act.key.r + " " + ((INeuron)((OrNode)n.candidate.refinement.act.key.n).neuron.get()).label);
        }
    }

    private INeuron.NormWeight search(Document doc, int[] searchSteps, Candidate[] candidates) {
        boolean dir;
        SearchNode child;
        Candidate c;
        List<InterprNode> changed;
        if (this.candidate == null) {
            return this.processResult(doc);
        }
        INeuron.NormWeight selectedWeight = INeuron.NormWeight.ZERO_WEIGHT;
        INeuron.NormWeight excludedWeight = INeuron.NormWeight.ZERO_WEIGHT;
        boolean alreadySelected = this.checkSelected(this.refinement);
        boolean alreadyExcluded = this.checkExcluded(this.refinement, doc.visitedCounter++);
        if (searchSteps[0] > MAX_SEARCH_STEPS) {
            doc.interrupted = true;
            this.dumpDebugState();
        }
        searchSteps[0] = searchSteps[0] + 1;
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Search Step: " + this.id);
            log.info(this.toString());
        }
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info(doc.neuronActivationsToString(true, true, false) + "\n");
        }
        this.debugState = alreadyExcluded || alreadySelected ? DebugState.LIMITED : DebugState.EXPLORE;
        CachedEntry cd = !alreadyExcluded && !alreadySelected ? this.getCachedDecision() : null;
        int n = this.debugState.ordinal();
        this.candidate.debugCounts[n] = this.candidate.debugCounts[n] + 1;
        if (!alreadyExcluded) {
            changed = new ArrayList<InterprNode>();
            changed.add(this.candidate.refinement);
            this.markSelected(changed, this.refinement);
            this.markExcluded(changed, this.refinement);
            if (cd == null || cd.dir && this.accumulatedWeight.add(cd.weight).getNormWeight() >= this.getSelectedAccumulatedWeight(doc)) {
                c = candidates.length > this.level + 1 ? candidates[this.level + 1] : null;
                child = new SearchNode(doc, this, this.excludedParent, c, this.level + 1, changed);
                selectedWeight = child.search(doc, searchSteps, candidates);
                child.changeState(StateChange.Mode.OLD);
            }
            this.markUnselected(this.refinement);
        }
        if (doc.interrupted) {
            return INeuron.NormWeight.ZERO_WEIGHT;
        }
        if (!alreadySelected) {
            this.candidate.refinement.markedExcludedRefinement = true;
            changed = Collections.singletonList(this.candidate.refinement);
            if (cd == null || !cd.dir && this.accumulatedWeight.add(cd.weight).getNormWeight() >= this.getSelectedAccumulatedWeight(doc)) {
                c = candidates.length > this.level + 1 ? candidates[this.level + 1] : null;
                child = new SearchNode(doc, this.selectedParent, this, c, this.level + 1, changed);
                excludedWeight = child.search(doc, searchSteps, candidates);
                child.changeState(StateChange.Mode.OLD);
            }
            this.candidate.refinement.markedExcludedRefinement = false;
        }
        boolean bl = dir = selectedWeight.getNormWeight() >= excludedWeight.getNormWeight();
        if (cd == null && !alreadyExcluded && !alreadySelected) {
            this.candidate.cache.put(this, new CachedEntry(dir, dir ? selectedWeight.sub(this.accumulatedWeight) : excludedWeight.sub(this.accumulatedWeight)));
        }
        return dir ? selectedWeight : excludedWeight;
    }

    private INeuron.NormWeight processResult(Document doc) {
        double accNW = this.accumulatedWeight.getNormWeight();
        if (accNW > this.getSelectedAccumulatedWeight(doc)) {
            doc.selectedSearchNode = this;
            doc.bottom.storeFinalWeight(doc.visitedCounter++);
        }
        return this.accumulatedWeight;
    }

    private double getSelectedAccumulatedWeight(Document doc) {
        return doc.selectedSearchNode != null ? doc.selectedSearchNode.accumulatedWeight.getNormWeight() : -1.0;
    }

    public Candidate[] generateCandidates(Document doc) {
        TreeSet<Candidate> candidates = new TreeSet<Candidate>();
        int i = 0;
        for (InterprNode cn : SearchNode.collectConflicts(doc)) {
            candidates.add(new Candidate(cn, i++));
        }
        return candidates.toArray(new Candidate[candidates.size()]);
    }

    private boolean checkSelected(List<InterprNode> n) {
        for (InterprNode x : n) {
            if (this.isCovered(x.markedSelected)) continue;
            return false;
        }
        return true;
    }

    private boolean checkExcluded(List<InterprNode> n, long v) {
        for (InterprNode x : n) {
            if (!this.checkExcluded(x, v)) continue;
            return true;
        }
        return false;
    }

    private boolean checkExcluded(InterprNode ref, long v) {
        if (ref.visitedCheckExcluded == v) {
            return false;
        }
        ref.visitedCheckExcluded = v;
        if (this.isCovered(ref.markedExcluded)) {
            return true;
        }
        for (InterprNode pn : ref.parents) {
            if (!this.checkExcluded(pn, v)) continue;
            return true;
        }
        return false;
    }

    public static Set<InterprNode> collectConflicts(Document doc) {
        TreeSet<InterprNode> results = new TreeSet<InterprNode>();
        long v = doc.visitedCounter++;
        for (InterprNode n : doc.bottom.children) {
            if (!n.conflicts.primary.isEmpty()) {
                results.add(n);
            }
            for (Conflicts.Conflict c : n.conflicts.secondary.values()) {
                results.add(c.secondary);
            }
        }
        return results;
    }

    private static List<InterprNode> expandRootRefinement(Document doc) {
        ArrayList<InterprNode> tmp = new ArrayList<InterprNode>();
        tmp.add(doc.bottom);
        for (InterprNode pn : doc.bottom.children) {
            if (pn.orInterprNodes != null && !pn.orInterprNodes.isEmpty() || !pn.conflicts.primary.isEmpty() || !pn.conflicts.secondary.isEmpty()) continue;
            tmp.add(pn);
        }
        return tmp;
    }

    private List<InterprNode> expandRefinement(List<InterprNode> ref, long v) {
        ArrayList<InterprNode> tmp = new ArrayList<InterprNode>();
        for (InterprNode n : ref) {
            this.markExpandRefinement(n, v);
            tmp.add(n);
        }
        for (InterprNode n : ref) {
            this.expandRefinementRecursiveStep(tmp, n, v);
        }
        if (ref.size() == tmp.size()) {
            return tmp;
        }
        return this.expandRefinement(tmp, v);
    }

    private void markExpandRefinement(InterprNode n, long v) {
        if (n.markedExpandRefinement == v) {
            return;
        }
        n.markedExpandRefinement = v;
        for (InterprNode pn : n.parents) {
            this.markExpandRefinement(pn, v);
        }
    }

    private boolean hasUncoveredConflicts(InterprNode n) {
        if (!n.conflicts.hasConflicts()) {
            return false;
        }
        ArrayList<InterprNode> conflicts = new ArrayList<InterprNode>();
        Conflicts.collectDirectConflicting(conflicts, n);
        for (InterprNode cn : conflicts) {
            if (this.isCovered(cn.markedExcluded)) continue;
            return true;
        }
        return false;
    }

    private void expandRefinementRecursiveStep(Collection<InterprNode> results, InterprNode n, long v) {
        if (n.visitedExpandRefinementRecursiveStep == v) {
            return;
        }
        n.visitedExpandRefinementRecursiveStep = v;
        if (n.refByOrInterprNode != null) {
            for (InterprNode on : n.refByOrInterprNode) {
                if (on.markedExpandRefinement == v || this.hasUncoveredConflicts(on) || this.isCovered(on.markedSelected)) continue;
                this.markExpandRefinement(on, v);
                results.add(on);
            }
        }
        for (InterprNode pn : n.parents) {
            if (pn.isBottom()) continue;
            this.expandRefinementRecursiveStep(results, pn, v);
        }
        if (n.isBottom()) {
            return;
        }
        for (InterprNode cn : n.children) {
            if (cn.visitedExpandRefinementRecursiveStep == v) break;
            boolean covered = true;
            for (InterprNode cnp : cn.parents) {
                if (cnp.visitedExpandRefinementRecursiveStep == v || this.isCovered(cnp.markedSelected)) continue;
                covered = false;
                break;
            }
            if (!covered) continue;
            this.expandRefinementRecursiveStep(results, cn, v);
        }
    }

    public Coverage getCoverage(InterprNode n) {
        if (n.markedExcludedRefinement) {
            return Coverage.EXCLUDED;
        }
        if (this.isCovered(n.markedSelected)) {
            return Coverage.SELECTED;
        }
        if (this.isCovered(n.markedExcluded)) {
            return Coverage.EXCLUDED;
        }
        return Coverage.UNKNOWN;
    }

    public boolean isCovered(long g) {
        SearchNode n = this;
        do {
            if (g == n.visited) {
                return true;
            }
            if (g <= n.visited) continue;
            return false;
        } while ((n = n.selectedParent) != null);
        return false;
    }

    private void markSelected(List<InterprNode> changed, List<InterprNode> n) {
        for (InterprNode x : n) {
            this.markSelected(changed, x);
        }
    }

    private void markSelected(List<InterprNode> changed, InterprNode n) {
        if (this.isCovered(n.markedSelected)) {
            return;
        }
        n.markedSelected = this.visited;
        if (n.refByOrInterprNode != null) {
            for (InterprNode ref : n.refByOrInterprNode) {
                if (ref.selectedOrInterprNodes == null) {
                    ref.selectedOrInterprNodes = new TreeSet<InterprNode>();
                }
                ref.selectedOrInterprNodes.add(n);
            }
        }
        if (n.isBottom()) {
            return;
        }
        if (changed != null) {
            changed.add(n);
        }
    }

    private void markUnselected(List<InterprNode> n) {
        for (InterprNode x : n) {
            if (x.markedSelected != this.visited || x.refByOrInterprNode == null) continue;
            for (InterprNode ref : x.refByOrInterprNode) {
                ref.selectedOrInterprNodes.remove(x);
            }
        }
    }

    private void markExcluded(List<InterprNode> changed, List<InterprNode> n) {
        for (InterprNode x : n) {
            this.markExcluded(changed, x);
        }
    }

    private void markExcluded(List<InterprNode> changed, InterprNode n) {
        ArrayList<InterprNode> conflicting = new ArrayList<InterprNode>();
        Conflicts.collectAllConflicting(conflicting, n, n.doc.visitedCounter++);
        for (InterprNode cn : conflicting) {
            this.markExcludedRecursiveStep(changed, cn);
        }
    }

    private void markExcludedRecursiveStep(List<InterprNode> changed, InterprNode n) {
        if (this.isCovered(n.markedExcluded)) {
            return;
        }
        n.markedExcluded = this.visited;
        for (InterprNode c : n.children) {
            this.markExcludedRecursiveStep(changed, c);
        }
        if (n.linkedByLCS != null) {
            for (InterprNode c : n.linkedByLCS) {
                if (!this.checkOrNodeExcluded(c)) continue;
                this.markExcludedRecursiveStep(changed, c);
            }
        }
        if (changed != null) {
            changed.add(n);
        }
    }

    private boolean checkOrNodeExcluded(InterprNode n) {
        for (InterprNode on : n.orInterprNodes) {
            if (this.isCovered(on.markedExcluded)) continue;
            return false;
        }
        return true;
    }

    public String pathToString(Document doc) {
        return (this.selectedParent != null ? this.selectedParent.pathToString(doc) : "") + " - " + this.toString(doc);
    }

    public String toString(Document doc) {
        TreeSet<InterprNode> tmp = new TreeSet<InterprNode>();
        for (InterprNode n : this.refinement) {
            n.collectPrimitiveNodes(tmp, doc.interpretationIdCounter++);
        }
        StringBuilder sb = new StringBuilder();
        for (InterprNode n : tmp) {
            sb.append(n.primId);
            sb.append(", ");
        }
        return sb.toString();
    }

    public void changeState(StateChange.Mode m) {
        for (StateChange sc : this.modifiedActs) {
            sc.restoreState(m);
        }
    }

    @Override
    public int compareTo(SearchNode sn) {
        return Integer.compare(this.id, sn.id);
    }

    public SearchNode getParent() {
        return this.getDecision() ? this.selectedParent : this.excludedParent;
    }

    private boolean getDecision() {
        return this.excludedParent == null || this.selectedParent.id > this.excludedParent.id;
    }

    public CachedEntry getCachedDecision() {
        for (Map.Entry<SearchNode, CachedEntry> me : this.candidate.cache.entrySet()) {
            SearchNode n = this;
            SearchNode cn = me.getKey();
            while (n.getDecision() == cn.getDecision() || !this.affectsUnknown(n.getParent())) {
                n = n.getParent();
                cn = cn.getParent();
                if (n.selectedParent != null) continue;
                this.debugState = DebugState.CACHED;
                return me.getValue();
            }
        }
        return null;
    }

    public boolean affectsUnknown(SearchNode p) {
        for (InterprNode n : p.refinement) {
            if (n.act == null) continue;
            for (Activation.SynapseActivation sa : n.act.neuronOutputs) {
                if (!sa.s.key.isRecurrent || sa.s.isNegative() || this.getCoverage(sa.output.key.o) != Coverage.UNKNOWN) continue;
                return true;
            }
        }
        return false;
    }

    private static class Candidate
    implements Comparable<Candidate> {
        public TreeMap<SearchNode, CachedEntry> cache = new TreeMap();
        public InterprNode refinement;
        int[] debugCounts = new int[3];
        int id;
        int minBegin;
        int maxEnd;
        Integer minRid;

        public Candidate(InterprNode refinement, int id) {
            this.refinement = refinement;
            if (refinement.act != null) {
                this.minBegin = refinement.act.key.r.begin;
                this.maxEnd = refinement.act.key.r.end;
                this.minRid = refinement.act.key.rid;
            } else {
                for (NodeActivation act : refinement.getActivations()) {
                    if (act.key.r != null) {
                        this.minBegin = Math.min(this.minBegin, act.key.r.begin);
                        this.maxEnd = Math.max(this.maxEnd, act.key.r.end);
                    }
                    this.minRid = Utils.nullSafeMin(this.minRid, act.key.rid);
                }
            }
            this.id = id;
        }

        @Override
        public int compareTo(Candidate c) {
            int r = Integer.compare(this.minBegin, c.minBegin);
            if (r != 0) {
                return r;
            }
            r = Integer.compare(c.maxEnd, this.maxEnd);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(this.minRid, c.minRid);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.id, c.id);
        }
    }

    private static class CachedEntry {
        boolean dir;
        INeuron.NormWeight weight;

        private CachedEntry(boolean dir, INeuron.NormWeight weight) {
            this.dir = dir;
            this.weight = weight;
        }
    }

    public static class StateChange {
        public Activation act;
        public Activation.Rounds oldRounds;
        public Activation.Rounds newRounds;

        public static void saveOldState(List<StateChange> changes, Activation act, long v) {
            StateChange sc = act.currentStateChange;
            if (sc == null || act.currentStateV != v) {
                sc = new StateChange();
                sc.oldRounds = act.rounds.copy();
                act.currentStateChange = sc;
                act.currentStateV = v;
                sc.act = act;
                if (changes != null) {
                    changes.add(sc);
                }
            }
        }

        public static void saveNewState(Activation act) {
            StateChange sc = act.currentStateChange;
            sc.newRounds = act.rounds;
        }

        public void restoreState(Mode m) {
            this.act.rounds = (m == Mode.OLD ? this.oldRounds : this.newRounds).copy();
        }

        public static enum Mode {
            OLD,
            NEW;

        }
    }

    public static enum Coverage {
        SELECTED,
        UNKNOWN,
        EXCLUDED;

    }

    public static enum DebugState {
        CACHED,
        LIMITED,
        EXPLORE;

    }
}

