/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.aika.AbstractNode;
import org.aika.Model;
import org.aika.Provider;
import org.aika.ReadWriteLock;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.InputNode;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.INeuron;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Node<T extends Node, A extends NodeActivation<T>>
extends AbstractNode<Provider<T>>
implements Comparable<Node> {
    public static int MAX_RELATIVE_RID = 25;
    public static final Node MIN_NODE = new InputNode();
    public static final Node MAX_NODE = new InputNode();
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    public TreeMap<ReverseAndRefinement, AndNode.Refinement> reverseAndChildren;
    public TreeMap<AndNode.Refinement, Provider<AndNode>> andChildren;
    public TreeSet<OrNode.OrEntry> orChildren;
    public TreeSet<OrNode.OrEntry> allOrChildren;
    public int level;
    public Writable statistic;
    public boolean isDiscovered;
    public boolean endRequired;
    public boolean ridRequired;
    public AtomicInteger numberOfNeuronRefs = new AtomicInteger(0);
    volatile boolean isRemoved;
    public ReadWriteLock lock = new ReadWriteLock();
    public ThreadState<T, A>[] threads;
    public static final Comparator<NodeActivation.Key> BEGIN_COMP = new Comparator<NodeActivation.Key>(){

        @Override
        public int compare(NodeActivation.Key k1, NodeActivation.Key k2) {
            int r = Range.compare(k1.r, k2.r, false);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(k1.rid, k2.rid);
            if (r != 0) {
                return r;
            }
            return InterprNode.compare(k1.o, k2.o);
        }
    };
    public static final Comparator<NodeActivation.Key> END_COMP = new Comparator<NodeActivation.Key>(){

        @Override
        public int compare(NodeActivation.Key k1, NodeActivation.Key k2) {
            int r = Range.compare(k1.r, k2.r, true);
            if (r != 0) {
                return r;
            }
            r = Utils.compareInteger(k1.rid, k2.rid);
            if (r != 0) {
                return r;
            }
            return InterprNode.compare(k1.o, k2.o);
        }
    };
    public static final Comparator<NodeActivation.Key> RID_COMP = new Comparator<NodeActivation.Key>(){

        @Override
        public int compare(NodeActivation.Key k1, NodeActivation.Key k2) {
            int r = Utils.compareInteger(k1.rid, k2.rid);
            if (r != 0) {
                return r;
            }
            r = Range.compare(k1.r, k2.r, false);
            if (r != 0) {
                return r;
            }
            return InterprNode.compare(k1.o, k2.o);
        }
    };

    public ThreadState<T, A> getThreadState(int threadId, boolean create) {
        ThreadState<T, A> th = this.threads[threadId];
        if (th == null) {
            if (!create) {
                return null;
            }
            this.threads[threadId] = th = new ThreadState(this.endRequired, this.ridRequired);
        }
        th.lastUsed = this.provider.m.docIdCounter.get();
        return th;
    }

    abstract A createActivation(Document var1, NodeActivation.Key var2);

    public abstract void propagateAddedActivation(Document var1, A var2);

    public abstract boolean isAllowedOption(int var1, InterprNode var2, NodeActivation<?> var3, long var4);

    public abstract double computeSynapseWeightSum(Integer var1, INeuron var2);

    abstract void apply(Document var1, A var2);

    public abstract void discover(Document var1, NodeActivation<T> var2, Document.DiscoveryConfig var3);

    abstract Collection<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement var1);

    abstract boolean contains(AndNode.Refinement var1);

    public abstract void cleanup();

    public abstract String logicToString();

    protected Node() {
    }

    public Node(Model m, int level) {
        this.threads = new ThreadState[m.numberOfThreads];
        this.provider = new Provider<Node>(m, this);
        this.level = level;
        this.provider.setModified();
        if (m.nodeStatisticFactory != null) {
            this.statistic = m.nodeStatisticFactory.createNodeStatisticObject();
        }
    }

    void addOrChild(OrNode.OrEntry oe, boolean all) {
        this.lock.acquireWriteLock();
        if (all) {
            if (this.allOrChildren == null) {
                this.allOrChildren = new TreeSet();
            }
            this.allOrChildren.add(oe);
        } else {
            if (this.orChildren == null) {
                this.orChildren = new TreeSet();
            }
            this.orChildren.add(oe);
        }
        this.lock.releaseWriteLock();
    }

    void removeOrChild(OrNode.OrEntry oe, boolean all) {
        this.lock.acquireWriteLock();
        if (all) {
            if (this.allOrChildren != null) {
                this.allOrChildren.remove(oe);
                if (this.allOrChildren.isEmpty()) {
                    this.allOrChildren = null;
                }
            }
        } else if (this.orChildren != null) {
            this.orChildren.remove(oe);
            if (this.orChildren.isEmpty()) {
                this.orChildren = null;
            }
        }
        this.lock.releaseWriteLock();
    }

    void addAndChild(AndNode.Refinement ref, Provider<AndNode> child) {
        if (this.andChildren == null) {
            this.andChildren = new TreeMap();
            this.reverseAndChildren = new TreeMap();
        }
        Provider<AndNode> n = this.andChildren.put(ref, child);
        assert (n == null);
        this.reverseAndChildren.put(new ReverseAndRefinement(child, ref.rid, 0), ref);
    }

    void removeAndChild(AndNode.Refinement ref) {
        if (this.andChildren != null) {
            Provider<AndNode> child = this.andChildren.remove(ref);
            this.reverseAndChildren.remove(new ReverseAndRefinement(child, ref.rid, 0));
            if (this.andChildren.isEmpty()) {
                this.andChildren = null;
                this.reverseAndChildren = null;
            }
        }
    }

    A processAddedActivation(Document doc, NodeActivation.Key<T> ak, Collection<NodeActivation> inputActs) {
        Object act;
        if (Document.APPLY_DEBUG_OUTPUT) {
            log.info("add: " + ak + " - " + ak.n);
        }
        if ((act = NodeActivation.get(doc, this, ak)) == null) {
            act = this.createActivation(doc, ak);
            this.register(act, doc);
            ((NodeActivation)act).link(inputActs);
            this.propagateAddedActivation(doc, act);
        } else {
            ((NodeActivation)act).link(inputActs);
        }
        return act;
    }

    public void register(A act, Document doc) {
        TreeMap actRid;
        NodeActivation.Key ak = ((NodeActivation)act).key;
        ThreadState<T, A> th = ((Node)ak.n).getThreadState(doc.threadId, true);
        if (th.activations.isEmpty()) {
            doc.activatedNodes.add((Node)ak.n);
        }
        th.activations.put(ak, act);
        TreeMap actEnd = th.activationsEnd;
        if (actEnd != null) {
            actEnd.put(ak, act);
        }
        if ((actRid = th.activationsRid) != null) {
            actRid.put(ak, act);
        }
        if (ak.o.activations == null) {
            ak.o.activations = new TreeMap<NodeActivation.Key, NodeActivation>();
        }
        ak.o.activations.put(ak, (NodeActivation)act);
        ((Node)ak.n).lastUsedDocumentId = doc.id;
        if (ak.rid != null) {
            doc.activationsByRid.put(ak, (NodeActivation)act);
        }
    }

    public void processChanges(Document doc) {
        ThreadState<T, A> th = this.getThreadState(doc.threadId, true);
        NavigableMap<NodeActivation.Key, Set<NodeActivation<?>>> tmpAdded = th.added;
        th.added = new TreeMap();
        for (Map.Entry me : tmpAdded.entrySet()) {
            this.processAddedActivation(doc, (NodeActivation.Key)me.getKey(), (Collection)me.getValue());
        }
    }

    public static <T extends Node, A extends NodeActivation<T>> void addActivationAndPropagate(Document doc, NodeActivation.Key<T> ak, Collection<NodeActivation<?>> inputActs) {
        ThreadState<T, A> th = ((Node)ak.n).getThreadState(doc.threadId, true);
        TreeSet iActs = (TreeSet)th.added.get(ak);
        if (iActs == null) {
            iActs = new TreeSet();
            th.added.put(ak, iActs);
        }
        iActs.addAll(inputActs);
        doc.queue.add((Node)ak.n);
    }

    public Collection<A> getActivations(Document doc) {
        ThreadState<T, A> th = this.getThreadState(doc.threadId, false);
        if (th == null) {
            return Collections.EMPTY_LIST;
        }
        return th.activations.values();
    }

    public synchronized A getFirstActivation(Document doc) {
        ThreadState<T, A> th = this.getThreadState(doc.threadId, false);
        if (th == null || th.activations.isEmpty()) {
            return null;
        }
        return (A)((NodeActivation)th.activations.firstEntry().getValue());
    }

    public void clearActivations(Document doc) {
        this.clearActivations(doc.threadId);
    }

    public void clearActivations(int threadId) {
        ThreadState<T, A> th = this.getThreadState(threadId, false);
        if (th == null) {
            return;
        }
        th.activations.clear();
        if (th.activationsEnd != null) {
            th.activationsEnd.clear();
        }
        if (th.activationsRid != null) {
            th.activationsRid.clear();
        }
        th.added.clear();
    }

    public void clearActivations() {
        for (int i = 0; i < this.provider.m.numberOfThreads; ++i) {
            this.clearActivations(i);
        }
    }

    boolean computeAndParents(Model m, int threadId, Integer offset, SortedSet<AndNode.Refinement> inputs, Map<AndNode.Refinement, Provider<? extends Node>> parents, Document.DiscoveryConfig discoveryConfig, long v) throws ThreadState.RidOutOfRange {
        RidVisited nv = this.getThreadState(threadId, true).lookupVisited(offset);
        if (nv.computeParents == v) {
            return true;
        }
        nv.computeParents = v;
        if (inputs.size() == 1) {
            parents.put(inputs.first(), this.provider);
            return true;
        }
        for (AndNode.Refinement ref : inputs) {
            TreeSet<AndNode.Refinement> childInputs = new TreeSet<AndNode.Refinement>(inputs);
            childInputs.remove(ref);
            AndNode.Refinement nRef = new AndNode.Refinement(ref.getRelativePosition(), offset, ref.input);
            this.lock.acquireReadLock();
            Provider cp = this.andChildren != null ? this.andChildren.get(nRef) : null;
            this.lock.releaseReadLock();
            if (cp == null) {
                if (discoveryConfig != null) {
                    return false;
                }
                cp = AndNode.createNextLevelNode((Model)m, (int)threadId, (Node)this, (AndNode.Refinement)nRef, (Document.DiscoveryConfig)discoveryConfig).provider;
                if (cp == null) {
                    return false;
                }
            }
            Integer nOffset = Utils.nullSafeMin(ref.getRelativePosition(), offset);
            if (cp.get().computeAndParents(m, threadId, nOffset, childInputs, parents, discoveryConfig, v)) continue;
            return false;
        }
        return true;
    }

    public void remove() {
        assert (!this.isRemoved);
        this.lock.acquireWriteLock();
        this.provider.setModified();
        while (this.andChildren != null && !this.andChildren.isEmpty()) {
            this.andChildren.firstEntry().getValue().get().remove();
        }
        while (this.orChildren != null && !this.orChildren.isEmpty()) {
            this.orChildren.pollFirst().node.get().remove();
        }
        this.lock.releaseWriteLock();
        this.clearActivations();
        this.isRemoved = true;
    }

    Provider<AndNode> getAndChild(AndNode.Refinement ref) {
        this.lock.acquireReadLock();
        Provider<AndNode> result = this.andChildren != null ? this.andChildren.get(ref) : null;
        this.lock.releaseReadLock();
        return result;
    }

    public boolean isRequired() {
        return this.numberOfNeuronRefs.get() > 0 || this.isDiscovered;
    }

    public void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        ThreadState<T, A> th = this.getThreadState(threadId, true);
        if (th.visited == v) {
            return;
        }
        th.visited = v;
        this.numberOfNeuronRefs.addAndGet(d);
    }

    public String getNeuronLabel() {
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getNeuronLabel());
        sb.append(" - ");
        sb.append(this.logicToString());
        sb.append(" - ");
        sb.append(this.weightsToString());
        return sb.toString();
    }

    public String weightsToString() {
        return "";
    }

    @Override
    public int compareTo(Node n) {
        if (this == n) {
            return 0;
        }
        if (this == MIN_NODE) {
            return -1;
        }
        if (n == MIN_NODE) {
            return 1;
        }
        if (this == MAX_NODE) {
            return 1;
        }
        if (n == MAX_NODE) {
            return -1;
        }
        return this.provider.compareTo(n.provider);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.level);
        out.writeBoolean(this.statistic != null);
        if (this.statistic != null) {
            this.statistic.write(out);
        }
        out.writeBoolean(this.isDiscovered);
        out.writeBoolean(this.endRequired);
        out.writeBoolean(this.ridRequired);
        out.writeInt(this.numberOfNeuronRefs.get());
        if (this.andChildren != null) {
            out.writeInt(this.andChildren.size());
            for (Map.Entry<AndNode.Refinement, Provider<AndNode>> me : this.andChildren.entrySet()) {
                me.getKey().write(out);
                out.writeInt(me.getValue().id);
            }
        } else {
            out.writeInt(0);
        }
        if (this.orChildren != null) {
            out.writeInt(this.orChildren.size());
            for (OrNode.OrEntry oe : this.orChildren) {
                oe.write(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        int i;
        this.level = in.readInt();
        if (in.readBoolean() && m.nodeStatisticFactory != null) {
            this.statistic = m.nodeStatisticFactory.createNodeStatisticObject();
            this.statistic.readFields(in, m);
        }
        this.isDiscovered = in.readBoolean();
        this.endRequired = in.readBoolean();
        this.ridRequired = in.readBoolean();
        this.numberOfNeuronRefs.set(in.readInt());
        int s = in.readInt();
        for (i = 0; i < s; ++i) {
            this.addAndChild(AndNode.Refinement.read(in, m), (Provider<AndNode>)m.lookupNodeProvider(in.readInt()));
        }
        s = in.readInt();
        for (i = 0; i < s; ++i) {
            if (this.orChildren == null) {
                this.orChildren = new TreeSet();
            }
            this.orChildren.add(OrNode.OrEntry.read(in, m));
        }
        this.threads = new ThreadState[m.numberOfThreads];
    }

    public static Node readNode(DataInput in, Provider p) throws IOException {
        char type = in.readChar();
        Node n = null;
        switch (type) {
            case 'I': {
                n = new InputNode();
                break;
            }
            case 'A': {
                n = new AndNode();
                break;
            }
            case 'O': {
                n = new OrNode();
            }
        }
        n.provider = p;
        n.readFields(in, p.m);
        return n;
    }

    static class ReverseAndRefinement
    implements Comparable<ReverseAndRefinement> {
        boolean dir;
        Provider node;

        public ReverseAndRefinement(Provider n, Integer a, Integer b) {
            this.node = n;
            this.dir = Utils.compareNullSafe(a, b);
        }

        @Override
        public int compareTo(ReverseAndRefinement rar) {
            int r = this.node.compareTo(rar.node);
            if (r != 0) {
                return r;
            }
            return Boolean.compare(this.dir, rar.dir);
        }
    }

    public static class RidVisited {
        public long computeParents = -1L;
        public long outputNode = -1L;
    }

    public static class ThreadState<T extends Node, A extends NodeActivation<T>> {
        public long lastUsed;
        public TreeMap<NodeActivation.Key, A> activations;
        public TreeMap<NodeActivation.Key, A> activationsEnd;
        public TreeMap<NodeActivation.Key, A> activationsRid;
        public NavigableMap<NodeActivation.Key, Set<NodeActivation<?>>> added;
        public long visited;
        public boolean isQueued = false;
        public long queueId;
        private RidVisited nullRidVisited;
        private RidVisited[] ridVisited = new RidVisited[2 * MAX_RELATIVE_RID];

        public ThreadState(boolean endRequired, boolean ridRequired) {
            this.activations = new TreeMap(BEGIN_COMP);
            this.activationsEnd = endRequired ? new TreeMap(END_COMP) : null;
            this.activationsRid = ridRequired ? new TreeMap(RID_COMP) : null;
            this.added = new TreeMap();
        }

        public RidVisited lookupVisited(Integer offset) throws RidOutOfRange {
            if (offset != null && (offset >= MAX_RELATIVE_RID || offset <= -MAX_RELATIVE_RID)) {
                log.warn("RID too large:" + offset);
                throw new RidOutOfRange("RID too large:" + offset);
            }
            if (offset == null) {
                if (this.nullRidVisited == null) {
                    this.nullRidVisited = new RidVisited();
                }
                return this.nullRidVisited;
            }
            RidVisited v = this.ridVisited[offset + MAX_RELATIVE_RID];
            if (v == null) {
                this.ridVisited[offset.intValue() + Node.MAX_RELATIVE_RID] = v = new RidVisited();
            }
            return v;
        }

        public static class RidOutOfRange
        extends Exception {
            public RidOutOfRange(String s) {
                super(s);
            }
        }
    }
}

