/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aika.Model;
import org.aika.Neuron;
import org.aika.Provider;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;

public class OrNode
extends Node<OrNode, Activation> {
    public TreeMap<Integer, TreeSet<Provider<Node>>> parents = new TreeMap();
    public TreeMap<Integer, TreeSet<Provider<Node>>> allParents = new TreeMap();
    public Neuron neuron = null;
    public Node requiredNode;

    public OrNode() {
    }

    public OrNode(Model m) {
        super(m, -1);
        this.endRequired = true;
        this.ridRequired = true;
    }

    @Override
    public boolean isAllowedOption(int threadId, InterprNode n, NodeActivation act, long v) {
        return false;
    }

    @Override
    protected Activation createActivation(Document doc, NodeActivation.Key ak) {
        Activation act;
        ak.o.act = act = new Activation(doc.activationIdCounter++, doc, ak);
        Node.ThreadState th = this.getThreadState(doc.threadId, false);
        if (th == null || th.activations.isEmpty()) {
            doc.activatedNeurons.add((INeuron)this.neuron.get());
        }
        return act;
    }

    private void retrieveInputs(Document doc, Range inputR, Integer rid, List<NodeActivation<?>> inputs, Integer pRidOffset, TreeSet<Provider<Node>> parents) {
        if (parents.size() > 10) {
            this.retrieveInputs(doc, null, inputR, rid, inputs, pRidOffset, parents);
        } else {
            for (Provider<Node> pn : parents) {
                this.retrieveInputs(doc, pn.get(), inputR, rid, inputs, pRidOffset, parents);
            }
        }
    }

    private void retrieveInputs(Document doc, Node<?, NodeActivation<?>> n, Range inputR, Integer rid, List<NodeActivation<?>> inputs, Integer pRidOffset, TreeSet<Provider<Node>> parents) {
        Stream<NodeActivation<Object>> s = n != null ? NodeActivation.select(doc, n, Utils.nullSafeAdd(rid, true, pRidOffset, false), inputR, Range.Operator.EQUALS, Range.Operator.EQUALS, null, null) : NodeActivation.select(doc, Utils.nullSafeAdd(rid, true, pRidOffset, false), inputR, Range.Operator.EQUALS, Range.Operator.EQUALS, null, null);
        for (NodeActivation iAct : s.collect(Collectors.toList())) {
            if (!parents.contains(((Node)iAct.key.n).provider) || this.checkSelfReferencing(doc, iAct)) continue;
            inputs.add(iAct);
        }
    }

    @Override
    Activation processAddedActivation(Document doc, NodeActivation.Key<OrNode> ak, Collection<NodeActivation> inputActs) {
        Activation act = (Activation)super.processAddedActivation(doc, ak, inputActs);
        if (act != null) {
            ((INeuron)this.neuron.get()).linkNeuronRelations(doc, act);
        }
        return act;
    }

    public void addActivation(Document doc, Integer ridOffset, NodeActivation inputAct) {
        if (this.checkSelfReferencing(doc, inputAct)) {
            return;
        }
        NodeActivation.Key ak = inputAct.key;
        Range r = ak.r;
        Integer rid = Utils.nullSafeSub(ak.rid, true, ridOffset, false);
        ArrayList inputs = new ArrayList();
        for (Map.Entry<Integer, TreeSet<Provider<Node>>> me : this.parents.entrySet()) {
            this.retrieveInputs(doc, r, rid, inputs, me.getKey() != Integer.MIN_VALUE ? (Integer)me.getKey() : null, (TreeSet)me.getValue());
        }
        if (inputs.isEmpty()) {
            return;
        }
        InterprNode no = this.lookupOrOption(doc, r, true);
        for (NodeActivation nodeActivation : inputs) {
            no.addOrInterpretationNode(nodeActivation.key.o);
        }
        if (((INeuron)this.neuron.get()).outputText != null) {
            int begin = r.begin != Integer.MIN_VALUE ? r.begin : 0;
            int n = r.end != Integer.MAX_VALUE ? r.end : begin + ((INeuron)this.neuron.get()).outputText.length();
            r = new Range(begin, n);
        }
        if (r.begin == Integer.MIN_VALUE || r.end == Integer.MAX_VALUE) {
            return;
        }
        NodeActivation.Key<OrNode> nak = new NodeActivation.Key<OrNode>(this, r, rid, no);
        OrNode.addActivationAndPropagate(doc, nak, inputs);
    }

    private boolean checkSelfReferencing(Document doc, NodeActivation inputAct) {
        InterprNode o = this.lookupOrOption(doc, inputAct.key.r, false);
        if (o == null) {
            return false;
        }
        return inputAct.key.o.contains(o, true);
    }

    @Override
    public void propagateAddedActivation(Document doc, Activation act) {
        ((INeuron)this.neuron.get()).propagateAddedActivation(doc, act);
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, INeuron n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void apply(Document doc, Activation act) {
        OrNode.processCandidate(doc, this, act, false);
    }

    @Override
    public void discover(Document doc, NodeActivation act, Document.DiscoveryConfig discoveryConfig) {
    }

    public static void processCandidate(Document doc, Node<?, ? extends NodeActivation<?>> parentNode, NodeActivation inputAct, boolean train) {
        NodeActivation.Key ak = inputAct.key;
        parentNode.lock.acquireReadLock();
        if (parentNode.orChildren != null) {
            for (OrEntry oe : parentNode.orChildren) {
                if (ak.o.isConflicting(doc.visitedCounter++)) continue;
                oe.node.get().addActivation(doc, oe.ridOffset, inputAct);
            }
        }
        parentNode.lock.releaseReadLock();
    }

    public InterprNode lookupOrOption(Document doc, Range r, boolean create) {
        NodeActivation act = NodeActivation.select(doc, this, null, r, Range.Operator.EQUALS, Range.Operator.EQUALS, null, null).findFirst().orElse(null);
        if (act != null) {
            return act.key.o;
        }
        Node.ThreadState th = this.getThreadState(doc.threadId, false);
        if (th != null) {
            for (NodeActivation.Key ak : th.added.keySet()) {
                if (Range.compare(ak.r, r) != 0) continue;
                return ak.o;
            }
        }
        return create ? InterprNode.addPrimitive(doc) : null;
    }

    Set<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
        throw new UnsupportedOperationException();
    }

    public void addInput(Integer ridOffset, int threadId, Node in, boolean all) {
        Model cfr_ignored_0 = this.provider.m;
        in.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), 1);
        in.lock.acquireWriteLock();
        in.addOrChild(new OrEntry(ridOffset, this.provider), all);
        in.provider.setModified();
        in.lock.releaseWriteLock();
        this.lock.acquireWriteLock();
        this.provider.setModified();
        Integer key = ridOffset != null ? ridOffset : Integer.MIN_VALUE;
        TreeMap<Integer, TreeSet<Provider<Node>>> p = all ? this.allParents : this.parents;
        TreeSet pn = p.get(key);
        if (pn == null) {
            pn = new TreeSet();
            p.put(key, pn);
        }
        pn.add(in.provider);
        this.lock.releaseWriteLock();
    }

    public boolean hasParent(Integer ridOffset, Node in, boolean all) {
        this.lock.acquireReadLock();
        TreeMap<Integer, TreeSet<Provider<Node>>> p = all ? this.allParents : this.parents;
        Integer key = ridOffset != null ? ridOffset : Integer.MIN_VALUE;
        TreeSet<Provider<Node>> pn = p.get(key);
        boolean result = pn != null && pn.contains(in.provider);
        this.lock.releaseReadLock();
        return result;
    }

    public void removeInput(Integer ridOffset, int threadId, Node in, boolean all) {
        Model cfr_ignored_0 = this.provider.m;
        in.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), -1);
        in.removeOrChild(new OrEntry(ridOffset, this.provider), all);
        in.provider.setModified();
        this.lock.acquireWriteLock();
        this.provider.setModified();
        Integer key = ridOffset != null ? ridOffset : Integer.MIN_VALUE;
        TreeMap<Integer, TreeSet<Provider<Node>>> p = all ? this.allParents : this.parents;
        TreeSet<Provider<Node>> pn = p.get(key);
        if (pn != null) {
            pn.remove(in.provider);
            if (pn.isEmpty() && ridOffset != null) {
                p.remove(key);
            }
        }
        this.lock.releaseWriteLock();
    }

    void remove(int threadId) {
        ((INeuron)this.neuron.get()).remove();
        super.remove();
        this.lock.acquireReadLock();
        this.removeParents(threadId, true);
        this.removeParents(threadId, false);
        this.lock.releaseReadLock();
    }

    public void removeParents(int threadId, boolean all) {
        for (Map.Entry<Integer, TreeSet<Provider<Node>>> me : (all ? this.allParents : this.parents).entrySet()) {
            for (Provider<Node> p : me.getValue()) {
                Node pn = p.get();
                Model cfr_ignored_0 = this.provider.m;
                pn.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), -1);
                pn.removeOrChild(new OrEntry(me.getKey() != Integer.MIN_VALUE ? me.getKey() : null, this.provider), all);
                pn.provider.setModified();
            }
        }
        (all ? this.allParents : this.parents).clear();
    }

    @Override
    public void register(Activation act, Document doc) {
        super.register(act, doc);
        NodeActivation.Key ak = act.key;
        if (ak.o.neuronActivations == null) {
            ak.o.neuronActivations = new TreeSet<Activation>();
        }
        ak.o.neuronActivations.add(act);
        ((INeuron)this.neuron.get()).lastUsedDocumentId = doc.id;
    }

    @Override
    boolean contains(AndNode.Refinement ref) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR[");
        boolean first = true;
        int i = 0;
        block0: for (Map.Entry<Integer, TreeSet<Provider<Node>>> me : this.parents.entrySet()) {
            for (Provider<Node> pn : me.getValue()) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(me.getKey() != Integer.MIN_VALUE ? me.getKey() : "X");
                sb.append(":");
                sb.append(pn.get().logicToString());
                if (i > 2) {
                    sb.append(",...");
                    continue block0;
                }
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(79);
        super.write(out);
        out.writeInt(this.neuron.id);
        out.writeInt(this.parents.size());
        for (Map.Entry<Integer, TreeSet<Provider<Node>>> me : this.parents.entrySet()) {
            out.writeInt(me.getKey());
            out.writeInt(me.getValue().size());
            for (Provider<Node> pn : me.getValue()) {
                out.writeInt(pn.id);
            }
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        this.neuron = m.lookupNeuron(in.readInt());
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            TreeSet ridParents = new TreeSet();
            Integer ridOffset = in.readInt();
            this.parents.put(ridOffset, ridParents);
            int sa = in.readInt();
            for (int j = 0; j < sa; ++j) {
                ridParents.add(m.lookupNodeProvider(in.readInt()));
            }
        }
    }

    @Override
    public String getNeuronLabel() {
        String l = ((INeuron)this.neuron.get()).label;
        return l != null ? l : "";
    }

    static class OrEntry
    implements Comparable<OrEntry>,
    Writable {
        public Integer ridOffset;
        public Provider<OrNode> node;

        private OrEntry() {
        }

        public OrEntry(Integer ridOffset, Provider<OrNode> node) {
            this.ridOffset = ridOffset;
            this.node = node;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.ridOffset != null);
            if (this.ridOffset != null) {
                out.writeInt(this.ridOffset);
            }
            out.writeInt(this.node.id);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            if (in.readBoolean()) {
                this.ridOffset = in.readInt();
            }
            this.node = m.lookupNodeProvider(in.readInt());
        }

        public static OrEntry read(DataInput in, Model m) throws IOException {
            OrEntry n = new OrEntry();
            n.readFields(in, m);
            return n;
        }

        @Override
        public int compareTo(OrEntry on) {
            int r = Utils.compareInteger(this.ridOffset, on.ridOffset);
            if (r != 0) {
                return r;
            }
            return this.node.compareTo(on.node);
        }
    }
}

