/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.util.Collection;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.aika.Model;
import org.aika.Provider;
import org.aika.ReadWriteLock;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.lattice.InputNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;

public class Neuron
extends Provider<INeuron> {
    public ReadWriteLock lock = new ReadWriteLock();
    public NavigableMap<Synapse, Synapse> inMemoryInputSynapses = new TreeMap<Synapse, Synapse>(Synapse.INPUT_SYNAPSE_COMP);
    public NavigableMap<Synapse, Synapse> inMemoryOutputSynapses = new TreeMap<Synapse, Synapse>(Synapse.OUTPUT_SYNAPSE_COMP);

    public Neuron(Model m, int id) {
        super(m, id);
    }

    public Neuron(Model m, INeuron n) {
        super(m, n);
    }

    public Activation addInput(Document doc, int begin, int end) {
        return this.addInput(doc, begin, end, null, doc.bottom);
    }

    public Activation addInput(Document doc, int begin, int end, double value, Double targetValue) {
        return this.addInput(doc, begin, end, null, doc.bottom, value, targetValue);
    }

    public Activation addInput(Document doc, int begin, int end, InterprNode o) {
        return this.addInput(doc, begin, end, null, o);
    }

    public Activation addInput(Document doc, int begin, int end, Integer rid) {
        return this.addInput(doc, begin, end, rid, doc.bottom);
    }

    public Activation addInput(Document doc, int begin, int end, Integer rid, InterprNode o) {
        return this.addInput(doc, begin, end, rid, o, 1.0);
    }

    public Activation addInput(Document doc, int begin, int end, Integer rid, InterprNode o, double value) {
        return this.addInput(doc, begin, end, rid, o, value, null);
    }

    public Activation addInput(Document doc, int begin, int end, Integer rid, InterprNode o, double value, Double targetValue) {
        return ((INeuron)this.get(doc)).addInput(doc, begin, end, rid, o, value, targetValue);
    }

    public Collection<Activation> getFinalActivations(Document doc) {
        INeuron n = (INeuron)this.getIfNotSuspended();
        if (n == null) {
            return Collections.emptyList();
        }
        return n.getFinalActivations(doc);
    }

    public void addInMemoryInputSynapse(Synapse s) {
        InputNode iNode;
        this.lock.acquireWriteLock();
        this.inMemoryInputSynapses.put(s, s);
        this.lock.releaseWriteLock();
        if (!s.input.isSuspended() && (iNode = s.inputNode.get()) != null) {
            iNode.setSynapse(s);
        }
    }

    public void removeInMemoryInputSynapse(Synapse s) {
        InputNode iNode;
        this.lock.acquireWriteLock();
        this.inMemoryInputSynapses.remove(s);
        this.lock.releaseWriteLock();
        if (!s.input.isSuspended() && (iNode = s.inputNode.getIfNotSuspended()) != null) {
            iNode.removeSynapse(s);
        }
    }

    public void addInMemoryOutputSynapse(Synapse s) {
        InputNode iNode;
        this.lock.acquireWriteLock();
        this.inMemoryOutputSynapses.put(s, s);
        this.lock.releaseWriteLock();
        if (!s.output.isSuspended() && (iNode = s.inputNode.get()) != null) {
            iNode.setSynapse(s);
        }
    }

    public void removeInMemoryOutputSynapse(Synapse s) {
        InputNode iNode;
        this.lock.acquireWriteLock();
        this.inMemoryOutputSynapses.remove(s);
        this.lock.releaseWriteLock();
        if (!s.output.isSuspended() && (iNode = s.inputNode.getIfNotSuspended()) != null) {
            iNode.setSynapse(s);
        }
    }
}

