/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.util.Collection;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.aika.Utils;
import org.aika.corpus.Document;
import org.aika.corpus.InterprNode;
import org.aika.corpus.Range;
import org.aika.lattice.Node;

public class NodeActivation<T extends Node>
implements Comparable<NodeActivation> {
    public final int id;
    public final Key<T> key;
    public final Document doc;
    public long visitedNeuronTrain = -1L;
    public TreeMap<Key, NodeActivation> inputs = new TreeMap();
    public TreeMap<Key, NodeActivation> outputs = new TreeMap();

    public NodeActivation(int id, Document doc, Key<T> key) {
        this.id = id;
        this.doc = doc;
        this.key = key;
    }

    public NodeActivation(int id, Document doc, T n, Range pos, Integer rid, InterprNode o) {
        this.id = id;
        this.doc = doc;
        this.key = new Key<T>(n, pos, rid, o);
    }

    public void link(Collection<NodeActivation> inputActs) {
        for (NodeActivation iAct : inputActs) {
            this.inputs.put(iAct.key, iAct);
            iAct.outputs.put(this.key, this);
        }
    }

    public static <T extends Node, A extends NodeActivation<T>> A get(Document doc, T n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        Stream<A> s = NodeActivation.select(doc, n, rid, r, begin, end, o, or);
        return (A)((NodeActivation)s.findFirst().orElse(null));
    }

    public static <T extends Node, A extends NodeActivation<T>> A get(Document doc, T n, Key ak) {
        return NodeActivation.get(doc, n, ak.rid, ak.range, Range.Operator.EQUALS, Range.Operator.EQUALS, ak.interpretation, InterprNode.Relation.EQUALS);
    }

    public static Stream<NodeActivation> select(Document doc, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        Stream<Object> results;
        if (rid != null) {
            Key<Node> bk = new Key<Node>(Node.MIN_NODE, Range.MIN, rid, InterprNode.MIN);
            Key<Node> ek = new Key<Node>(Node.MAX_NODE, Range.MAX, rid, InterprNode.MAX);
            results = doc.activationsByRid.subMap(bk, true, ek, true).values().stream();
        } else {
            results = doc.activatedNodes.stream().flatMap(node -> NodeActivation.getActivationsStream(node, doc));
        }
        return results.filter(act -> act.filter(null, rid, r, begin, end, o, or));
    }

    public static <T extends Node, A extends NodeActivation<T>> Stream<A> select(Document doc, T n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        Node.ThreadState th = n.getThreadState(doc.threadId, false);
        if (th == null) {
            return Stream.empty();
        }
        return NodeActivation.select(th, n, rid, r, begin, end, o, or);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Node, A extends NodeActivation<T>> Stream<A> select(Node.ThreadState<T, A> th, T n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        void var8_12;
        int s = th.activations.size();
        if (s == 0) {
            return Stream.empty();
        }
        if (s == 1) {
            Stream stream = th.activations.values().stream();
            return var8_12.filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else if (rid != null) {
            Key<T> bk = new Key<T>(n, Range.MIN, rid, InterprNode.MIN);
            Key<T> ek = new Key<T>(n, Range.MAX, rid, InterprNode.MAX);
            if (th.activationsRid == null) return Stream.empty();
            Stream stream = th.activationsRid.subMap(bk, true, ek, true).values().stream();
            return var8_12.filter(act -> act.filter(n, rid, r, begin, end, o, or));
        } else {
            if (begin != null || end != null) return NodeActivation.getActivationsByRange(th, n, rid, r, begin, end, o, or);
            Stream stream = th.activations.values().stream();
        }
        return var8_12.filter(act -> act.filter(n, rid, r, begin, end, o, or));
    }

    public static <T extends Node, A extends NodeActivation<T>> Stream<A> getActivationsByRange(Node.ThreadState<T, A> th, T n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        Collection<Object> s;
        if ((begin == Range.Operator.GREATER_THAN_EQUAL || begin == Range.Operator.EQUALS) && r.begin != Integer.MIN_VALUE && r.begin <= r.end) {
            int er = (end == Range.Operator.LESS_THAN_EQUAL || end == Range.Operator.EQUALS) && r.end != Integer.MAX_VALUE ? r.end : Integer.MAX_VALUE;
            s = th.activations.subMap(new Key<T>(n, new Range(r.begin, Integer.MIN_VALUE), null, InterprNode.MIN), true, new Key<T>(n, new Range(er, Integer.MAX_VALUE), Integer.MAX_VALUE, InterprNode.MAX), true).values();
        } else {
            s = (begin == Range.Operator.LESS_THAN_EQUAL || begin == Range.Operator.EQUALS) && r.begin != Integer.MIN_VALUE && r.begin <= r.end ? th.activations.descendingMap().subMap(new Key<T>(n, new Range(r.begin, Integer.MAX_VALUE), null, InterprNode.MAX), true, new Key<T>(n, new Range(Integer.MIN_VALUE, Integer.MIN_VALUE), null, InterprNode.MIN), true).values() : th.activations.values();
        }
        return s.stream().filter(act -> act.filter(n, rid, r, begin, end, o, or));
    }

    private static <T extends Node, A extends NodeActivation<T>> Stream<A> getActivationsStream(T n, Document doc) {
        Node.ThreadState th = n.getThreadState(doc.threadId, false);
        return th == null ? Stream.empty() : th.activations.values().stream();
    }

    public <T extends Node> boolean filter(T n, Integer rid, Range r, Range.Operator begin, Range.Operator end, InterprNode o, InterprNode.Relation or) {
        return !(n != null && this.key.node != n || rid != null && (this.key.rid == null || this.key.rid.intValue() != rid.intValue()) || r != null && (begin != null && !begin.compare(this.key.range.begin, r.begin) || end != null && !end.compare(this.key.range.end, r.end)) || o != null && !or.compare(this.key.interpretation, o));
    }

    public String toString(Document doc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ACT ");
        sb.append(",(");
        sb.append(this.key.range);
        sb.append("),");
        sb.append(doc.getContent().substring(Math.max(0, this.key.range.begin - 3), Math.min(doc.length(), this.key.range.end + 3)));
        sb.append(",");
        sb.append(this.key.node);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(NodeActivation act) {
        return this.key.compareTo(act.key);
    }

    public static int compare(NodeActivation a, NodeActivation b) {
        if (a == b) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static final class Key<T extends Node>
    implements Comparable<Key> {
        public final T node;
        public final Range range;
        public final Integer rid;
        public final InterprNode interpretation;

        public Key(T node, Range range, Integer rid, InterprNode interpretation) {
            this.node = node;
            this.range = range;
            this.rid = rid;
            this.interpretation = interpretation;
        }

        @Override
        public int compareTo(Key k) {
            int x = ((Node)this.node).compareTo((Node)k.node);
            if (x != 0) {
                return x;
            }
            x = Range.compare(this.range, k.range, false);
            if (x != 0) {
                return x;
            }
            x = Utils.compareInteger(this.rid, k.rid);
            if (x != 0) {
                return x;
            }
            return this.interpretation.compareTo(k.interpretation);
        }

        public String toString() {
            return (this.node != null ? ((Node)this.node).getNeuronLabel() : "") + this.range + " " + this.rid + " " + this.interpretation;
        }
    }
}

