/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import org.aika.Utils;
import org.aika.corpus.InterpretationNode;
import org.aika.corpus.SearchNode;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;

public class Candidate
implements Comparable<Candidate> {
    public Boolean cachedDecision;
    public Boolean cachedSNDecision;
    public SearchNode cachedSearchNode;
    public InterpretationNode refinement;
    int[] debugCounts = new int[3];
    int[] debugDecisionCounts = new int[3];
    int[] debugComputed = new int[2];
    int id;
    int sequence = 0;
    int minBegin;
    int maxEnd;
    Integer minRid;

    public Candidate(InterpretationNode ref, int id) {
        this.refinement = ref;
        this.id = id;
        ref.candidate = this;
        if (ref.activation != null) {
            this.sequence = ref.activation.getSequence();
            this.minBegin = ref.activation.key.range.begin;
            this.maxEnd = ref.activation.key.range.end;
            this.minRid = ref.activation.key.rid;
        } else {
            for (NodeActivation act : ref.getActivations()) {
                this.sequence = Math.max(this.sequence, ref.activation.getSequence());
                if (act.key.range != null) {
                    this.minBegin = Math.min(this.minBegin, act.key.range.begin);
                    this.maxEnd = Math.max(this.maxEnd, act.key.range.end);
                }
                this.minRid = Utils.nullSafeMin(this.minRid, act.key.rid);
            }
        }
    }

    public boolean isConflicting() {
        return this.refinement.conflicts.hasConflicts();
    }

    public boolean checkDependenciesSatisfied(long v) {
        for (Activation.SynapseActivation sa : this.refinement.activation.neuronInputs) {
            if (sa.input.visited == v || sa.synapse.key.isRecurrent) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return " CID:" + this.id + " CONFLICT:" + this.isConflicting() + " LIMITED:" + this.debugCounts[SearchNode.DebugState.LIMITED.ordinal()] + " CACHED:" + this.debugCounts[SearchNode.DebugState.CACHED.ordinal()] + " EXPLORE:" + this.debugCounts[SearchNode.DebugState.EXPLORE.ordinal()] + " SELECTED:" + this.debugDecisionCounts[0] + " EXCLUDED:" + this.debugDecisionCounts[1] + " SIM-CACHED:" + this.debugComputed[0] + " SIM-COMPUTED:" + this.debugComputed[1] + " " + this.refinement.activation.key.range + " " + this.refinement.activation.key.interpretation + " " + ((INeuron)((OrNode)this.refinement.activation.key.node).neuron.get()).label;
    }

    @Override
    public int compareTo(Candidate c) {
        int r = Integer.compare(this.minBegin, c.minBegin);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.maxEnd, c.maxEnd);
        if (r != 0) {
            return r;
        }
        r = Integer.compare(this.sequence, c.sequence);
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(this.minRid, c.minRid);
        if (r != 0) {
            return r;
        }
        return Integer.compare(this.id, c.id);
    }
}

