/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.aika.corpus.InterpretationNode;
import org.aika.lattice.NodeActivation;

public class Conflicts {
    public SortedMap<Key, Conflict> primary = new TreeMap<Key, Conflict>();
    public Map<Key, Conflict> secondary = new TreeMap<Key, Conflict>();

    public static void collectConflicting(Collection<InterpretationNode> results, InterpretationNode n, long v) {
        assert (n.primId >= 0);
        n.conflicts.primary.values().forEach(c -> c.secondary.collectPrimitiveNodes(results, v));
        n.conflicts.secondary.values().forEach(c -> results.add(c.primary));
    }

    public static void add(NodeActivation act, InterpretationNode primary, InterpretationNode secondary) {
        Key ck = new Key(secondary, act);
        Conflict c = (Conflict)primary.conflicts.primary.get(ck);
        if (c == null) {
            c = new Conflict(act, primary, secondary, InterpretationNode.add(primary.doc, false, primary, secondary));
            ++c.conflict.isConflict;
            primary.conflicts.primary.put(ck, c);
            secondary.conflicts.secondary.put(new Key(primary, act), c);
        }
    }

    public boolean hasConflicts() {
        return !this.primary.isEmpty() || !this.secondary.isEmpty();
    }

    public static class Key
    implements Comparable<Key> {
        public InterpretationNode o;
        public NodeActivation act;

        public Key(InterpretationNode o, NodeActivation act) {
            this.o = o;
            this.act = act;
        }

        @Override
        public int compareTo(Key k) {
            int r = this.o.compareTo(k.o);
            if (r != 0) {
                return r;
            }
            return NodeActivation.compare(this.act, k.act);
        }
    }

    public static class Conflict {
        public NodeActivation act;
        public InterpretationNode primary;
        public InterpretationNode secondary;
        public InterpretationNode conflict;

        public Conflict(NodeActivation act, InterpretationNode primary, InterpretationNode secondary, InterpretationNode conflict) {
            this.act = act;
            this.primary = primary;
            this.secondary = secondary;
            this.conflict = conflict;
        }
    }
}

