/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.aika.corpus.Candidate;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.corpus.InterpretationNode;
import org.aika.lattice.OrNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNode
implements Comparable<SearchNode> {
    private static final Logger log = LoggerFactory.getLogger(SearchNode.class);
    public static int MAX_SEARCH_STEPS = 1000000;
    public int id;
    public SearchNode excludedParent;
    public SearchNode selectedParent;
    public long visited;
    Candidate candidate;
    int level;
    DebugState debugState;
    INeuron.NormWeight weightDelta = INeuron.NormWeight.ZERO_WEIGHT;
    INeuron.NormWeight accumulatedWeight;
    public List<Activation.StateChange> modifiedActs = new ArrayList<Activation.StateChange>();
    Step step = Step.INIT;
    boolean alreadySelected;
    boolean alreadyExcluded;
    Boolean cachedDecision;
    SearchNode selectedChild = null;
    SearchNode excludedChild = null;
    INeuron.NormWeight selectedWeight = INeuron.NormWeight.ZERO_WEIGHT;
    INeuron.NormWeight excludedWeight = INeuron.NormWeight.ZERO_WEIGHT;

    public SearchNode(Document doc, SearchNode selParent, SearchNode exclParent, Candidate c, int level, Collection<InterpretationNode> changed, boolean cached) {
        this.id = doc.searchNodeIdCounter++;
        this.level = level;
        this.visited = doc.visitedCounter++;
        this.selectedParent = selParent;
        this.excludedParent = exclParent;
        SearchNode lsn = null;
        boolean modified = true;
        if (c != null) {
            this.candidate = c;
            lsn = this.candidate.cachedSearchNode;
            if (lsn != null && cached) {
                modified = lsn.checkInputActModified();
            }
        }
        boolean cachedSim = cached && !modified && lsn != null;
        this.weightDelta = doc.vQueue.adjustWeight(this, changed, cachedSim ? lsn.visited : this.visited);
        SearchNode pn = this.getParent();
        if (pn != null && pn.candidate != null) {
            int[] nArray = pn.candidate.debugComputed;
            int n = cachedSim ? 0 : 1;
            nArray[n] = nArray[n] + 1;
        }
        if (this.getParent() != null) {
            this.accumulatedWeight = this.weightDelta.add(this.getParent().accumulatedWeight);
        }
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Search Step: " + this.id + "  Candidate Weight Delta: " + this.weightDelta);
            log.info(doc.neuronActivationsToString(true, true, false) + "\n");
        }
    }

    public void collectResults(Collection<InterpretationNode> results) {
        if (this.candidate != null) {
            results.add(this.candidate.refinement);
        }
        if (this.selectedParent != null) {
            this.selectedParent.collectResults(results);
        }
    }

    public void reconstructSelectedResult(Document doc) {
        if (this.getParent() != null) {
            this.getParent().reconstructSelectedResult(doc);
        }
        this.changeState(Activation.Mode.NEW);
        SearchNode pn = this.getParent();
        if (pn != null && pn.candidate != null) {
            pn.candidate.refinement.setState(this.getDecision() ? InterpretationNode.State.SELECTED : InterpretationNode.State.EXCLUDED, this.visited);
        }
        for (Activation.StateChange sc : this.modifiedActs) {
            Activation act = sc.getActivation();
            if (!act.isFinalActivation()) continue;
            doc.finallyActivatedNeurons.add((INeuron)((OrNode)act.key.node).neuron.get(doc));
        }
    }

    public void dumpDebugState() {
        for (SearchNode n = this; n != null && n.level >= 0; n = n.getParent()) {
            System.out.println(n.level + " " + (Object)((Object)n.debugState) + " DECISION:" + n.getDecision() + " " + n.candidate != null ? n.candidate.toString() : " MOD-ACTS:" + n.modifiedActs.size());
        }
    }

    public INeuron.NormWeight searchRecursive(Document doc) {
        if (this.candidate == null) {
            return this.processResult(doc);
        }
        this.initStep(doc);
        if (this.prepareSelectStep(doc)) {
            this.selectedWeight = this.selectedChild.searchRecursive(doc);
            this.postReturn(this.selectedChild);
        }
        if (this.prepareExcludeStep(doc)) {
            this.excludedWeight = this.excludedChild.searchRecursive(doc);
            this.postReturn(this.excludedChild);
        }
        return this.finalStep();
    }

    public static void search(Document doc, SearchNode root) {
        SearchNode sn = root;
        INeuron.NormWeight returnWeight = null;
        do {
            switch (sn.step) {
                case INIT: {
                    if (sn.candidate == null) {
                        returnWeight = sn.processResult(doc);
                        sn.step = Step.FINAL;
                        sn = sn.getParent();
                        break;
                    }
                    sn.initStep(doc);
                    sn.step = Step.PREPARE_SELECT;
                    break;
                }
                case PREPARE_SELECT: {
                    sn.step = sn.prepareSelectStep(doc) ? Step.SELECT : Step.PREPARE_EXCLUDE;
                    break;
                }
                case SELECT: {
                    sn.step = Step.POST_SELECT;
                    sn = sn.selectedChild;
                    break;
                }
                case POST_SELECT: {
                    sn.selectedWeight = returnWeight;
                    sn.postReturn(sn.selectedChild);
                    sn.step = Step.PREPARE_EXCLUDE;
                    break;
                }
                case PREPARE_EXCLUDE: {
                    sn.step = sn.prepareExcludeStep(doc) ? Step.EXCLUDE : Step.FINAL;
                    break;
                }
                case EXCLUDE: {
                    sn.step = Step.POST_EXCLUDE;
                    sn = sn.excludedChild;
                    break;
                }
                case POST_EXCLUDE: {
                    sn.excludedWeight = returnWeight;
                    sn.postReturn(sn.excludedChild);
                    sn.step = Step.FINAL;
                    break;
                }
                case FINAL: {
                    returnWeight = sn.finalStep();
                    sn = sn.getParent();
                    break;
                }
            }
        } while (sn.level >= root.level);
    }

    private void initStep(Document doc) {
        boolean precondition = this.checkPrecondition();
        this.alreadySelected = precondition && !this.candidate.isConflicting();
        this.alreadyExcluded = !precondition || this.checkExcluded(this.candidate.refinement, doc.visitedCounter++);
        Boolean bl = this.cachedDecision = !this.alreadyExcluded ? this.candidate.cachedDecision : null;
        if (doc.searchStepCounter > MAX_SEARCH_STEPS) {
            this.dumpDebugState();
            throw new RuntimeException("Max search step exceeded.");
        }
        ++doc.searchStepCounter;
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Search Step: " + this.id);
            log.info(this.toString());
        }
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info(doc.neuronActivationsToString(true, true, false) + "\n");
        }
        this.debugState = this.alreadyExcluded || this.alreadySelected ? DebugState.LIMITED : (this.cachedDecision != null ? DebugState.CACHED : DebugState.EXPLORE);
        int n = this.debugState.ordinal();
        this.candidate.debugCounts[n] = this.candidate.debugCounts[n] + 1;
    }

    private boolean prepareSelectStep(Document doc) {
        if (this.alreadyExcluded || this.cachedDecision != null && !this.cachedDecision.booleanValue()) {
            return false;
        }
        this.candidate.refinement.setState(InterpretationNode.State.SELECTED, this.visited);
        if (this.candidate.cachedDecision == null) {
            this.invalidateCachedDecisions(doc.visitedCounter++);
        }
        Candidate c = doc.candidates.size() > this.level + 1 ? doc.candidates.get(this.level + 1) : null;
        this.selectedChild = new SearchNode(doc, this, this.excludedParent, c, this.level + 1, Collections.singleton(this.candidate.refinement), this.candidate.cachedSNDecision == Boolean.TRUE);
        this.candidate.debugDecisionCounts[0] = this.candidate.debugDecisionCounts[0] + 1;
        return true;
    }

    private boolean prepareExcludeStep(Document doc) {
        if (this.alreadySelected || this.cachedDecision != null && this.cachedDecision.booleanValue()) {
            return false;
        }
        this.candidate.refinement.setState(InterpretationNode.State.EXCLUDED, this.visited);
        Candidate c = doc.candidates.size() > this.level + 1 ? doc.candidates.get(this.level + 1) : null;
        this.excludedChild = new SearchNode(doc, this.selectedParent, this, c, this.level + 1, Collections.singleton(this.candidate.refinement), this.candidate.cachedSNDecision == Boolean.FALSE);
        this.candidate.debugDecisionCounts[1] = this.candidate.debugDecisionCounts[1] + 1;
        return true;
    }

    private void postReturn(SearchNode child) {
        child.changeState(Activation.Mode.OLD);
        this.candidate.refinement.setState(InterpretationNode.State.UNKNOWN, this.visited);
        this.candidate.refinement.activation.rounds.reset();
    }

    private INeuron.NormWeight finalStep() {
        INeuron.NormWeight result;
        if (this.cachedDecision == null) {
            SearchNode csn;
            boolean dir = this.selectedWeight.getNormWeight() >= this.excludedWeight.getNormWeight();
            boolean bl = dir = this.alreadySelected || !this.alreadyExcluded && dir;
            if (!this.alreadyExcluded) {
                this.candidate.cachedDecision = dir;
            }
            this.candidate.cachedSNDecision = dir;
            SearchNode searchNode = csn = dir ? this.selectedChild : this.excludedChild;
            if (csn.candidate != null) {
                csn.candidate.cachedSearchNode = csn;
            }
            result = dir ? this.selectedWeight : this.excludedWeight;
        } else {
            result = this.cachedDecision != false ? this.selectedWeight : this.excludedWeight;
        }
        this.selectedChild = null;
        this.excludedChild = null;
        return result;
    }

    private boolean checkPrecondition() {
        Set<InterpretationNode> soin = this.candidate.refinement.selectedOrInterpretationNodes;
        return soin != null && !soin.isEmpty();
    }

    private boolean checkInputActModified() {
        for (Activation.StateChange sc : this.modifiedActs) {
            if (!this.checkInputActModified(sc.getActivation())) continue;
            return true;
        }
        return false;
    }

    private boolean checkInputActModified(Activation act) {
        if (act.rounds.modified > this.visited) {
            return true;
        }
        for (Activation.SynapseActivation sa : act.neuronInputs) {
            if (sa.input.rounds.modified <= this.visited) continue;
            return true;
        }
        return false;
    }

    private void invalidateCachedDecisions(long v) {
        for (Activation act : this.candidate.refinement.neuronActivations) {
            for (Activation.SynapseActivation sa : act.neuronOutputs) {
                if (sa.synapse.isNegative()) continue;
                Candidate posCand = sa.output.key.interpretation.candidate;
                if (posCand != null && posCand.cachedDecision == Boolean.FALSE && this.candidate.id < posCand.id) {
                    posCand.cachedDecision = null;
                    posCand.cachedSNDecision = null;
                }
                ArrayList<InterpretationNode> conflicting = new ArrayList<InterpretationNode>();
                Conflicts.collectConflicting(conflicting, sa.output.key.interpretation, v);
                for (InterpretationNode c : conflicting) {
                    Candidate negCand = c.candidate;
                    if (negCand == null || negCand.cachedDecision != Boolean.TRUE || this.candidate.id >= negCand.id) continue;
                    negCand.cachedDecision = null;
                    negCand.cachedSNDecision = null;
                }
            }
        }
    }

    private INeuron.NormWeight processResult(Document doc) {
        double accNW = this.accumulatedWeight.getNormWeight();
        if (accNW > this.getSelectedAccumulatedWeight(doc)) {
            doc.selectedSearchNode = this;
        }
        return this.accumulatedWeight;
    }

    private double getSelectedAccumulatedWeight(Document doc) {
        return doc.selectedSearchNode != null ? doc.selectedSearchNode.accumulatedWeight.getNormWeight() : -1.0;
    }

    private boolean checkExcluded(InterpretationNode ref, long v) {
        ArrayList<InterpretationNode> conflicts = new ArrayList<InterpretationNode>();
        Conflicts.collectConflicting(conflicts, ref, v);
        for (InterpretationNode cn : conflicts) {
            if (cn.state != InterpretationNode.State.SELECTED) continue;
            return true;
        }
        return false;
    }

    public String pathToString(Document doc) {
        return (this.selectedParent != null ? this.selectedParent.pathToString(doc) : "") + " - " + this.toString(doc);
    }

    public String toString(Document doc) {
        TreeSet<InterpretationNode> tmp = new TreeSet<InterpretationNode>();
        this.candidate.refinement.collectPrimitiveNodes(tmp, doc.interpretationIdCounter++);
        StringBuilder sb = new StringBuilder();
        for (InterpretationNode n : tmp) {
            sb.append(n.primId);
            sb.append(", ");
        }
        return sb.toString();
    }

    public void changeState(Activation.Mode m) {
        for (Activation.StateChange sc : this.modifiedActs) {
            sc.restoreState(m);
        }
    }

    @Override
    public int compareTo(SearchNode sn) {
        return Integer.compare(this.id, sn.id);
    }

    public boolean compareNewState(SearchNode cachedNode) {
        if (this.modifiedActs == null && cachedNode.modifiedActs == null) {
            return true;
        }
        if (this.modifiedActs == null || cachedNode.modifiedActs == null) {
            return false;
        }
        if (this.modifiedActs.size() != cachedNode.modifiedActs.size()) {
            return false;
        }
        for (int i = 0; i < this.modifiedActs.size(); ++i) {
            Activation.StateChange sca = this.modifiedActs.get(i);
            Activation.StateChange scb = cachedNode.modifiedActs.get(i);
            if (sca.newRounds.compare(scb.newRounds)) continue;
            return false;
        }
        return true;
    }

    public SearchNode getParent() {
        return this.getDecision() ? this.selectedParent : this.excludedParent;
    }

    private boolean getDecision() {
        return this.excludedParent == null || this.selectedParent.id > this.excludedParent.id;
    }

    static enum Step {
        INIT,
        PREPARE_SELECT,
        SELECT,
        POST_SELECT,
        PREPARE_EXCLUDE,
        EXCLUDE,
        POST_EXCLUDE,
        FINAL;

    }

    public static enum DebugState {
        CACHED,
        LIMITED,
        EXPLORE;

    }
}

