/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.aika.Model;
import org.aika.Neuron;
import org.aika.Provider;
import org.aika.ReadWriteLock;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Document;
import org.aika.corpus.InterpretationNode;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;
import org.aika.training.PatternDiscovery;

public class InputNode
extends Node<InputNode, NodeActivation<InputNode>> {
    public Synapse.Key key;
    public Neuron inputNeuron;
    public Map<SynapseKey, Synapse> synapses;
    public ReadWriteLock synapseLock = new ReadWriteLock();
    private long visitedDiscover;

    public InputNode() {
    }

    public InputNode(Model m, Synapse.Key key) {
        super(m, 1);
        this.key = Synapse.lookupKey(key);
    }

    public static InputNode add(Model m, Synapse.Key key, INeuron input) {
        Provider<InputNode> pin;
        Provider<InputNode> provider = pin = input != null ? input.outputNodes.get(key) : null;
        if (pin != null) {
            return pin.get();
        }
        InputNode in = new InputNode(m, key);
        if (input != null && in.inputNeuron == null) {
            in.inputNeuron = (Neuron)input.provider;
            input.outputNodes.put(key, in.provider);
            input.setModified();
        }
        return in;
    }

    @Override
    protected NodeActivation<InputNode> createActivation(Document doc, NodeActivation.Key ak) {
        return new NodeActivation<InputNode>(doc.activationIdCounter++, doc, ak);
    }

    private NodeActivation.Key computeActivationKey(NodeActivation iAct) {
        NodeActivation.Key ak = iAct.key;
        if (this.key.absoluteRid != null && this.key.absoluteRid != ak.rid || ak.interpretation.isConflicting(ak.interpretation.doc.visitedCounter++)) {
            return null;
        }
        return new NodeActivation.Key<InputNode>(this, this.key.rangeOutput.map(ak.range), this.key.relativeRid != null ? ak.rid : null, ak.interpretation);
    }

    public void addActivation(Document doc, NodeActivation inputAct) {
        NodeActivation.Key ak = this.computeActivationKey(inputAct);
        if (ak != null) {
            InputNode.addActivationAndPropagate(doc, ak, Collections.singleton(inputAct));
        }
    }

    @Override
    public void propagateAddedActivation(Document doc, NodeActivation act) {
        if (!this.key.isRecurrent) {
            this.apply(doc, act);
        }
    }

    @Override
    public boolean isAllowedOption(int threadId, InterpretationNode n, NodeActivation act, long v) {
        return false;
    }

    @Override
    Collection<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
        ArrayList<AndNode.Refinement> result = new ArrayList<AndNode.Refinement>(2);
        result.add(new AndNode.Refinement(this.key.relativeRid, newRef.rid, this.provider));
        result.add(newRef);
        return result;
    }

    @Override
    void apply(Document doc, NodeActivation act) {
        this.lock.acquireReadLock();
        if (this.andChildren != null) {
            this.andChildren.forEach((ref, cn) -> {
                InputNode in = ref.input.getIfNotSuspended();
                if (in != null) {
                    InputNode.addNextLevelActivations(doc, in, ref, cn, act);
                }
            });
        }
        this.lock.releaseReadLock();
        OrNode.processCandidate(doc, this, act, false);
    }

    private static void addNextLevelActivations(Document doc, InputNode secondNode, AndNode.Refinement ref, Provider<AndNode> pnlp, NodeActivation act) {
        INeuron.ThreadState th = ((INeuron)secondNode.inputNeuron.get()).getThreadState(doc.threadId, false);
        if (th == null || th.activations.isEmpty()) {
            return;
        }
        Activation iAct = (Activation)act.inputs.firstEntry().getValue();
        AndNode nlp = pnlp.get(doc);
        if (nlp.combinatorialExpensive) {
            return;
        }
        NodeActivation.Key ak = act.key;
        NodeActivation.Key iak = iAct.key;
        InputNode firstNode = (InputNode)ak.node;
        Integer secondRid = Utils.nullSafeAdd(ak.rid, false, ref.rid, false);
        Stream<Activation> s = Activation.select(th, (INeuron)secondNode.inputNeuron.get(), secondRid, iak.range, Range.Relation.createQuery(firstNode.key.rangeMatch, secondNode.key.rangeOutput, firstNode.key.rangeOutput, secondNode.key.rangeMatch), null, null);
        s.forEach(secondIAct -> {
            InterpretationNode o;
            NodeActivation secondAct = secondNode.getInputNodeActivation((Activation)secondIAct);
            if (secondAct != null && (o = InterpretationNode.add(doc, true, key.interpretation, secondIAct.key.interpretation)) != null) {
                Node.addActivationAndPropagate(doc, new NodeActivation.Key<AndNode>(nlp, Range.mergeRange(inputNode2.key.rangeOutput.map(key2.range), inputNode.key.rangeOutput.map(secondIAct.key.range)), Utils.nullSafeMin(key.rid, secondAct.key.rid), o), AndNode.prepareInputActs(act, secondAct));
            }
        });
    }

    private NodeActivation getInputNodeActivation(Activation act) {
        for (NodeActivation inAct : act.outputs.values()) {
            if (inAct.key.node != this) continue;
            return inAct;
        }
        return null;
    }

    @Override
    public void discover(Document doc, NodeActivation<InputNode> act, PatternDiscovery.Config config) {
        Model cfr_ignored_0 = this.provider.model;
        long v = Model.visitedCounter.addAndGet(1L);
        doc.getFinalActivations().forEach(secondNAct -> {
            for (NodeActivation secondAct : secondNAct.outputs.values()) {
                AndNode.Refinement ref = new AndNode.Refinement(secondAct.key.rid, nodeActivation.key.rid, ((Node)secondAct.key.node).provider);
                InputNode in = ref.input.get(doc);
                Range.Relation rm = Range.Relation.createQuery(this.key.rangeMatch, in.key.rangeOutput, this.key.rangeOutput, in.key.rangeMatch);
                if (act == secondAct || this == in || in.visitedDiscover == v || in.key.isRecurrent || !rm.compare(secondAct.key.range, nodeActivation.key.range)) continue;
                in.visitedDiscover = v;
                AndNode nln = AndNode.createNextLevelNode(document.model, document.threadId, this, ref, config);
                if (nln == null) continue;
                nln.isDiscovered = true;
                document.addedNodes.add(nln);
            }
        });
    }

    @Override
    boolean contains(AndNode.Refinement ref) {
        return this == ref.input.get() && Utils.compareInteger(this.key.relativeRid, ref.rid) == 0;
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, INeuron n) {
        return n.biasSum + Math.abs(this.getSynapse((Integer)(this.key.relativeRid == null ? null : offset), (Neuron)((Neuron)n.provider)).weight);
    }

    public Synapse getSynapse(Integer rid, Neuron outputNeuron) {
        this.synapseLock.acquireReadLock();
        Synapse s = this.synapses != null ? this.synapses.get(new SynapseKey(rid, outputNeuron)) : null;
        this.synapseLock.releaseReadLock();
        return s;
    }

    public void setSynapse(Synapse s) {
        this.synapseLock.acquireWriteLock();
        if (this.synapses == null) {
            this.synapses = new TreeMap<SynapseKey, Synapse>();
        }
        this.synapses.put(new SynapseKey(s.key.relativeRid, s.output), s);
        this.synapseLock.releaseWriteLock();
    }

    public void removeSynapse(Synapse s) {
        if (this.synapses != null) {
            this.synapseLock.acquireWriteLock();
            this.synapses.remove(new SynapseKey(s.key.relativeRid, s.output));
            this.synapseLock.releaseWriteLock();
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void remove() {
        ((INeuron)this.inputNeuron.get()).outputNodes.remove(this.key);
        super.remove();
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("I");
        sb.append(this.key.isRecurrent ? "R" : "");
        sb.append(this.getRangeBrackets(this.key.rangeOutput.begin));
        if (this.inputNeuron != null) {
            sb.append(this.inputNeuron.id);
            if (((INeuron)this.inputNeuron.get()).label != null) {
                sb.append(",");
                sb.append(((INeuron)this.inputNeuron.get()).label);
            }
        }
        sb.append(this.getRangeBrackets(this.key.rangeOutput.end));
        return sb.toString();
    }

    private String getRangeBrackets(Range.Mapping rs) {
        if (rs == Range.Mapping.NONE) {
            return "|";
        }
        return rs == Range.Mapping.BEGIN ? "[" : "]";
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(73);
        super.write(out);
        this.key.write(out);
        out.writeBoolean(this.inputNeuron != null);
        if (this.inputNeuron != null) {
            out.writeInt(this.inputNeuron.id);
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        this.key = Synapse.lookupKey(Synapse.Key.read(in, m));
        if (in.readBoolean()) {
            this.inputNeuron = m.lookupNeuron(in.readInt());
        }
    }

    private static class SynapseKey
    implements Writable,
    Comparable<SynapseKey> {
        Integer rid;
        Neuron neuron;

        private SynapseKey() {
        }

        public SynapseKey(Integer rid, Neuron neuron) {
            this.rid = rid;
            this.neuron = neuron;
        }

        @Override
        public int compareTo(SynapseKey sk) {
            int r = Utils.compareInteger(this.rid, sk.rid);
            if (r != 0) {
                return r;
            }
            return this.neuron.compareTo(sk.neuron);
        }

        public static SynapseKey read(DataInput in, Model m) throws IOException {
            SynapseKey sk = new SynapseKey();
            sk.readFields(in, m);
            return sk;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.rid != null);
            if (this.rid != null) {
                out.writeInt(this.rid);
            }
            out.writeInt(this.neuron.id);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            if (in.readBoolean()) {
                this.rid = in.readInt();
            }
            this.neuron = m.lookupNeuron(in.readInt());
        }
    }
}

