/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.util.Collection;
import java.util.TreeMap;
import org.aika.Utils;
import org.aika.corpus.Document;
import org.aika.corpus.InterpretationNode;
import org.aika.corpus.Range;
import org.aika.lattice.Node;

public class NodeActivation<T extends Node>
implements Comparable<NodeActivation> {
    public final int id;
    public final Key<T> key;
    public final Document doc;
    public long visited = -1L;
    public TreeMap<Key, NodeActivation<?>> inputs = new TreeMap();
    public TreeMap<Key, NodeActivation<?>> outputs = new TreeMap();

    public NodeActivation(int id, Document doc, Key<T> key) {
        this.id = id;
        this.doc = doc;
        this.key = key;
    }

    public NodeActivation(int id, Document doc, T n, Range pos, Integer rid, InterpretationNode o) {
        this.id = id;
        this.doc = doc;
        this.key = new Key<T>(n, pos, rid, o);
    }

    public void link(Collection<NodeActivation> inputActs) {
        for (NodeActivation iAct : inputActs) {
            this.inputs.put(iAct.key, iAct);
            iAct.outputs.put(this.key, this);
        }
    }

    public String toString(Document doc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ACT ");
        sb.append(",(");
        sb.append(this.key.range);
        sb.append("),");
        sb.append(doc.getContent().substring(Math.max(0, this.key.range.begin - 3), Math.min(doc.length(), this.key.range.end + 3)));
        sb.append(",");
        sb.append(this.key.node);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public int compareTo(NodeActivation act) {
        return this.key.compareTo(act.key);
    }

    public static int compare(NodeActivation a, NodeActivation b) {
        if (a == b) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static final class Key<T extends Node>
    implements Comparable<Key> {
        public final T node;
        public final Range range;
        public final Integer rid;
        public final InterpretationNode interpretation;

        public Key(T node, Range range, Integer rid, InterpretationNode interpretation) {
            this.node = node;
            this.range = range;
            this.rid = rid;
            this.interpretation = interpretation;
        }

        @Override
        public int compareTo(Key k) {
            int x = ((Node)this.node).compareTo((Node)k.node);
            if (x != 0) {
                return x;
            }
            x = Range.compare(this.range, k.range, false);
            if (x != 0) {
                return x;
            }
            x = Utils.compareInteger(this.rid, k.rid);
            if (x != 0) {
                return x;
            }
            return this.interpretation.compareTo(k.interpretation);
        }

        public String toString() {
            return (this.node != null ? ((Node)this.node).getNeuronLabel() : "") + " " + this.range + " " + this.rid + " " + this.interpretation;
        }
    }
}

