/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.aika.Utils;
import org.aika.corpus.Document;
import org.aika.corpus.InterpretationNode;
import org.aika.corpus.Range;
import org.aika.corpus.SearchNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.lattice.OrNode;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Activation
extends NodeActivation<OrNode> {
    private static final Logger log = LoggerFactory.getLogger(Activation.class);
    public TreeSet<SynapseActivation> neuronInputs = new TreeSet<SynapseActivation>(SynapseActivation.INPUT_COMP);
    public TreeSet<SynapseActivation> neuronOutputs = new TreeSet<SynapseActivation>(SynapseActivation.OUTPUT_COMP);
    public Integer sequence;
    public double upperBound;
    public double lowerBound;
    public Rounds rounds = new Rounds();
    public double maxActValue = 0.0;
    public boolean ubQueued = false;
    public boolean isQueued = false;
    public long queueId;
    public long currentStateV;
    public StateChange currentStateChange;
    public double errorSignal;
    public Double targetValue;
    public Double inputValue;

    public Activation(int id, Document doc, NodeActivation.Key key) {
        super(id, doc, key);
    }

    public void addSynapseActivation(int dir, SynapseActivation sa) {
        if (dir == 0) {
            this.neuronOutputs.add(sa);
        } else {
            this.neuronInputs.add(sa);
        }
    }

    public void removeSynapseActivation(int dir, SynapseActivation sa) {
        if (dir == 0) {
            this.neuronOutputs.remove(sa);
        } else {
            this.neuronInputs.remove(sa);
        }
    }

    public List<SynapseActivation> getFinalInputActivations() {
        ArrayList<SynapseActivation> results = new ArrayList<SynapseActivation>();
        for (SynapseActivation inputAct : this.neuronInputs) {
            if (!inputAct.input.isFinalActivation()) continue;
            results.add(inputAct);
        }
        return results;
    }

    public List<SynapseActivation> getFinalOutputActivations() {
        ArrayList<SynapseActivation> results = new ArrayList<SynapseActivation>();
        for (SynapseActivation inputAct : this.neuronOutputs) {
            if (!inputAct.output.isFinalActivation()) continue;
            results.add(inputAct);
        }
        return results;
    }

    public boolean isFinalActivation() {
        return this.getFinalState().value > 0.0 || this.targetValue != null && this.targetValue > 0.0;
    }

    public State getFinalState() {
        return this.rounds.getLast();
    }

    public static Activation get(Document doc, INeuron n, Integer rid, Range r, Range.Relation rr, InterpretationNode o, InterpretationNode.Relation or) {
        Stream<Activation> s = Activation.select(doc, n, rid, r, rr, o, or);
        return s.findFirst().orElse(null);
    }

    public static Activation get(Document doc, INeuron n, NodeActivation.Key ak) {
        return Activation.get(doc, n, ak.rid, ak.range, Range.Relation.EQUALS, ak.interpretation, InterpretationNode.Relation.EQUALS);
    }

    public static Stream<Activation> select(Document doc, INeuron n, Integer rid, Range r, Range.Relation rr, InterpretationNode o, InterpretationNode.Relation or) {
        INeuron.ThreadState th = n.getThreadState(doc.threadId, false);
        if (th == null) {
            return Stream.empty();
        }
        return Activation.select(th, n, rid, r, rr, o, or);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Stream<Activation> select(INeuron.ThreadState th, INeuron n, Integer rid, Range r, Range.Relation rr, InterpretationNode o, InterpretationNode.Relation or) {
        void var7_12;
        int s = th.activations.size();
        Node node = n.node.get();
        if (s == 0) {
            return Stream.empty();
        }
        if (s == 1) {
            Stream<Activation> stream = th.activations.values().stream();
            return var7_12.filter(act -> act.filter(node, rid, r, rr, o, or));
        } else if (rid != null) {
            NodeActivation.Key<Node> bk = new NodeActivation.Key<Node>(node, Range.MIN, rid, InterpretationNode.MIN);
            NodeActivation.Key<Node> ek = new NodeActivation.Key<Node>(node, Range.MAX, rid, InterpretationNode.MAX);
            if (th.activationsRid == null) return Stream.empty();
            Stream stream = th.activationsRid.subMap(bk, true, ek, true).values().stream();
            return var7_12.filter(act -> act.filter(node, rid, r, rr, o, or));
        } else {
            if (rr != null) return Activation.getActivationsByRange(th, n, rid, r, rr, o, or);
            Stream<Activation> stream = th.activations.values().stream();
        }
        return var7_12.filter(act -> act.filter(node, rid, r, rr, o, or));
    }

    public static Stream<Activation> getActivationsByRange(INeuron.ThreadState th, INeuron n, Integer rid, Range r, Range.Relation rr, InterpretationNode o, InterpretationNode.Relation or) {
        Collection<Activation> s;
        Node node = n.node.get();
        if ((rr.beginToBegin == Range.Operator.GREATER_THAN_EQUAL || rr.beginToBegin == Range.Operator.EQUALS) && r.begin != Integer.MIN_VALUE && r.begin <= r.end) {
            int er = (rr.endToEnd == Range.Operator.LESS_THAN_EQUAL || rr.endToEnd == Range.Operator.EQUALS) && r.end != Integer.MAX_VALUE ? r.end : Integer.MAX_VALUE;
            s = th.activations.subMap(new NodeActivation.Key<Node>(node, new Range(r.begin, Integer.MIN_VALUE), null, InterpretationNode.MIN), true, new NodeActivation.Key<Node>(node, new Range(er, Integer.MAX_VALUE), Integer.MAX_VALUE, InterpretationNode.MAX), true).values();
        } else {
            s = (rr.beginToBegin == Range.Operator.LESS_THAN_EQUAL || rr.beginToBegin == Range.Operator.EQUALS) && r.begin != Integer.MIN_VALUE && r.begin <= r.end ? th.activations.descendingMap().subMap(new NodeActivation.Key<Node>(node, new Range(r.begin, Integer.MAX_VALUE), null, InterpretationNode.MAX), true, new NodeActivation.Key<Node>(node, new Range(Integer.MIN_VALUE, Integer.MIN_VALUE), null, InterpretationNode.MIN), true).values() : th.activations.values();
        }
        return s.stream().filter(act -> act.filter(node, rid, r, rr, o, or));
    }

    private static Stream<Activation> getActivationsStream(INeuron n, Document doc) {
        INeuron.ThreadState th = n.getThreadState(doc.threadId, false);
        return th == null ? Stream.empty() : th.activations.values().stream();
    }

    public <T extends Node> boolean filter(T n, Integer rid, Range r, Range.Relation rr, InterpretationNode o, InterpretationNode.Relation or) {
        return !(n != null && this.key.node != n || rid != null && (this.key.rid == null || this.key.rid.intValue() != rid.intValue()) || r != null && rr != null && !rr.compare(this.key.range, r) || o != null && !or.compare(this.key.interpretation, o));
    }

    public Integer getSequence() {
        if (this.sequence != null) {
            return this.sequence;
        }
        this.sequence = 0;
        this.neuronInputs.stream().filter(sa -> !sa.synapse.key.isRecurrent).forEach(sa -> {
            this.sequence = Math.max(this.sequence, sa.input.getSequence() + 1);
        });
        return this.sequence;
    }

    public String toString(SearchNode sn, boolean withWeights, boolean withTextSnipped, boolean withLogic) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id + " ");
        if (sn != null) {
            sb.append((Object)((Object)this.key.interpretation.state) + " ");
            sb.append(this.sequence + " ");
        }
        sb.append(this.key.range);
        if (withTextSnipped) {
            sb.append(" ");
            if (((INeuron)((OrNode)this.key.node).neuron.get()).outputText != null) {
                sb.append(this.collapseText(((INeuron)((OrNode)this.key.node).neuron.get()).outputText));
            } else {
                sb.append(this.collapseText(this.doc.getText(this.key.range)));
            }
        }
        sb.append(" - ");
        sb.append(this.key.interpretation);
        sb.append(" - ");
        sb.append(withLogic ? ((OrNode)this.key.node).toString() : ((OrNode)this.key.node).getNeuronLabel());
        sb.append(" - Rid:");
        sb.append(this.key.rid);
        sb.append(" - UB:");
        sb.append(Utils.round(this.upperBound));
        if (withWeights) {
            sb.append(" - ");
            for (Map.Entry<Integer, State> me : this.rounds.rounds.entrySet()) {
                State s = me.getValue();
                sb.append("[R:" + me.getKey());
                sb.append(" VALUE:" + Utils.round(s.value));
                sb.append(" W:" + Utils.round(s.weight.w));
                sb.append(" N:" + Utils.round(s.weight.n));
                sb.append("]");
            }
            if (this.isFinalActivation()) {
                State fs = this.getFinalState();
                sb.append(" - FV:" + Utils.round(fs.value));
                sb.append(" FW:" + Utils.round(fs.weight.w));
                sb.append(" FN:" + Utils.round(fs.weight.n));
                if (this.targetValue != null) {
                    sb.append(" - TV:" + Utils.round(this.targetValue));
                }
            }
        }
        return sb.toString();
    }

    private String collapseText(String txt) {
        if (txt.length() <= 10) {
            return txt;
        }
        return txt.substring(0, 5) + "..." + txt.substring(txt.length() - 5);
    }

    public void saveOldState(List<StateChange> changes, long v) {
        StateChange sc = this.currentStateChange;
        if (sc == null || this.currentStateV != v) {
            sc = new StateChange();
            sc.oldRounds = this.rounds.copy();
            this.currentStateChange = sc;
            this.currentStateV = v;
            if (changes != null) {
                changes.add(sc);
            }
        }
    }

    public void saveNewState() {
        StateChange sc = this.currentStateChange;
        sc.newRounds = this.rounds.copy();
    }

    public static class Builder {
        public Range range;
        public Integer rid;
        public InterpretationNode interpretation;
        public double value = 1.0;
        public Double targetValue;
        public int fired;

        public Builder setRange(int begin, int end) {
            this.range = new Range(begin, end);
            return this;
        }

        public Builder setRange(Range range) {
            this.range = range;
            return this;
        }

        public Builder setRelationalId(Integer rid) {
            this.rid = rid;
            return this;
        }

        public Builder setInterpretation(InterpretationNode interpretation) {
            this.interpretation = interpretation;
            return this;
        }

        public Builder setValue(double value) {
            this.value = value;
            return this;
        }

        public Builder setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public Builder setFired(int fired) {
            this.fired = fired;
            return this;
        }
    }

    public class StateChange {
        public Rounds oldRounds;
        public Rounds newRounds;

        public void restoreState(Mode m) {
            Activation.this.rounds = (m == Mode.OLD ? this.oldRounds : this.newRounds).copy();
        }

        public Activation getActivation() {
            return Activation.this;
        }
    }

    public static enum Mode {
        OLD,
        NEW;

    }

    public static class State {
        public static final int DIR = 0;
        public static final int REC = 1;
        public final double value;
        public final int fired;
        public final INeuron.NormWeight weight;
        public static final State ZERO = new State(0.0, -1, INeuron.NormWeight.ZERO_WEIGHT);

        public State(double value, int fired, INeuron.NormWeight weight) {
            assert (!Double.isNaN(value));
            this.value = value;
            this.fired = fired;
            this.weight = weight;
        }

        public boolean equals(State s) {
            return Math.abs(this.value - s.value) <= INeuron.WEIGHT_TOLERANCE;
        }

        public boolean equalsWithWeights(State s) {
            return this.equals(s) && this.weight.equals(s.weight);
        }

        public String toString() {
            return "VALUE:" + this.value;
        }
    }

    public static class Rounds {
        public long modified;
        private boolean[] isQueued = new boolean[3];
        public TreeMap<Integer, State> rounds = new TreeMap();

        public Rounds() {
            this.rounds.put(0, State.ZERO);
        }

        public boolean set(int r, State s) {
            State lr = this.get(r - 1);
            if (lr != null && lr.equalsWithWeights(s)) {
                State or = this.rounds.get(r);
                if (or != null) {
                    this.rounds.remove(r);
                    return !or.equalsWithWeights(s);
                }
                return false;
            }
            State or = this.rounds.put(r, s);
            Iterator<Map.Entry<Integer, State>> it = this.rounds.tailMap(r + 1).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, State> me = it.next();
                if (!me.getValue().equalsWithWeights(s)) continue;
                it.remove();
            }
            return or == null || !or.equalsWithWeights(s);
        }

        public State get(int r) {
            Map.Entry<Integer, State> me = this.rounds.floorEntry(r);
            return me != null ? me.getValue() : null;
        }

        public Rounds copy() {
            Rounds nr = new Rounds();
            nr.modified = this.modified;
            nr.rounds.putAll(this.rounds);
            return nr;
        }

        public Integer getLastRound() {
            return !this.rounds.isEmpty() ? this.rounds.lastKey() : null;
        }

        public State getLast() {
            return !this.rounds.isEmpty() ? this.rounds.lastEntry().getValue() : State.ZERO;
        }

        public void setQueued(int r, boolean v) {
            if (r >= this.isQueued.length) {
                this.isQueued = Arrays.copyOf(this.isQueued, this.isQueued.length * 2);
            }
            this.isQueued[r] = v;
        }

        public boolean isQueued(int r) {
            return r < this.isQueued.length ? this.isQueued[r] : false;
        }

        public void reset() {
            this.modified = 0L;
            this.rounds.clear();
            this.rounds.put(0, State.ZERO);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.rounds.forEach((r, s) -> sb.append(r + ":" + s.value + " "));
            return sb.toString();
        }

        public boolean compare(Rounds r) {
            if (this.rounds.size() != r.rounds.size()) {
                return false;
            }
            for (Map.Entry<Integer, State> me : this.rounds.entrySet()) {
                State sa = me.getValue();
                State sb = r.rounds.get(me.getKey());
                if (sb != null && Utils.round(sa.value) == Utils.round(sb.value)) continue;
                return false;
            }
            return true;
        }
    }

    public static class SynapseActivation {
        public final Synapse synapse;
        public final Activation input;
        public final Activation output;
        public static Comparator<SynapseActivation> INPUT_COMP = (sa1, sa2) -> {
            int r = Synapse.INPUT_SYNAPSE_COMP.compare(sa1.synapse, sa2.synapse);
            if (r != 0) {
                return r;
            }
            return sa1.input.compareTo(sa2.input);
        };
        public static Comparator<SynapseActivation> OUTPUT_COMP = (sa1, sa2) -> {
            int r = Synapse.OUTPUT_SYNAPSE_COMP.compare(sa1.synapse, sa2.synapse);
            if (r != 0) {
                return r;
            }
            return sa1.output.compareTo(sa2.output);
        };

        public SynapseActivation(Synapse s, Activation input, Activation output) {
            this.synapse = s;
            this.input = input;
            this.output = output;
        }
    }
}

