/*
 * Decompiled with CFR 0.152.
 */
package org.aika.training;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.aika.Model;
import org.aika.Neuron;
import org.aika.Writable;
import org.aika.neuron.Synapse;

public class MetaSynapse
implements Writable {
    public double metaWeight;
    public double metaBias;
    public boolean metaRelativeRid;

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.metaWeight);
        out.writeDouble(this.metaBias);
        out.writeBoolean(this.metaRelativeRid);
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        this.metaWeight = in.readDouble();
        this.metaBias = in.readDouble();
        this.metaRelativeRid = in.readBoolean();
    }

    public static class Builder
    extends Synapse.Builder {
        public double metaWeight;
        public double metaBias;
        public boolean metaRelativeRid;

        public Builder setMetaWeight(double metaWeight) {
            this.metaWeight = metaWeight;
            return this;
        }

        public Builder setMetaBias(double metaBias) {
            this.metaBias = metaBias;
            return this;
        }

        public Builder setMetaRelativeRid(boolean metaRelativeRid) {
            this.metaRelativeRid = metaRelativeRid;
            return this;
        }

        @Override
        public Synapse getSynapse(Neuron outputNeuron) {
            Synapse s = super.getSynapse(outputNeuron);
            MetaSynapse ss = new MetaSynapse();
            ss.metaWeight = this.metaWeight;
            ss.metaBias = this.metaBias;
            ss.metaRelativeRid = this.metaRelativeRid;
            s.meta = ss;
            return s;
        }
    }
}

