/*
 * Decompiled with CFR 0.152.
 */
package org.aika.training;

import java.util.Collection;
import org.aika.corpus.Document;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;

public class PatternDiscovery {
    public static void discover(Document doc, Config config) {
        Collection<NodeActivation> allActs = doc.getAllNodeActivations();
        allActs.forEach(act -> config.counter.count((NodeActivation)act));
        allActs.stream().filter(act -> config.checkExpandable.evaluate((NodeActivation)act)).forEach(act -> ((Node)act.key.node).discover(doc, act, config));
    }

    public static class Config {
        public PatternEvaluation checkValidPattern;
        public ActivationEvaluation checkExpandable;
        public Counter counter;

        public Config setCheckValidPattern(PatternEvaluation checkValidPattern) {
            this.checkValidPattern = checkValidPattern;
            return this;
        }

        public Config setCheckExpandable(ActivationEvaluation checkExpandable) {
            this.checkExpandable = checkExpandable;
            return this;
        }

        public Config setCounter(Counter counter) {
            this.counter = counter;
            return this;
        }
    }

    public static interface Counter {
        public void count(NodeActivation var1);
    }

    public static interface ActivationEvaluation {
        public boolean evaluate(NodeActivation var1);
    }

    public static interface PatternEvaluation {
        public boolean evaluate(Node var1);
    }
}

