/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;

public class Utils {
    public static <T> boolean contains(T[] in, T x, Comparator<T> c) {
        for (T y : in) {
            if (c.compare(x, y) != 0) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] addToArray(T[] in, T n) {
        T[] r = Arrays.copyOf(in, in.length + 1);
        r[in.length] = n;
        return r;
    }

    public static <T> T[] removeToArray(T[] in, T n) {
        Object[] r = (Object[])Array.newInstance(n.getClass(), in.length - 1);
        int i = 0;
        for (T x : in) {
            if (x == n) continue;
            r[i++] = x;
        }
        return r;
    }

    public static boolean compareNullSafe(Integer a, Integer b) {
        if (a == null || b == null) {
            return true;
        }
        return a >= b;
    }

    public static int compareInteger(Integer a, Integer b) {
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a != null && b != null) {
            return Integer.compare(a, b);
        }
        return 0;
    }

    public static double round(double x) {
        return (double)Math.round(x * 1000.0) / 1000.0;
    }

    public static Integer nullSafeAdd(Integer a, boolean fa, Integer b, boolean fb) {
        if (b == null) {
            return fa ? a : null;
        }
        if (a == null) {
            return fb ? b : null;
        }
        return a + b;
    }

    public static Integer nullSafeSub(Integer a, boolean fa, Integer b, boolean fb) {
        if (b == null) {
            return fa ? a : null;
        }
        if (a == null) {
            return fb ? b : null;
        }
        return a - b;
    }

    public static Integer nullSafeMin(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Math.min(a, b);
    }

    public static Integer nullSafeMax(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Math.max(a, b);
    }

    public static String collapseText(String txt) {
        if (txt.length() <= 10) {
            return txt;
        }
        return txt.substring(0, 5) + "..." + txt.substring(txt.length() - 5);
    }
}

