/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aika.AbstractNode;
import org.aika.Converter;
import org.aika.Model;
import org.aika.Provider;
import org.aika.Utils;
import org.aika.corpus.Candidate;
import org.aika.corpus.InterpretationNode;
import org.aika.corpus.Range;
import org.aika.corpus.SearchNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;
import org.aika.training.SupervisedTraining;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Document
implements Comparable<Document> {
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    public static boolean APPLY_DEBUG_OUTPUT = false;
    public static boolean OPTIMIZE_DEBUG_OUTPUT = false;
    public static int CLEANUP_INTERVAL = 500;
    public static int MAX_ROUND = 20;
    public final int id;
    private final String content;
    public long visitedCounter = 1L;
    public int interpretationIdCounter = 1;
    public int activationIdCounter = 0;
    public int searchNodeIdCounter = 0;
    public int searchStepCounter = 0;
    public InterpretationNode bottom = new InterpretationNode(this, -1, 0, 0, InterpretationNode.State.SELECTED);
    public Model model;
    public int threadId;
    public Queue queue = new Queue();
    public ValueQueue vQueue = new ValueQueue();
    public UpperBoundQueue ubQueue = new UpperBoundQueue();
    public TreeSet<Node> activatedNodes = new TreeSet();
    public TreeSet<INeuron> activatedNeurons = new TreeSet();
    public TreeSet<INeuron> finallyActivatedNeurons = new TreeSet();
    public TreeSet<Activation> inputNeuronActivations = new TreeSet();
    public TreeMap<INeuron, Set<Synapse>> modifiedWeights = new TreeMap();
    public SupervisedTraining supervisedTraining = new SupervisedTraining(this);
    public TreeMap<NodeActivation.Key, Activation> activationsByRid = new TreeMap((act1, act2) -> {
        int r = Integer.compare(act1.rid, act2.rid);
        if (r != 0) {
            return r;
        }
        return act1.compareTo((NodeActivation.Key)act2);
    });
    public TreeSet<Node> addedNodes = new TreeSet();
    public ArrayList<NodeActivation> addedNodeActivations = new ArrayList();
    public ArrayList<Activation> addedActivations = new ArrayList();
    public SearchNode rootSearchNode = new SearchNode(this, null, null, null, -1);
    public SearchNode selectedSearchNode = null;
    public ArrayList<Candidate> candidates = new ArrayList();
    public List<InterpretationNode> bestInterpretation = null;
    public long createV;
    public static Comparator<NodeActivation> ACTIVATIONS_OUTPUT_COMPARATOR = (act1, act2) -> {
        int r = Range.compare(act1.key.range, act2.key.range, false);
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(act1.key.rid, act2.key.rid);
        if (r != 0) {
            return r;
        }
        r = act1.key.interpretation.compareTo(act2.key.interpretation);
        if (r != 0) {
            return r;
        }
        return ((Node)act1.key.node).compareTo((Node)act2.key.node);
    };
    private static Comparator<Activation> VALUE_QUEUE_COMP = (a, b) -> {
        int r = Integer.compare(a.getSequence(), b.getSequence());
        if (r != 0) {
            return r;
        }
        return Integer.compare(a.id, b.id);
    };

    public Document(int id, String content, Model model, int threadId) {
        this.id = id;
        this.content = content;
        this.model = model;
        this.threadId = threadId;
    }

    public String getContent() {
        return this.content;
    }

    public int length() {
        return this.content.length();
    }

    public String toString() {
        return this.content;
    }

    public String getText(Range r) {
        return this.content.substring(Math.max(0, Math.min(r.begin, this.length())), Math.max(0, Math.min(r.end, this.length())));
    }

    public Stream<Activation> getFinalActivations() {
        return this.finallyActivatedNeurons.stream().flatMap(in -> in.getFinalActivationsStream(this));
    }

    public Stream<Activation> getActivations() {
        return this.activatedNeurons.stream().flatMap(in -> in.getActivationsStream(this));
    }

    public String bestInterpretationToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Best Interpretation:\n");
        sb.append(this.bestInterpretation.toString());
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public int compareTo(Document doc) {
        return Integer.compare(this.id, doc.id);
    }

    public void propagate() {
        for (Node n : this.addedNodes) {
            n.reprocessInputs(this);
        }
        this.addedNodes.clear();
        boolean flag = true;
        while (flag) {
            this.queue.processChanges();
            flag = this.ubQueue.process();
        }
    }

    public void generateCandidates() {
        TreeSet<Candidate> tmp = new TreeSet<Candidate>();
        int i = 0;
        for (Activation act : this.addedActivations) {
            InterpretationNode cn = act.key.interpretation;
            if (cn.state != InterpretationNode.State.UNKNOWN || !(cn.activation.upperBound > 0.0)) continue;
            tmp.add(new Candidate(cn, i++));
        }
        long v = this.visitedCounter++;
        for (Activation act : this.inputNeuronActivations) {
            act.visited = v;
        }
        while (!tmp.isEmpty()) {
            int oldSize = tmp.size();
            for (Candidate c : tmp) {
                if (!c.checkDependenciesSatisfied(v)) continue;
                tmp.remove(c);
                c.id = this.candidates.size();
                this.candidates.add(c);
                c.refinement.activation.visited = v;
                break;
            }
            if (tmp.size() != oldSize) continue;
            log.error("Cycle detected in the activations that is not marked recurrent.");
            throw new RuntimeException("Cycle detected in the activations that is not marked recurrent.");
        }
    }

    public void process() {
        this.inputNeuronActivations.forEach(act -> this.vQueue.propagateActivationValue(0, (Activation)act));
        if (OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Root SearchNode:" + this.toString());
        }
        this.generateCandidates();
        this.addedActivations.clear();
        Candidate c = !this.candidates.isEmpty() ? this.candidates.get(0) : null;
        SearchNode child = new SearchNode(this, this.rootSearchNode, null, c, 0);
        SearchNode.searchIterative(this, child);
        ArrayList<InterpretationNode> results = new ArrayList<InterpretationNode>();
        results.add(this.bottom);
        if (this.selectedSearchNode != null) {
            this.selectedSearchNode.reconstructSelectedResult(this);
            this.selectedSearchNode.collectResults(results);
        }
        this.bestInterpretation = results;
        if (OPTIMIZE_DEBUG_OUTPUT) {
            this.dumpDebugCandidateStatistics();
        }
    }

    public void dumpDebugCandidateStatistics() {
        for (Candidate c : this.candidates) {
            log.info(c.toString());
        }
    }

    public void notifyWeightsModified(INeuron n, Collection<Synapse> inputSynapses) {
        Set<Synapse> is = this.modifiedWeights.get(n);
        if (is == null) {
            is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_COMP);
            this.modifiedWeights.put(n, is);
        }
        is.addAll(inputSynapses);
    }

    public void commit() {
        this.modifiedWeights.forEach((n, inputSyns) -> Converter.convert(this.model, this.threadId, this, n, inputSyns));
        this.modifiedWeights.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActivations() {
        this.activatedNeurons.forEach(n -> n.clearActivations(this));
        this.activatedNodes.forEach(n -> n.clearActivations(this));
        this.addedActivations.clear();
        this.addedNodeActivations.clear();
        this.activatedNeurons.clear();
        this.activatedNodes.clear();
        this.addedNodes.clear();
        if (this.model.lastCleanup[this.threadId] + CLEANUP_INTERVAL < this.id) {
            ArrayList<Provider<? extends AbstractNode>> tmp;
            this.model.lastCleanup[this.threadId] = this.id;
            Map<Integer, Provider<? extends AbstractNode>> map = this.model.activeProviders;
            synchronized (map) {
                tmp = new ArrayList<Provider<? extends AbstractNode>>(this.model.activeProviders.values());
            }
            tmp.forEach(np -> {
                Object an = np.getIfNotSuspended();
                if (an != null && an instanceof Node) {
                    Node n = (Node)an;
                    Node.ThreadState th = n.threads[this.threadId];
                    if (th != null && th.lastUsed + (long)CLEANUP_INTERVAL < (long)this.id) {
                        n.threads[this.threadId] = null;
                    }
                }
            });
        }
        this.model.docs[this.threadId] = null;
    }

    public String generateOutputText() {
        StringBuilder sb = new StringBuilder();
        this.finallyActivatedNeurons.stream().filter(n -> n.outputText != null).forEach(n -> {
            for (Activation act : n.getFinalActivations(this)) {
                sb.replace(act.key.range.begin, act.key.range.end, n.outputText);
            }
        });
        return sb.toString();
    }

    public String activationsToString() {
        return this.activationsToString(false, false);
    }

    public String activationsToString(boolean withTextSnipped, boolean withLogic) {
        return this.activationsToString(null, withTextSnipped, withLogic);
    }

    public String activationsToString(SearchNode sn, boolean withTextSnippet, boolean withLogic) {
        TreeSet<NodeActivation> acts = new TreeSet<NodeActivation>(ACTIVATIONS_OUTPUT_COMPARATOR);
        for (INeuron n : this.activatedNeurons) {
            Stream<Activation> stream = Activation.select(this, n, null, null, null, null, InterpretationNode.Relation.CONTAINED_IN);
            acts.addAll(stream.collect(Collectors.toList()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Activation ID -");
        sb.append(sn != null ? " Interpr. Node State | SequenceNr. |" : "");
        sb.append(" Range" + (withTextSnippet ? " | Text Snippet" : ""));
        sb.append(" -");
        sb.append(" Interpr. Node -");
        sb.append(" Neuron Label -");
        sb.append(withLogic ? " Logic Layer -" : "");
        sb.append(" Relational ID (Word Pos.) -");
        sb.append(" Upper Bound -");
        sb.append(" Simulation Rounds [Round | Value | Weight | Norm] -");
        sb.append(" Final Value | Final Weight | Final Norm -");
        sb.append(" Input Value |");
        sb.append(" Target Value");
        sb.append("\n");
        sb.append("\n");
        for (Activation activation : acts) {
            if (activation.upperBound <= 0.0 && (activation.targetValue == null || activation.targetValue <= 0.0)) continue;
            sb.append(activation.toString(sn, withTextSnippet, withLogic));
            sb.append("\n");
        }
        if (this.selectedSearchNode != null) {
            sb.append("\n Final SearchNode:" + this.selectedSearchNode.id + "  WeightSum:" + this.selectedSearchNode.accumulatedWeight.toString() + "\n");
        }
        return sb.toString();
    }

    public Stream<NodeActivation> getAllActivationsStream() {
        return this.activatedNodes.stream().flatMap(n -> n.getActivations(this).stream());
    }

    public void dumpOscillatingActivations() {
        this.activatedNeurons.stream().flatMap(n -> n.getAllActivations(this).stream()).filter(act -> act.rounds.getLastRound() != null && act.rounds.getLastRound() > MAX_ROUND - 5).forEach(act -> {
            log.error(act.key + " " + (Object)((Object)act.key.interpretation.state) + " " + act.rounds);
            log.error(act.linksToString());
            log.error("");
        });
    }

    public class ValueQueue {
        public final ArrayList<TreeSet<Activation>> queue = new ArrayList();

        public void propagateActivationValue(int round, Activation act) {
            for (Activation.SynapseActivation sa : act.neuronOutputs) {
                int r = sa.synapse.key.isRecurrent ? round + 1 : round;
                this.add(r, sa.output);
            }
        }

        private void add(Activation act) {
            this.add(0, act);
            for (Activation.SynapseActivation sa : act.neuronOutputs) {
                if (!sa.synapse.key.isRecurrent) continue;
                this.add(0, sa.output);
            }
        }

        public void add(int round, Activation act) {
            TreeSet<Activation> q;
            if (act.rounds.isQueued(round) || act.key.interpretation.state == InterpretationNode.State.UNKNOWN) {
                return;
            }
            if (round < this.queue.size()) {
                q = this.queue.get(round);
            } else {
                assert (round == this.queue.size());
                q = new TreeSet(VALUE_QUEUE_COMP);
                this.queue.add(q);
            }
            act.rounds.setQueued(round, true);
            q.add(act);
        }

        public SearchNode.Weight process(SearchNode sn) {
            long v = Document.this.visitedCounter++;
            if (sn.getParent() != null && sn.getParent().candidate != null) {
                this.add(sn.getParent().candidate.refinement.activation);
            }
            SearchNode.Weight delta = SearchNode.Weight.ZERO;
            for (int round = 0; round < this.queue.size(); ++round) {
                TreeSet<Activation> q = this.queue.get(round);
                while (!q.isEmpty()) {
                    Activation act = q.pollFirst();
                    act.rounds.setQueued(round, false);
                    delta = delta.add(act.process(sn, round, v));
                }
            }
            return delta;
        }
    }

    public class UpperBoundQueue {
        public final ArrayDeque<Activation> queue = new ArrayDeque();

        public void add(Activation act) {
            if (!act.ubQueued) {
                act.ubQueued = true;
                this.queue.addLast(act);
            }
        }

        public boolean process() {
            boolean flag = false;
            while (!this.queue.isEmpty()) {
                flag = true;
                Activation act = this.queue.pollFirst();
                act.ubQueued = false;
                act.processBounds();
            }
            return flag;
        }
    }

    public class Queue {
        public final TreeSet<Node> queue = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                int r = Integer.compare(n1.level, n2.level);
                if (r != 0) {
                    return r;
                }
                Node.ThreadState th1 = n1.getThreadState(Document.this.threadId, true);
                Node.ThreadState th2 = n2.getThreadState(Document.this.threadId, true);
                return Long.compare(th1.queueId, th2.queueId);
            }
        });
        private long queueIdCounter = 0L;

        public void add(Node n) {
            Node.ThreadState th = n.getThreadState(Document.this.threadId, true);
            if (!th.isQueued) {
                th.isQueued = true;
                th.queueId = this.queueIdCounter++;
                this.queue.add(n);
            }
        }

        public void processChanges() {
            while (!this.queue.isEmpty()) {
                Node n = this.queue.pollFirst();
                Node.ThreadState th = n.getThreadState(Document.this.threadId, true);
                th.isQueued = false;
                n.processChanges(Document.this);
                if (!APPLY_DEBUG_OUTPUT) continue;
                log.info("QueueId:" + th.queueId);
                log.info(n.toString() + "\n");
                log.info("\n" + Document.this.activationsToString(true, true));
            }
        }
    }
}

