/*
 * Decompiled with CFR 0.152.
 */
package org.aika.corpus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.Utils;
import org.aika.corpus.Candidate;
import org.aika.corpus.Conflicts;
import org.aika.corpus.Document;
import org.aika.corpus.InterpretationNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNode
implements Comparable<SearchNode> {
    private static final Logger log = LoggerFactory.getLogger(SearchNode.class);
    public static int MAX_SEARCH_STEPS = Integer.MAX_VALUE;
    public static boolean ENABLE_CACHING = true;
    public int id;
    public SearchNode excludedParent;
    public SearchNode selectedParent;
    public long visited;
    Candidate candidate;
    int level;
    DebugState debugState;
    Weight weightDelta = Weight.ZERO;
    Weight accumulatedWeight;
    public Map<Activation, Activation.StateChange> modifiedActs = new TreeMap<Activation, Activation.StateChange>(Activation.ACTIVATION_ID_COMP);
    Step step = Step.INIT;
    boolean alreadySelected;
    boolean alreadyExcluded;
    SearchNode selectedChild = null;
    SearchNode excludedChild = null;
    Weight selectedWeight = Weight.ZERO;
    Weight excludedWeight = Weight.ZERO;

    public SearchNode(Document doc, SearchNode selParent, SearchNode exclParent, Candidate c, int level) {
        this.id = doc.searchNodeIdCounter++;
        this.level = level;
        this.visited = doc.visitedCounter++;
        this.selectedParent = selParent;
        this.excludedParent = exclParent;
        SearchNode pn = this.getParent();
        SearchNode csn = null;
        boolean modified = true;
        if (c != null) {
            this.candidate = c;
            this.candidate.currentSearchNode = this;
            csn = this.candidate.cachedSearchNodes;
            if (csn == null || csn.getDecision() != this.getDecision()) {
                if (pn != null && pn.candidate != null) {
                    Activation act = pn.candidate.refinement.activation;
                    act.markDirty(this.visited);
                    for (Activation.SynapseActivation sa : act.neuronOutputs) {
                        sa.output.markDirty(this.visited);
                    }
                }
            } else {
                modified = csn.isModified();
                if (pn != null && pn.candidate != null && modified) {
                    pn.candidate.debugComputed[2] = pn.candidate.debugComputed[2] + 1;
                }
            }
        }
        if (modified) {
            this.weightDelta = doc.vQueue.process(this);
            this.markDirty();
            if (this.candidate != null) {
                this.candidate.cachedSearchNodes = this;
            }
        } else if (ENABLE_CACHING) {
            this.candidate.cachedSearchNodes.changeState(Activation.Mode.NEW);
            this.weightDelta = this.candidate.cachedSearchNodes.weightDelta;
            for (Activation act : this.candidate.cachedSearchNodes.modifiedActs.keySet()) {
                act.saveOldState(this.modifiedActs, doc.visitedCounter++);
                act.saveNewState();
            }
        } else {
            this.weightDelta = doc.vQueue.process(this);
            if (Math.abs(this.weightDelta.w - csn.weightDelta.w) > 1.0E-5 || !this.compareNewState(csn)) {
                log.error("Cached search node activation do not match the newly computed results.");
                log.info("Computed results:");
                this.dumpDebugState();
                log.info("Cached results:");
                csn.dumpDebugState();
            }
        }
        if (pn != null && pn.candidate != null) {
            int[] nArray = pn.candidate.debugComputed;
            int n = modified ? 1 : 0;
            nArray[n] = nArray[n] + 1;
        }
        if (this.getParent() != null) {
            this.accumulatedWeight = this.weightDelta.add(this.getParent().accumulatedWeight);
        }
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Search Step: " + this.id + "  Candidate Weight Delta: " + this.weightDelta);
            log.info(doc.activationsToString(true, false) + "\n");
        }
    }

    private boolean isModified() {
        for (Activation.StateChange sc : this.modifiedActs.values()) {
            if (sc.getActivation().markedDirty > this.visited || sc.newState != sc.getActivation().key.interpretation.state) {
                return true;
            }
            if (!sc.newRounds.isActive()) continue;
            for (Activation.SynapseActivation sa : sc.getActivation().neuronOutputs) {
                if (sa.output.key.interpretation.state == InterpretationNode.State.UNKNOWN || sa.output.markedDirty <= this.visited) continue;
                return true;
            }
        }
        return false;
    }

    private void markDirty() {
        if (this.candidate == null) {
            return;
        }
        SearchNode csn = this.candidate.cachedSearchNodes;
        TreeSet<Activation> acts = new TreeSet<Activation>(Activation.ACTIVATION_ID_COMP);
        acts.addAll(this.modifiedActs.keySet());
        if (csn != null) {
            acts.addAll(csn.modifiedActs.keySet());
        }
        acts.forEach(act -> {
            Activation.StateChange scb;
            Activation.StateChange sca = this.modifiedActs.get(act);
            Activation.StateChange stateChange = scb = csn != null ? searchNode.modifiedActs.get(act) : null;
            if (sca == null || scb == null || !sca.newRounds.compare(scb.newRounds)) {
                for (Activation.SynapseActivation sa : act.neuronOutputs) {
                    sa.output.markDirty(this.visited);
                }
            }
        });
    }

    public boolean compareNewState(SearchNode cachedNode) {
        if (this.modifiedActs == null && cachedNode.modifiedActs == null) {
            return true;
        }
        if (this.modifiedActs == null || cachedNode.modifiedActs == null) {
            return false;
        }
        if (this.modifiedActs.size() != cachedNode.modifiedActs.size()) {
            return false;
        }
        for (Map.Entry<Activation, Activation.StateChange> me : this.modifiedActs.entrySet()) {
            Activation.StateChange sca = me.getValue();
            Activation.StateChange scb = cachedNode.modifiedActs.get(me.getKey());
            if (sca.newRounds.compare(scb.newRounds)) continue;
            return false;
        }
        return true;
    }

    public void collectResults(Collection<InterpretationNode> results) {
        SearchNode sn = this;
        do {
            if (sn.candidate == null) continue;
            results.add(sn.candidate.refinement);
        } while ((sn = sn.selectedParent) != null);
    }

    public void reconstructSelectedResult(Document doc) {
        LinkedList<SearchNode> tmp = new LinkedList<SearchNode>();
        SearchNode snt = this;
        do {
            tmp.addFirst(snt);
        } while ((snt = snt.getParent()) != null);
        for (SearchNode sn : tmp) {
            sn.changeState(Activation.Mode.NEW);
            SearchNode pn = sn.getParent();
            if (pn != null && pn.candidate != null) {
                pn.candidate.refinement.setState(sn.getDecision() ? InterpretationNode.State.SELECTED : InterpretationNode.State.EXCLUDED, sn.visited);
            }
            for (Activation.StateChange sc : sn.modifiedActs.values()) {
                Activation act = sc.getActivation();
                if (!act.isFinalActivation()) continue;
                doc.finallyActivatedNeurons.add(act.getINeuron());
            }
        }
    }

    public void dumpDebugState() {
        for (SearchNode n = this; n != null && n.level >= 0; n = n.getParent()) {
            log.info(n.level + " " + (Object)((Object)n.debugState) + " DECISION:" + n.getDecision() + " " + n.candidate != null ? n.candidate.toString() : " MOD-ACTS:" + n.modifiedActs.size());
        }
    }

    public Weight searchRecursive(Document doc) {
        if (this.candidate == null) {
            return this.processResult(doc);
        }
        this.initStep(doc);
        if (this.prepareSelectStep(doc)) {
            this.selectedWeight = this.selectedChild.searchRecursive(doc);
            this.postReturn(this.selectedChild);
        }
        if (this.prepareExcludeStep(doc)) {
            this.excludedWeight = this.excludedChild.searchRecursive(doc);
            this.postReturn(this.excludedChild);
        }
        return this.finalStep();
    }

    public static void searchIterative(Document doc, SearchNode root) {
        SearchNode sn = root;
        Weight returnWeight = null;
        do {
            switch (sn.step) {
                case INIT: {
                    if (sn.candidate == null) {
                        returnWeight = sn.processResult(doc);
                        sn.step = Step.FINAL;
                        sn = sn.getParent();
                        break;
                    }
                    sn.initStep(doc);
                    sn.step = Step.PREPARE_SELECT;
                    break;
                }
                case PREPARE_SELECT: {
                    sn.step = sn.prepareSelectStep(doc) ? Step.SELECT : Step.PREPARE_EXCLUDE;
                    break;
                }
                case SELECT: {
                    sn.step = Step.POST_SELECT;
                    sn = sn.selectedChild;
                    break;
                }
                case POST_SELECT: {
                    sn.selectedWeight = returnWeight;
                    sn.postReturn(sn.selectedChild);
                    sn.step = Step.PREPARE_EXCLUDE;
                    break;
                }
                case PREPARE_EXCLUDE: {
                    sn.step = sn.prepareExcludeStep(doc) ? Step.EXCLUDE : Step.FINAL;
                    break;
                }
                case EXCLUDE: {
                    sn.step = Step.POST_EXCLUDE;
                    sn = sn.excludedChild;
                    break;
                }
                case POST_EXCLUDE: {
                    sn.excludedWeight = returnWeight;
                    sn.postReturn(sn.excludedChild);
                    sn.step = Step.FINAL;
                    break;
                }
                case FINAL: {
                    returnWeight = sn.finalStep();
                    sn = sn.getParent();
                    break;
                }
            }
        } while (sn.level >= root.level);
    }

    private void initStep(Document doc) {
        boolean precondition = this.checkPrecondition();
        this.alreadySelected = precondition && !this.candidate.isConflicting();
        boolean bl = this.alreadyExcluded = !precondition || this.checkExcluded(this.candidate.refinement, doc.visitedCounter++);
        if (doc.searchStepCounter > MAX_SEARCH_STEPS) {
            this.dumpDebugState();
            throw new RuntimeException("Max search step exceeded.");
        }
        ++doc.searchStepCounter;
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info("Search Step: " + this.id);
            log.info(this.toString());
        }
        if (Document.OPTIMIZE_DEBUG_OUTPUT) {
            log.info(doc.activationsToString(true, false) + "\n");
        }
        this.debugState = this.alreadyExcluded || this.alreadySelected ? DebugState.LIMITED : (this.getCachedDecision() != null ? DebugState.CACHED : DebugState.EXPLORE);
        int n = this.debugState.ordinal();
        this.candidate.debugCounts[n] = this.candidate.debugCounts[n] + 1;
    }

    private Boolean getCachedDecision() {
        return !this.alreadyExcluded ? this.candidate.cachedDecision : null;
    }

    private boolean prepareSelectStep(Document doc) {
        if (this.alreadyExcluded || this.getCachedDecision() != null && !this.getCachedDecision().booleanValue()) {
            return false;
        }
        this.candidate.refinement.setState(InterpretationNode.State.SELECTED, this.visited);
        if (this.candidate.cachedDecision == null) {
            this.invalidateCachedDecisions(doc.visitedCounter++);
        }
        Candidate c = doc.candidates.size() > this.level + 1 ? doc.candidates.get(this.level + 1) : null;
        this.selectedChild = new SearchNode(doc, this, this.excludedParent, c, this.level + 1);
        this.candidate.debugDecisionCounts[0] = this.candidate.debugDecisionCounts[0] + 1;
        return true;
    }

    private boolean prepareExcludeStep(Document doc) {
        if (this.alreadySelected || this.getCachedDecision() != null && this.getCachedDecision().booleanValue()) {
            return false;
        }
        this.candidate.refinement.setState(InterpretationNode.State.EXCLUDED, this.visited);
        Candidate c = doc.candidates.size() > this.level + 1 ? doc.candidates.get(this.level + 1) : null;
        this.excludedChild = new SearchNode(doc, this.selectedParent, this, c, this.level + 1);
        this.candidate.debugDecisionCounts[1] = this.candidate.debugDecisionCounts[1] + 1;
        return true;
    }

    private void postReturn(SearchNode child) {
        child.changeState(Activation.Mode.OLD);
        this.candidate.refinement.setState(InterpretationNode.State.UNKNOWN, this.visited);
        this.candidate.refinement.activation.rounds.reset();
    }

    private Weight finalStep() {
        Weight result;
        if (this.getCachedDecision() == null) {
            boolean dir = this.selectedWeight.getNormWeight() >= this.excludedWeight.getNormWeight();
            boolean bl = dir = this.alreadySelected || !this.alreadyExcluded && dir;
            if (!this.alreadyExcluded) {
                this.candidate.cachedDecision = dir;
            }
            result = dir ? this.selectedWeight : this.excludedWeight;
        } else {
            result = this.getCachedDecision() != false ? this.selectedWeight : this.excludedWeight;
        }
        this.selectedChild = null;
        this.excludedChild = null;
        return result;
    }

    private boolean checkPrecondition() {
        Set<InterpretationNode> soin = this.candidate.refinement.selectedOrInterpretationNodes;
        return soin != null && !soin.isEmpty();
    }

    private void invalidateCachedDecisions(long v) {
        for (Activation.SynapseActivation sa : this.candidate.refinement.activation.neuronOutputs) {
            if (sa.synapse.isNegative()) continue;
            Candidate posCand = sa.output.key.interpretation.candidate;
            if (posCand != null && posCand.cachedDecision == Boolean.FALSE && this.candidate.id > posCand.id) {
                posCand.cachedDecision = null;
            }
            ArrayList<InterpretationNode> conflicting = new ArrayList<InterpretationNode>();
            Conflicts.collectConflicting(conflicting, sa.output.key.interpretation, v);
            for (InterpretationNode c : conflicting) {
                Candidate negCand = c.candidate;
                if (negCand == null || negCand.cachedDecision != Boolean.TRUE || this.candidate.id <= negCand.id) continue;
                negCand.cachedDecision = null;
            }
        }
    }

    private Weight processResult(Document doc) {
        double accNW = this.accumulatedWeight.getNormWeight();
        if (accNW > this.getSelectedAccumulatedWeight(doc)) {
            doc.selectedSearchNode = this;
        }
        return this.accumulatedWeight;
    }

    private double getSelectedAccumulatedWeight(Document doc) {
        return doc.selectedSearchNode != null ? doc.selectedSearchNode.accumulatedWeight.getNormWeight() : -1.0;
    }

    private boolean checkExcluded(InterpretationNode ref, long v) {
        ArrayList<InterpretationNode> conflicts = new ArrayList<InterpretationNode>();
        Conflicts.collectConflicting(conflicts, ref, v);
        for (InterpretationNode cn : conflicts) {
            if (cn.state != InterpretationNode.State.SELECTED) continue;
            return true;
        }
        return false;
    }

    public String pathToString(Document doc) {
        return (this.selectedParent != null ? this.selectedParent.pathToString(doc) : "") + " - " + this.toString(doc);
    }

    public String toString(Document doc) {
        TreeSet<InterpretationNode> tmp = new TreeSet<InterpretationNode>();
        this.candidate.refinement.collectPrimitiveNodes(tmp, doc.interpretationIdCounter++);
        StringBuilder sb = new StringBuilder();
        for (InterpretationNode n : tmp) {
            sb.append(n.primId);
            sb.append(" Decision:" + this.getDecision());
            sb.append(", ");
        }
        return sb.toString();
    }

    public void changeState(Activation.Mode m) {
        for (Activation.StateChange sc : this.modifiedActs.values()) {
            sc.restoreState(m);
        }
    }

    @Override
    public int compareTo(SearchNode sn) {
        return Integer.compare(this.id, sn.id);
    }

    public SearchNode getParent() {
        return this.getDecision() ? this.selectedParent : this.excludedParent;
    }

    public boolean getDecision() {
        return this.excludedParent == null || this.selectedParent.id > this.excludedParent.id;
    }

    public static class Weight {
        public static final Weight ZERO = new Weight(0.0, 0.0);
        public final double w;
        public final double n;

        private Weight(double w, double n) {
            this.w = w;
            this.n = n;
        }

        public static Weight create(double w, double n) {
            assert (w >= 0.0 && n >= 0.0);
            if (w == 0.0 && n == 0.0) {
                return ZERO;
            }
            return new Weight(w, n);
        }

        public Weight add(Weight nw) {
            if (nw == null || nw == ZERO) {
                return this;
            }
            return new Weight(this.w + nw.w, this.n + nw.n);
        }

        public Weight sub(Weight nw) {
            if (nw == null || nw == ZERO) {
                return this;
            }
            return new Weight(this.w - nw.w, this.n - nw.n);
        }

        public double getNormWeight() {
            return this.n > 0.0 ? this.w / this.n : 0.0;
        }

        public boolean equals(Weight nw) {
            return Math.abs(this.w - nw.w) <= INeuron.WEIGHT_TOLERANCE && Math.abs(this.n - nw.n) <= INeuron.WEIGHT_TOLERANCE;
        }

        public String toString() {
            return "W:" + Utils.round(this.w) + " N:" + Utils.round(this.n);
        }
    }

    static enum Step {
        INIT,
        PREPARE_SELECT,
        SELECT,
        POST_SELECT,
        PREPARE_EXCLUDE,
        EXCLUDE,
        POST_EXCLUDE,
        FINAL;

    }

    public static enum DebugState {
        CACHED,
        LIMITED,
        EXPLORE;

    }
}

