/*
 * Decompiled with CFR 0.152.
 */
package org.aika.lattice;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.AbstractNode;
import org.aika.Model;
import org.aika.Provider;
import org.aika.Utils;
import org.aika.Writable;
import org.aika.corpus.Document;
import org.aika.corpus.InterpretationNode;
import org.aika.corpus.Range;
import org.aika.lattice.AndNode;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.aika.neuron.Neuron;
import org.aika.training.PatternDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrNode
extends Node<OrNode, Activation> {
    private static final Logger log = LoggerFactory.getLogger(OrNode.class);
    public TreeMap<Integer, TreeSet<Provider<Node>>> parents = new TreeMap();
    public TreeMap<Integer, TreeSet<Provider<Node>>> allParents = new TreeMap();
    public Neuron neuron = null;
    public Node requiredNode;

    public OrNode() {
    }

    public OrNode(Model m) {
        super(m, -1);
    }

    @Override
    public Activation createActivation(Document doc, NodeActivation.Key ak) {
        Activation act;
        ak.interpretation.activation = act = new Activation(doc.activationIdCounter++, doc, ak);
        return act;
    }

    public void addActivation(Document doc, Integer ridOffset, NodeActivation inputAct) {
        if (this.checkSelfReferencing(doc, inputAct)) {
            return;
        }
        NodeActivation.Key ak = inputAct.key;
        Range r = ak.range;
        Integer rid = Utils.nullSafeSub(ak.rid, true, ridOffset, false);
        if (((INeuron)this.neuron.get((Document)doc)).outputText != null) {
            int begin = r.begin != Integer.MIN_VALUE ? r.begin : 0;
            int end = r.end != Integer.MAX_VALUE ? r.end : begin + ((INeuron)this.neuron.get((Document)doc)).outputText.length();
            r = new Range(begin, end);
        }
        if (r.begin == Integer.MIN_VALUE || r.end == Integer.MAX_VALUE) {
            return;
        }
        InterpretationNode no = this.lookupOrOption(doc, r, true);
        OrNode.addActivation(doc, new NodeActivation.Key<OrNode>(this, r, rid, no), Collections.singleton(inputAct));
    }

    private boolean checkSelfReferencing(Document doc, NodeActivation inputAct) {
        InterpretationNode o = this.lookupOrOption(doc, inputAct.key.range, false);
        if (o == null) {
            return false;
        }
        return inputAct.key.interpretation.contains(o, true);
    }

    @Override
    public void propagate(Activation act) {
        act.doc.ubQueue.add(act);
    }

    @Override
    Activation processActivation(Document doc, NodeActivation.Key<OrNode> ak, Collection<NodeActivation> inputActs) {
        Activation act;
        if (Document.APPLY_DEBUG_OUTPUT) {
            log.info("add: " + ak + " - " + ak.node);
        }
        if ((act = Activation.get(doc, (INeuron)this.neuron.get(), ak)) == null) {
            act = this.createActivation(doc, ak);
            this.register(act);
            this.propagate(act);
        }
        act.link(inputActs);
        for (NodeActivation iAct : inputActs) {
            act.key.interpretation.addOrInterpretationNode(iAct.key.interpretation);
        }
        ((INeuron)this.neuron.get(doc)).register(act);
        return act;
    }

    @Override
    public double computeSynapseWeightSum(Integer offset, INeuron n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void apply(Activation act) {
        OrNode.processCandidate(this, act, false);
    }

    @Override
    public void discover(NodeActivation act, PatternDiscovery.Config config) {
    }

    public static void processCandidate(Node<?, ? extends NodeActivation<?>> parentNode, NodeActivation inputAct, boolean train) {
        NodeActivation.Key ak = inputAct.key;
        Document doc = inputAct.doc;
        parentNode.lock.acquireReadLock();
        if (parentNode.orChildren != null) {
            for (OrEntry oe : parentNode.orChildren) {
                if (ak.interpretation.isConflicting(doc.visitedCounter++)) continue;
                oe.node.get(doc).addActivation(doc, oe.ridOffset, inputAct);
            }
        }
        parentNode.lock.releaseReadLock();
    }

    public InterpretationNode lookupOrOption(Document doc, Range r, boolean create) {
        Activation act = Activation.select(doc, (INeuron)this.neuron.get(), null, r, Range.Relation.EQUALS, null, null).findFirst().orElse(null);
        if (act != null) {
            return act.key.interpretation;
        }
        Node.ThreadState th = this.getThreadState(doc.threadId, false);
        if (th != null) {
            for (NodeActivation.Key ak : th.added.keySet()) {
                if (Range.compare(ak.range, r) != 0) continue;
                return ak.interpretation;
            }
        }
        return create ? InterpretationNode.addPrimitive(doc) : null;
    }

    Set<AndNode.Refinement> collectNodeAndRefinements(AndNode.Refinement newRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reprocessInputs(Document doc) {
        for (TreeSet<Provider<Node>> ppSet : this.parents.values()) {
            for (Provider<Node> pp : ppSet) {
                Node pn = pp.get();
                for (NodeActivation act : pn.getActivations(doc)) {
                    act.repropagateV = this.markedCreated;
                    ((AbstractNode)act.key.node).propagate((NodeActivation)act);
                }
            }
        }
    }

    public void addInput(Integer ridOffset, int threadId, Node in, boolean all) {
        Model cfr_ignored_0 = this.provider.model;
        in.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), 1);
        in.lock.acquireWriteLock();
        in.addOrChild(new OrEntry(ridOffset, this.provider), all);
        in.setModified();
        in.lock.releaseWriteLock();
        this.lock.acquireWriteLock();
        this.setModified();
        Integer key = ridOffset != null ? ridOffset : Integer.MIN_VALUE;
        TreeMap<Integer, TreeSet<Provider<Node>>> p = all ? this.allParents : this.parents;
        TreeSet pn = p.get(key);
        if (pn == null) {
            pn = new TreeSet();
            p.put(key, pn);
        }
        pn.add(in.provider);
        this.lock.releaseWriteLock();
    }

    public void removeInput(Integer ridOffset, int threadId, Node in, boolean all) {
        Model cfr_ignored_0 = this.provider.model;
        in.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), -1);
        in.removeOrChild(new OrEntry(ridOffset, this.provider), all);
        in.setModified();
        this.lock.acquireWriteLock();
        this.setModified();
        Integer key = ridOffset != null ? ridOffset : Integer.MIN_VALUE;
        TreeMap<Integer, TreeSet<Provider<Node>>> p = all ? this.allParents : this.parents;
        TreeSet<Provider<Node>> pn = p.get(key);
        if (pn != null) {
            pn.remove(in.provider);
            if (pn.isEmpty() && ridOffset != null) {
                p.remove(key);
            }
        }
        this.lock.releaseWriteLock();
    }

    void remove(int threadId) {
        ((INeuron)this.neuron.get()).remove();
        super.remove();
        this.lock.acquireReadLock();
        this.removeParents(threadId, true);
        this.removeParents(threadId, false);
        this.lock.releaseReadLock();
    }

    public void removeParents(int threadId, boolean all) {
        for (Map.Entry<Integer, TreeSet<Provider<Node>>> me : (all ? this.allParents : this.parents).entrySet()) {
            for (Provider<Node> p : me.getValue()) {
                Node pn = p.get();
                Model cfr_ignored_0 = this.provider.model;
                pn.changeNumberOfNeuronRefs(threadId, Model.visitedCounter.addAndGet(1L), -1);
                pn.removeOrChild(new OrEntry(me.getKey() != Integer.MIN_VALUE ? me.getKey() : null, this.provider), all);
                pn.setModified();
            }
        }
        (all ? this.allParents : this.parents).clear();
    }

    @Override
    boolean contains(AndNode.Refinement ref) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeNumberOfNeuronRefs(int threadId, long v, int d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String logicToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OR[");
        boolean first = true;
        int i = 0;
        block0: for (Map.Entry<Integer, TreeSet<Provider<Node>>> me : this.parents.entrySet()) {
            for (Provider<Node> pn : me.getValue()) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(me.getKey() != Integer.MIN_VALUE ? me.getKey() : "X");
                sb.append(":");
                sb.append(pn.get().logicToString());
                if (i > 2) {
                    sb.append(",...");
                    continue block0;
                }
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(false);
        out.writeChar(79);
        super.write(out);
        out.writeInt(this.neuron.id);
        out.writeInt(this.parents.size());
        for (Map.Entry<Integer, TreeSet<Provider<Node>>> me : this.parents.entrySet()) {
            out.writeInt(me.getKey());
            out.writeInt(me.getValue().size());
            for (Provider<Node> pn : me.getValue()) {
                out.writeInt(pn.id);
            }
        }
    }

    @Override
    public void readFields(DataInput in, Model m) throws IOException {
        super.readFields(in, m);
        this.neuron = m.lookupNeuron(in.readInt());
        int s = in.readInt();
        for (int i = 0; i < s; ++i) {
            TreeSet ridParents = new TreeSet();
            Integer ridOffset = in.readInt();
            this.parents.put(ridOffset, ridParents);
            int sa = in.readInt();
            for (int j = 0; j < sa; ++j) {
                ridParents.add(m.lookupNodeProvider(in.readInt()));
            }
        }
    }

    @Override
    public String getNeuronLabel() {
        String l = this.neuron.getLabel();
        return l != null ? l : "";
    }

    static class OrEntry
    implements Comparable<OrEntry>,
    Writable {
        public Integer ridOffset;
        public Provider<OrNode> node;

        private OrEntry() {
        }

        public OrEntry(Integer ridOffset, Provider<OrNode> node) {
            this.ridOffset = ridOffset;
            this.node = node;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.ridOffset != null);
            if (this.ridOffset != null) {
                out.writeInt(this.ridOffset);
            }
            out.writeInt(this.node.id);
        }

        @Override
        public void readFields(DataInput in, Model m) throws IOException {
            if (in.readBoolean()) {
                this.ridOffset = in.readInt();
            }
            this.node = m.lookupNodeProvider(in.readInt());
        }

        public static OrEntry read(DataInput in, Model m) throws IOException {
            OrEntry n = new OrEntry();
            n.readFields(in, m);
            return n;
        }

        @Override
        public int compareTo(OrEntry on) {
            int r = Utils.compareInteger(this.ridOffset, on.ridOffset);
            if (r != 0) {
                return r;
            }
            return this.node.compareTo(on.node);
        }
    }
}

