/*
 * Decompiled with CFR 0.152.
 */
package org.aika.neuron;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aika.ActivationFunction;
import org.aika.Model;
import org.aika.Provider;
import org.aika.ReadWriteLock;
import org.aika.corpus.Document;
import org.aika.lattice.InputNode;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;

public class Neuron
extends Provider<INeuron> {
    public ReadWriteLock lock = new ReadWriteLock();
    public NavigableMap<Synapse, Synapse> inMemoryInputSynapses = new TreeMap<Synapse, Synapse>(Synapse.INPUT_SYNAPSE_COMP);
    public NavigableMap<Synapse, Synapse> inMemoryOutputSynapses = new TreeMap<Synapse, Synapse>(Synapse.OUTPUT_SYNAPSE_COMP);

    public Neuron(Model m, int id) {
        super(m, id);
    }

    public Neuron(Model m, INeuron n) {
        super(m, n);
    }

    public String getLabel() {
        return ((INeuron)this.get()).label;
    }

    public Activation addInput(Document doc, int begin, int end) {
        return this.addInput(doc, begin, end, null);
    }

    public Activation addInput(Document doc, int begin, int end, Integer relationalId) {
        return this.addInput(doc, new Activation.Builder().setRange(begin, end).setRelationalId(relationalId));
    }

    public Activation addInput(Document doc, Activation.Builder inputAct) {
        return ((INeuron)this.get(doc)).addInput(doc, inputAct);
    }

    public static Neuron init(Neuron n, double bias, INeuron.Type type, Synapse.Builder ... inputs) {
        return Neuron.init(n, bias, type, new TreeSet<Synapse.Builder>(Arrays.asList(inputs)));
    }

    public static Neuron init(Document doc, Neuron n, double bias, INeuron.Type type, Synapse.Builder ... inputs) {
        return Neuron.init(doc, n, bias, null, type, new TreeSet<Synapse.Builder>(Arrays.asList(inputs)));
    }

    public static Neuron init(Neuron n, double bias, String activationFunctionKey, INeuron.Type type, Synapse.Builder ... inputs) {
        return Neuron.init(n, bias, activationFunctionKey, type, new TreeSet<Synapse.Builder>(Arrays.asList(inputs)));
    }

    public static Neuron init(Document doc, Neuron n, double bias, String activationFunctionKey, INeuron.Type type, Synapse.Builder ... inputs) {
        return Neuron.init(doc, n, bias, activationFunctionKey, type, new TreeSet<Synapse.Builder>(Arrays.asList(inputs)));
    }

    public static Neuron init(Neuron n, double bias, INeuron.Type type, Collection<Synapse.Builder> inputs) {
        return Neuron.init(n, bias, null, type, inputs);
    }

    public static Neuron init(Neuron n, double bias, String activationFunctionKey, INeuron.Type type, Collection<Synapse.Builder> inputs) {
        if (n.init(bias, activationFunctionKey, type, inputs)) {
            return n;
        }
        return null;
    }

    public static Neuron init(Document doc, Neuron n, double bias, String activationFunctionKey, INeuron.Type type, Collection<Synapse.Builder> inputs) {
        if (n.init(doc, bias, activationFunctionKey, type, inputs)) {
            return n;
        }
        return null;
    }

    public boolean init(double bias, String activationFunctionKey, INeuron.Type type, Collection<Synapse.Builder> inputs) {
        return this.init(null, bias, activationFunctionKey, type, inputs);
    }

    public boolean init(Document doc, double bias, String activationFunctionKey, INeuron.Type type, Collection<Synapse.Builder> inputs) {
        ArrayList<Synapse> is = new ArrayList<Synapse>();
        for (Synapse.Builder input : inputs) {
            Synapse s = input.getSynapse(this);
            s.weightDelta = input.weight;
            s.setBias(input.bias);
            is.add(s);
        }
        if (activationFunctionKey != null) {
            ActivationFunction af = this.model.activationFunctions.get(activationFunctionKey);
            INeuron in = (INeuron)this.get();
            in.activationFunction = af;
            in.activationFunctionKey = activationFunctionKey;
        }
        if (type != null) {
            INeuron in = (INeuron)this.get();
            in.type = type;
        }
        return INeuron.update(this.model, this.model.defaultThreadId, doc, this, bias, is);
    }

    public void addSynapse(Synapse.Builder input) {
        this.addSynapse(null, input);
    }

    public void addSynapse(Document doc, Synapse.Builder input) {
        Synapse s = input.getSynapse(this);
        s.weightDelta = input.weight;
        s.setBias(input.bias);
        INeuron.update(this.model, doc != null ? doc.threadId : this.model.defaultThreadId, doc, this, 0.0, Collections.singletonList(s));
    }

    public Collection<Activation> getFinalActivations(Document doc) {
        INeuron n = (INeuron)this.getIfNotSuspended();
        if (n == null) {
            return Collections.emptyList();
        }
        return n.getFinalActivations(doc);
    }

    public void addInMemoryInputSynapse(Synapse s) {
        InputNode iNode;
        this.lock.acquireWriteLock();
        this.inMemoryInputSynapses.put(s, s);
        this.lock.releaseWriteLock();
        if (!s.input.isSuspended() && (iNode = s.inputNode.get()) != null) {
            iNode.setSynapse(s);
        }
    }

    public void removeInMemoryInputSynapse(Synapse s) {
        InputNode iNode;
        this.lock.acquireWriteLock();
        this.inMemoryInputSynapses.remove(s);
        this.lock.releaseWriteLock();
        if (!s.input.isSuspended() && (iNode = s.inputNode.getIfNotSuspended()) != null) {
            iNode.removeSynapse(s);
        }
    }

    public void addInMemoryOutputSynapse(Synapse s) {
        InputNode iNode;
        this.lock.acquireWriteLock();
        this.inMemoryOutputSynapses.put(s, s);
        this.lock.releaseWriteLock();
        if (!s.output.isSuspended() && (iNode = s.inputNode.get()) != null) {
            iNode.setSynapse(s);
        }
    }

    public void removeInMemoryOutputSynapse(Synapse s) {
        InputNode iNode;
        this.lock.acquireWriteLock();
        this.inMemoryOutputSynapses.remove(s);
        this.lock.releaseWriteLock();
        if (!s.output.isSuspended() && (iNode = s.inputNode.getIfNotSuspended()) != null) {
            iNode.setSynapse(s);
        }
    }
}

