/*
 * Decompiled with CFR 0.152.
 */
package org.aika.training;

import org.aika.corpus.Document;
import org.aika.neuron.Activation;
import org.aika.neuron.INeuron;

public class InterprSupprTraining {
    public static void train(Document doc, Config config) {
        for (INeuron n : doc.activatedNeurons) {
            for (Activation act : n.getActivations(doc)) {
                if (act.isFinalActivation() || !(act.upperBound > 0.0) || n.type == INeuron.Type.META) continue;
                act.errorSignal += config.learnRate * act.upperBound;
            }
        }
    }

    public static class Config {
        public double learnRate;

        public Config setLearnRate(double learnRate) {
            this.learnRate = learnRate;
            return this;
        }
    }
}

