/*
 * Decompiled with CFR 0.152.
 */
package org.aika.training;

import org.aika.neuron.Activation;
import org.aika.neuron.Synapse;

public interface SynapseEvaluation {
    public Result evaluate(Synapse var1, Activation var2, Activation var3);

    public static class Result {
        public Synapse.Key synapseKey;
        public double significance;
        public DeleteMode deleteMode;

        public Result(Synapse.Key synapseKey, double significance, DeleteMode deleteMode) {
            this.synapseKey = synapseKey;
            this.significance = significance;
            this.deleteMode = deleteMode;
        }
    }

    public static enum DeleteMode {
        NONE,
        DELETE,
        DELETE_IF_SIGN_CHANGES,
        DELETE_NEGATIVES,
        DELETE_POSITIVES;


        public void checkIfDelete(Synapse s) {
            double ow = s.weight;
            double nw = s.getNewWeight();
            switch (this) {
                case DELETE: {
                    s.toBeDeleted = true;
                    break;
                }
                case DELETE_IF_SIGN_CHANGES: {
                    if (nw != 0.0 && (ow == 0.0 || nw > 0.0 == ow > 0.0)) break;
                    s.toBeDeleted = true;
                    break;
                }
                case DELETE_NEGATIVES: {
                    if (!(nw <= 0.0)) break;
                    s.toBeDeleted = true;
                    break;
                }
                case DELETE_POSITIVES: {
                    if (!(nw >= 0.0)) break;
                    s.toBeDeleted = true;
                }
            }
        }
    }
}

