/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aika.AbstractNode;
import org.aika.Converter;
import org.aika.Model;
import org.aika.Provider;
import org.aika.Utils;
import org.aika.lattice.Node;
import org.aika.lattice.NodeActivation;
import org.aika.neuron.INeuron;
import org.aika.neuron.Synapse;
import org.aika.neuron.activation.Activation;
import org.aika.neuron.activation.Candidate;
import org.aika.neuron.activation.Range;
import org.aika.neuron.activation.SearchNode;
import org.aika.neuron.activation.Selector;
import org.aika.training.SupervisedTraining;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Document
implements Comparable<Document> {
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    public static int CLEANUP_INTERVAL = 500;
    public static int MAX_ROUND = 20;
    public static boolean INCREMENTAL_MODE = false;
    public final int id;
    private final String content;
    public long visitedCounter = 1L;
    public int activationIdCounter = 0;
    public int searchNodeIdCounter = 0;
    public int searchStepCounter = 0;
    public Model model;
    public int threadId;
    public Queue queue = new Queue();
    public ValueQueue vQueue = new ValueQueue();
    public UpperBoundQueue ubQueue = new UpperBoundQueue();
    public TreeSet<Node> activatedNodes = new TreeSet();
    public TreeSet<INeuron> activatedNeurons = new TreeSet();
    public TreeSet<INeuron> finallyActivatedNeurons = new TreeSet();
    public TreeSet<Activation> inputNeuronActivations = new TreeSet();
    public TreeMap<INeuron, Set<Synapse>> modifiedWeights = new TreeMap();
    public SupervisedTraining supervisedTraining = new SupervisedTraining(this);
    public TreeMap<NodeActivation.Key, Activation> activationsByRangeBegin = new TreeMap((ak1, ak2) -> {
        int r = Integer.compare(ak1.range.begin, ak2.range.begin);
        if (r != 0) {
            return r;
        }
        return ak1.compareTo((NodeActivation.Key)ak2);
    });
    public TreeMap<NodeActivation.Key, Activation> activationsByRangeEnd = new TreeMap((ak1, ak2) -> {
        int r = Integer.compare(ak1.range.end, ak2.range.end);
        if (r != 0) {
            return r;
        }
        return ak1.compareTo((NodeActivation.Key)ak2);
    });
    public TreeMap<NodeActivation.Key, Activation> activationsByRid = new TreeMap((ak1, ak2) -> {
        int r = Integer.compare(ak1.rid, ak2.rid);
        if (r != 0) {
            return r;
        }
        return ak1.compareTo((NodeActivation.Key)ak2);
    });
    public TreeSet<Node> addedNodes = new TreeSet();
    public ArrayList<NodeActivation> addedNodeActivations = new ArrayList();
    public ArrayList<Activation> addedActivations = new ArrayList();
    public SearchNode selectedSearchNode;
    public ArrayList<Candidate> candidates = new ArrayList();
    public long createV;
    public static Comparator<NodeActivation> ACTIVATIONS_OUTPUT_COMPARATOR = (act1, act2) -> {
        int r = Range.compare(act1.key.range, act2.key.range, false);
        if (r != 0) {
            return r;
        }
        r = Utils.compareInteger(act1.key.rid, act2.key.rid);
        if (r != 0) {
            return r;
        }
        return ((Node)act1.key.node).compareTo((Node)act2.key.node);
    };
    private static Comparator<Activation> VALUE_QUEUE_COMP = (a, b) -> {
        int r = Integer.compare(a.getSequence(), b.getSequence());
        if (r != 0) {
            return r;
        }
        return Integer.compare(a.id, b.id);
    };

    public Document(int id, String content, Model model, int threadId) {
        this.id = id;
        this.content = content;
        this.model = model;
        this.threadId = threadId;
    }

    public String getContent() {
        return this.content;
    }

    public int length() {
        return this.content.length();
    }

    public String toString() {
        return this.content;
    }

    public String getText(Range r) {
        return this.content.substring(Math.max(0, Math.min(r.begin, this.length())), Math.max(0, Math.min(r.end, this.length())));
    }

    public Stream<Activation> getFinalActivations() {
        return this.finallyActivatedNeurons.stream().flatMap(in -> in.getFinalActivationsStream(this));
    }

    public Stream<Activation> getActivations() {
        return this.activatedNeurons.stream().flatMap(in -> in.getActivations(this).stream());
    }

    @Override
    public int compareTo(Document doc) {
        return Integer.compare(this.id, doc.id);
    }

    public void propagate() {
        for (Node n : this.addedNodes) {
            n.reprocessInputs(this);
        }
        this.addedNodes.clear();
        boolean flag = true;
        while (flag) {
            this.queue.processChanges();
            flag = this.ubQueue.process();
        }
    }

    public void generateCandidates() {
        TreeSet<Candidate> tmp = new TreeSet<Candidate>();
        int i = 0;
        if (!INCREMENTAL_MODE) {
            this.candidates.clear();
        }
        for (Activation act : INCREMENTAL_MODE ? this.addedActivations : this.activationsByRangeBegin.values()) {
            if (act.decision != SearchNode.Decision.UNKNOWN || !(act.upperBound > 0.0)) continue;
            SearchNode.invalidateCachedDecision(act);
            tmp.add(new Candidate(act, i++));
        }
        long v = this.visitedCounter++;
        for (Activation act : this.inputNeuronActivations) {
            act.markedHasCandidate = v;
        }
        while (!tmp.isEmpty()) {
            int oldSize = tmp.size();
            for (Candidate c : tmp) {
                if (!c.checkDependenciesSatisfied(v)) continue;
                tmp.remove(c);
                c.id = this.candidates.size();
                this.candidates.add(c);
                c.activation.markedHasCandidate = v;
                break;
            }
            if (tmp.size() != oldSize) continue;
            log.error("Cycle detected in the activations that is not marked recurrent.");
            throw new RuntimeException("Cycle detected in the activations that is not marked recurrent.");
        }
    }

    public void process() {
        this.process(null);
    }

    public void process(Long timeoutInMilliSeconds) throws SearchNode.TimeoutException {
        this.inputNeuronActivations.forEach(act -> this.vQueue.propagateActivationValue(0, (Activation)act));
        this.generateCandidates();
        this.addedActivations.clear();
        if (this.selectedSearchNode == null || !INCREMENTAL_MODE) {
            this.selectedSearchNode = new SearchNode(this, null, null, 0);
        }
        SearchNode.search(this, this.selectedSearchNode, this.visitedCounter++, timeoutInMilliSeconds);
        for (Activation act2 : this.activationsByRangeBegin.values()) {
            if (!act2.isFinalActivation()) continue;
            this.finallyActivatedNeurons.add(act2.getINeuron());
        }
    }

    public void dumpDebugCandidateStatistics() {
        for (Candidate c : this.candidates) {
            log.info(c.toString());
        }
    }

    public void notifyWeightModified(Synapse synapse) {
        Set<Synapse> is = this.modifiedWeights.get(synapse.output.get());
        if (is == null) {
            is = new TreeSet<Synapse>(Synapse.INPUT_SYNAPSE_COMP);
            this.modifiedWeights.put((INeuron)synapse.output.get(), is);
        }
        is.add(synapse);
    }

    public void commit() {
        this.modifiedWeights.forEach((n, inputSyns) -> Converter.convert(this.model, this.threadId, this, n, inputSyns));
        this.modifiedWeights.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActivations() {
        this.activatedNeurons.forEach(n -> n.clearActivations(this));
        this.activatedNodes.forEach(n -> n.clearActivations(this));
        this.addedActivations.clear();
        this.addedNodeActivations.clear();
        this.activatedNeurons.clear();
        this.activatedNodes.clear();
        this.addedNodes.clear();
        if (this.model.lastCleanup[this.threadId] + CLEANUP_INTERVAL < this.id) {
            ArrayList<Provider<? extends AbstractNode>> tmp;
            this.model.lastCleanup[this.threadId] = this.id;
            Map<Integer, Provider<? extends AbstractNode>> map = this.model.activeProviders;
            synchronized (map) {
                tmp = new ArrayList<Provider<? extends AbstractNode>>(this.model.activeProviders.values());
            }
            tmp.forEach(np -> {
                Object an = np.getIfNotSuspended();
                if (an != null && an instanceof Node) {
                    Node n = (Node)an;
                    Node.ThreadState th = n.threads[this.threadId];
                    if (th != null && th.lastUsed + (long)CLEANUP_INTERVAL < (long)this.id) {
                        n.threads[this.threadId] = null;
                    }
                }
            });
        }
        this.model.docs[this.threadId] = null;
    }

    public String generateOutputText() {
        StringBuilder sb = new StringBuilder();
        this.finallyActivatedNeurons.stream().filter(n -> n.outputText != null).forEach(n -> {
            for (Activation act : n.getFinalActivations(this)) {
                sb.replace(act.key.range.begin, act.key.range.end, n.outputText);
            }
        });
        return sb.toString();
    }

    public String activationsToString() {
        return this.activationsToString(true, false, false);
    }

    public String activationsToString(boolean finalOnly, boolean withTextSnippet, boolean withLogic) {
        TreeSet<NodeActivation> acts = new TreeSet<NodeActivation>(ACTIVATIONS_OUTPUT_COMPARATOR);
        for (INeuron n : this.activatedNeurons) {
            Stream<Activation> stream = Selector.select(this, n, null, null, null);
            acts.addAll(stream.collect(Collectors.toList()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Activation ID -");
        if (finalOnly) {
            sb.append(" Final Decision -");
        } else {
            sb.append(" Decision -");
        }
        sb.append(" Range" + (withTextSnippet ? " | Text Snippet" : ""));
        sb.append(" -");
        sb.append(" Neuron Label -");
        sb.append(withLogic ? " Logic Layer -" : "");
        sb.append(" Relational ID (Word Pos.) -");
        sb.append(" Upper Bound -");
        if (finalOnly) {
            sb.append(" Final Value | Final Weight | Final Norm -");
        } else {
            sb.append(" Simulation Rounds [Round | Value | Weight | Norm] -");
        }
        sb.append(" Input Value |");
        sb.append(" Target Value");
        sb.append("\n");
        sb.append("\n");
        for (Activation activation : acts) {
            if (activation.upperBound <= 0.0 && (activation.targetValue == null || activation.targetValue <= 0.0)) continue;
            sb.append(activation.toString(finalOnly, withTextSnippet, withLogic));
            sb.append("\n");
        }
        if (this.selectedSearchNode != null) {
            sb.append("\n Final SearchNode:" + this.selectedSearchNode.id + "  WeightSum:" + this.selectedSearchNode.accumulatedWeight.toString() + "\n");
        }
        return sb.toString();
    }

    public Stream<NodeActivation> getAllActivationsStream() {
        return this.activatedNodes.stream().flatMap(n -> n.getActivations(this).stream());
    }

    public void dumpOscillatingActivations() {
        this.activatedNeurons.stream().flatMap(n -> n.getActivations(this).stream()).filter(act -> act.rounds.getLastRound() != null && act.rounds.getLastRound() > MAX_ROUND - 5).forEach(act -> {
            log.error(act.id + " " + act.key + " " + (Object)((Object)act.decision) + " " + act.rounds);
            log.error(act.linksToString());
            log.error("");
        });
    }

    public class ValueQueue {
        public final ArrayList<TreeSet<Activation>> queue = new ArrayList();

        public void propagateActivationValue(int round, Activation act) {
            for (Activation.SynapseActivation sa : act.neuronOutputs) {
                int r = sa.synapse.key.isRecurrent ? round + 1 : round;
                this.add(r, sa.output);
            }
        }

        private void add(Activation act) {
            this.add(0, act);
            for (Activation.SynapseActivation sa : act.neuronOutputs) {
                if (!sa.synapse.key.isRecurrent) continue;
                this.add(0, sa.output);
            }
        }

        public void add(int round, Activation act) {
            TreeSet<Activation> q;
            if (act.rounds.isQueued(round) || act.decision == SearchNode.Decision.UNKNOWN) {
                return;
            }
            if (round < this.queue.size()) {
                q = this.queue.get(round);
            } else {
                assert (round == this.queue.size());
                q = new TreeSet(VALUE_QUEUE_COMP);
                this.queue.add(q);
            }
            act.rounds.setQueued(round, true);
            q.add(act);
        }

        public SearchNode.Weight process(SearchNode sn) {
            long v = Document.this.visitedCounter++;
            if (sn.getParent() != null && sn.getParent().candidate != null) {
                this.add(sn.getParent().candidate.activation);
            }
            SearchNode.Weight delta = SearchNode.Weight.ZERO;
            for (int round = 0; round < this.queue.size(); ++round) {
                TreeSet<Activation> q = this.queue.get(round);
                while (!q.isEmpty()) {
                    Activation act = q.pollFirst();
                    act.rounds.setQueued(round, false);
                    delta = delta.add(act.process(sn, round, v));
                }
            }
            return delta;
        }
    }

    public class UpperBoundQueue {
        public final ArrayDeque<Activation> queue = new ArrayDeque();

        public void add(Activation act) {
            if (!act.ubQueued) {
                act.ubQueued = true;
                this.queue.addLast(act);
            }
        }

        public boolean process() {
            boolean flag = false;
            while (!this.queue.isEmpty()) {
                flag = true;
                Activation act = this.queue.pollFirst();
                act.ubQueued = false;
                act.processBounds();
            }
            return flag;
        }
    }

    public class Queue {
        public final TreeSet<Node> queue = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                int r = Integer.compare(n1.level, n2.level);
                if (r != 0) {
                    return r;
                }
                Node.ThreadState th1 = n1.getThreadState(Document.this.threadId, true);
                Node.ThreadState th2 = n2.getThreadState(Document.this.threadId, true);
                return Long.compare(th1.queueId, th2.queueId);
            }
        });
        private long queueIdCounter = 0L;

        public void add(Node n) {
            Node.ThreadState th = n.getThreadState(Document.this.threadId, true);
            if (!th.isQueued) {
                th.isQueued = true;
                th.queueId = this.queueIdCounter++;
                this.queue.add(n);
            }
        }

        public void processChanges() {
            while (!this.queue.isEmpty()) {
                Node n = this.queue.pollFirst();
                Node.ThreadState th = n.getThreadState(Document.this.threadId, true);
                th.isQueued = false;
                n.processChanges(Document.this);
                if (!log.isDebugEnabled()) continue;
                log.debug("QueueId:" + th.queueId);
                log.debug(n.toString() + "\n");
                log.debug("\n" + Document.this.activationsToString(false, true, true));
            }
        }
    }
}

