/*
 * Decompiled with CFR 0.152.
 */
package org.aika;

import java.util.Comparator;

public class Utils {
    public static <T> boolean contains(T[] in, T x, Comparator<T> c) {
        for (T y : in) {
            if (c.compare(x, y) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean compareNullSafe(Integer a, Integer b) {
        if (a == null || b == null) {
            return true;
        }
        return a >= b;
    }

    public static int compareInteger(Integer a, Integer b) {
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a != null && b != null) {
            return Integer.compare(a, b);
        }
        return 0;
    }

    public static double round(double x) {
        return (double)Math.round(x * 1000.0) / 1000.0;
    }

    public static Integer nullSafeAdd(Integer a, boolean fa, Integer b, boolean fb) {
        if (b == null) {
            return fa ? a : null;
        }
        if (a == null) {
            return fb ? b : null;
        }
        return a + b;
    }

    public static Integer nullSafeSub(Integer a, boolean fa, Integer b, boolean fb) {
        if (b == null) {
            return fa ? a : null;
        }
        if (a == null) {
            return fb ? b : null;
        }
        return a - b;
    }

    public static Integer nullSafeMin(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Math.min(a, b);
    }

    public static Integer nullSafeMax(Integer a, Integer b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Math.max(a, b);
    }

    public static Double nullSafeMax(Double a, Double b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Math.max(a, b);
    }

    public static String collapseText(String txt, int length) {
        if (txt.length() <= 2 * length) {
            return txt;
        }
        return txt.substring(0, length) + "..." + txt.substring(txt.length() - length);
    }
}

